/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.server;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.services.server.AbstractSkeleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HessianSkeleton
extends AbstractSkeleton {
    private Object _service;

    public void invoke(HessianInput hessianInput, HessianOutput hessianOutput) throws Throwable {
        hessianInput.startCall();
        Method method = this.getMethod(hessianInput.getMethod());
        if (method == null) {
            if ("_hessian_getAttribute".equals(hessianInput.getMethod())) {
                String string = hessianInput.readString();
                hessianInput.completeCall();
                String string2 = null;
                if ("java.api.class".equals(string)) {
                    string2 = this.getAPIClassName();
                } else if ("java.home.class".equals(string)) {
                    string2 = this.getHomeClassName();
                } else if ("java.object.class".equals(string)) {
                    string2 = this.getObjectClassName();
                }
                hessianOutput.startReply();
                hessianOutput.writeObject(string2);
                hessianOutput.completeReply();
                return;
            }
            if (method == null) {
                hessianOutput.startReply();
                hessianOutput.writeFault("NoSuchMethodException", "The service has no method named: " + hessianInput.getMethod(), null);
                hessianOutput.completeReply();
                return;
            }
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            objectArray[n] = hessianInput.readObject(classArray[n]);
            ++n;
        }
        hessianInput.completeCall();
        Object object = null;
        try {
            object = method.invoke(this._service, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            hessianOutput.startReply();
            hessianOutput.writeFault("ServiceException", throwable2.getMessage(), throwable2);
            hessianOutput.completeReply();
            return;
        }
        hessianOutput.startReply();
        hessianOutput.writeObject(object);
        hessianOutput.completeReply();
    }

    public HessianSkeleton(Object object, Class clazz) {
        super(clazz);
        this._service = object;
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Service " + object + " must be an instance of " + clazz.getName());
        }
    }
}

