/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.mux;

import com.caucho.hessian.mux.MuxInputStream;
import com.caucho.hessian.mux.MuxOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MuxServer {
    private Object READ_LOCK;
    private Object WRITE_LOCK;
    private InputStream is;
    private OutputStream os;
    private boolean isClient;
    private transient boolean isClosed;
    private boolean[] inputReady;
    private boolean isReadLocked;
    private boolean isWriteLocked;

    public void init(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.is = inputStream;
        this.os = outputStream;
        this.isClient = bl;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public boolean startCall(MuxInputStream muxInputStream, MuxOutputStream muxOutputStream) throws IOException {
        int n = 3 - this.isClient;
        return this.startCall(n, muxInputStream, muxOutputStream);
    }

    public boolean startCall(int n, MuxInputStream muxInputStream, MuxOutputStream muxOutputStream) throws IOException {
        muxInputStream.init(this, n);
        muxOutputStream.init(this, n);
        return true;
    }

    public boolean readRequest(MuxInputStream muxInputStream, MuxOutputStream muxOutputStream) throws IOException {
        int n = this.isClient + 2;
        muxInputStream.init(this, n);
        muxOutputStream.init(this, n);
        if (this.readChannel(n) != null) {
            muxInputStream.setInputStream(this.is);
            muxInputStream.readToData(false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutputStream writeChannel(int n) throws IOException {
        while (this.os != null) {
            boolean bl = false;
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                block7: {
                    block6: {
                        if (this.isWriteLocked) break block6;
                        this.isWriteLocked = true;
                        bl = true;
                        break block7;
                    }
                    try {
                        this.WRITE_LOCK.wait(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) continue;
            }
            this.os.write(67);
            this.os.write(n >> 8);
            this.os.write(n);
            return this.os;
        }
        return null;
    }

    void yield(int n) throws IOException {
        this.os.write(89);
        this.freeWriteLock();
    }

    void flush(int n) throws IOException {
        this.os.write(89);
        this.os.flush();
        this.freeWriteLock();
    }

    void close(int n) throws IOException {
        if (this.os != null) {
            this.os.write(81);
            this.os.flush();
            this.freeWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void freeWriteLock() {
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            this.isWriteLocked = false;
            this.WRITE_LOCK.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream readChannel(int n) throws IOException {
        while (!this.isClosed) {
            if (this.inputReady[n]) {
                this.inputReady[n] = false;
                return this.is;
            }
            boolean bl = false;
            Object object = this.READ_LOCK;
            synchronized (object) {
                block10: {
                    block9: {
                        if (this.isReadLocked) break block9;
                        this.isReadLocked = true;
                        bl = true;
                        break block10;
                    }
                    try {
                        this.READ_LOCK.wait(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl) continue;
            }
            try {
                this.readData();
            }
            catch (IOException iOException) {
                this.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean getReadLock() {
        Object object = this.READ_LOCK;
        synchronized (object) {
            if (!this.isReadLocked) {
                this.isReadLocked = true;
                return true;
            }
            try {
                this.READ_LOCK.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void freeReadLock() {
        Object object = this.READ_LOCK;
        synchronized (object) {
            this.isReadLocked = false;
            this.READ_LOCK.notifyAll();
            return;
        }
    }

    private final void readData() throws IOException {
        while (!this.isClosed) {
            int n = this.is.read();
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 67: {
                    int n2 = (this.is.read() << 8) + this.is.read();
                    this.inputReady[n2] = true;
                    return;
                }
                case 69: {
                    int n3 = (this.is.read() << 8) + this.is.read();
                    int n4 = (this.is.read() << 8) + this.is.read();
                    this.inputReady[n3] = true;
                    return;
                }
                case -1: {
                    this.close();
                    return;
                }
                default: {
                    this.close();
                    return;
                }
            }
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
        OutputStream outputStream = this.os;
        this.os = null;
        InputStream inputStream = this.is;
        this.is = null;
        if (outputStream != null) {
            outputStream.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private final /* synthetic */ void this() {
        this.READ_LOCK = new Object();
        this.WRITE_LOCK = new Object();
        this.inputReady = new boolean[4];
    }

    public MuxServer() {
        this.this();
    }

    public MuxServer(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.this();
        this.init(inputStream, outputStream, bl);
    }
}

