/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;

public class HessianOutput
extends AbstractHessianOutput {
    protected OutputStream os;
    private IdentityHashMap _refs;

    public void init(OutputStream outputStream) {
        this.os = outputStream;
        this._refs = null;
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory();
        }
    }

    public void call(String string, Object[] objectArray) throws IOException {
        this.startCall(string);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.writeObject(objectArray[n]);
                ++n;
            }
        }
        this.completeCall();
    }

    public void startCall(String string) throws IOException {
        this.os.write(99);
        this.os.write(0);
        this.os.write(1);
        this.os.write(109);
        int n = string.length();
        this.os.write(n >> 8);
        this.os.write(n);
        this.printString(string, 0, n);
    }

    public void completeCall() throws IOException {
        this.os.write(122);
    }

    public void startReply() throws IOException {
        this.os.write(114);
        this.os.write(1);
        this.os.write(0);
    }

    public void completeReply() throws IOException {
        this.os.write(122);
    }

    public void writeHeader(String string) throws IOException {
        int n = string.length();
        this.os.write(72);
        this.os.write(n >> 8);
        this.os.write(n);
        this.printString(string);
    }

    public void writeFault(String string, String string2, Object object) throws IOException {
        this.os.write(102);
        this.writeString("code");
        this.writeString(string);
        this.writeString("message");
        this.writeString(string2);
        if (object != null) {
            this.writeString("detail");
            this.writeObject(object);
        }
        this.os.write(122);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        Serializer serializer = this._serializerFactory.getSerializer(object.getClass());
        serializer.writeObject(object, this);
    }

    public void writeListBegin(int n, String string) throws IOException {
        this.os.write(86);
        this.os.write(116);
        this.printLenString(string);
        this.os.write(108);
        this.os.write(n >> 24);
        this.os.write(n >> 16);
        this.os.write(n >> 8);
        this.os.write(n);
    }

    public void writeListEnd() throws IOException {
        this.os.write(122);
    }

    public void writeMapBegin(String string) throws IOException {
        this.os.write(77);
        this.os.write(116);
        this.printLenString(string);
    }

    public void writeMapEnd() throws IOException {
        this.os.write(122);
    }

    public void writeRemote(String string, String string2) throws IOException {
        this.os.write(114);
        this.os.write(116);
        this.printLenString(string);
        this.os.write(83);
        this.printLenString(string2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.os.write(84);
        } else {
            this.os.write(70);
        }
    }

    public void writeInt(int n) throws IOException {
        this.os.write(73);
        this.os.write(n >> 24);
        this.os.write(n >> 16);
        this.os.write(n >> 8);
        this.os.write(n);
    }

    public void writeLong(long l) throws IOException {
        this.os.write(76);
        this.os.write((byte)(l >> 56));
        this.os.write((byte)(l >> 48));
        this.os.write((byte)(l >> 40));
        this.os.write((byte)(l >> 32));
        this.os.write((byte)(l >> 24));
        this.os.write((byte)(l >> 16));
        this.os.write((byte)(l >> 8));
        this.os.write((byte)l);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        this.os.write(68);
        this.os.write((byte)(l >> 56));
        this.os.write((byte)(l >> 48));
        this.os.write((byte)(l >> 40));
        this.os.write((byte)(l >> 32));
        this.os.write((byte)(l >> 24));
        this.os.write((byte)(l >> 16));
        this.os.write((byte)(l >> 8));
        this.os.write((byte)l);
    }

    public void writeUTCDate(long l) throws IOException {
        this.os.write(100);
        this.os.write((byte)(l >> 56));
        this.os.write((byte)(l >> 48));
        this.os.write((byte)(l >> 40));
        this.os.write((byte)(l >> 32));
        this.os.write((byte)(l >> 24));
        this.os.write((byte)(l >> 16));
        this.os.write((byte)(l >> 8));
        this.os.write((byte)l);
    }

    public void writeNull() throws IOException {
        this.os.write(78);
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.os.write(78);
        } else {
            int n = string.length();
            int n2 = 0;
            while (n > 32768) {
                int n3 = 32768;
                this.os.write(115);
                this.os.write(n3 >> 8);
                this.os.write(n3);
                this.printString(string, n2, n3);
                n -= n3;
                n2 += n3;
            }
            this.os.write(83);
            this.os.write(n >> 8);
            this.os.write(n);
            this.printString(string, n2, n);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeString(char[] var1_1, int var2_2, int var3_3) throws IOException {
        block1: {
            if (var1_1 != null) ** GOTO lbl11
            this.os.write(78);
            break block1;
lbl-1000:
            // 1 sources

            {
                var4_4 = 32768;
                this.os.write(115);
                this.os.write(var4_4 >> 8);
                this.os.write(var4_4);
                this.printString(var1_1, var2_2, var4_4);
                var3_3 -= var4_4;
                var2_2 += var4_4;
lbl11:
                // 2 sources

                ** while (var3_3 > 32768)
            }
lbl12:
            // 1 sources

            this.os.write(83);
            this.os.write(var3_3 >> 8);
            this.os.write(var3_3);
            this.printString(var1_1, var2_2, var3_3);
        }
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.os.write(78);
        } else {
            this.writeBytes(byArray, 0, byArray.length);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeBytes(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        block1: {
            if (var1_1 != null) ** GOTO lbl11
            this.os.write(78);
            break block1;
lbl-1000:
            // 1 sources

            {
                var4_4 = 32768;
                this.os.write(98);
                this.os.write(var4_4 >> 8);
                this.os.write(var4_4);
                this.os.write(var1_1, var2_2, var4_4);
                var3_3 -= var4_4;
                var2_2 += var4_4;
lbl11:
                // 2 sources

                ** while (var3_3 > 32768)
            }
lbl12:
            // 1 sources

            this.os.write(66);
            this.os.write(var3_3 >> 8);
            this.os.write(var3_3);
            this.os.write(var1_1, var2_2, var3_3);
        }
    }

    public void writeByteBufferPart(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = n2;
            if (32768 < n3) {
                n3 = 32768;
            }
            this.os.write(98);
            this.os.write(n3 >> 8);
            this.os.write(n3);
            this.os.write(byArray, n, n3);
            n2 -= n3;
            n += n3;
        }
    }

    public void writeByteBufferEnd(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public void writeRef(int n) throws IOException {
        this.os.write(82);
        this.os.write(n << 24);
        this.os.write(n << 16);
        this.os.write(n << 8);
        this.os.write(n);
    }

    public void writePlaceholder() throws IOException {
        this.os.write(80);
    }

    public boolean addRef(Object object) throws IOException {
        Integer n;
        if (this._refs == null) {
            this._refs = new IdentityHashMap();
        }
        if ((n = (Integer)this._refs.get(object)) != null) {
            int n2 = n;
            this.writeRef(n2);
            return true;
        }
        this._refs.put(object, new Integer(this._refs.size()));
        return false;
    }

    public boolean removeRef(Object object) throws IOException {
        if (this._refs != null) {
            this._refs.remove(object);
            return true;
        }
        return false;
    }

    public boolean replaceRef(Object object, Object object2) throws IOException {
        Integer n = (Integer)this._refs.remove(object);
        if (n != null) {
            this._refs.put(object2, n);
            return true;
        }
        return false;
    }

    public void printLenString(String string) throws IOException {
        if (string == null) {
            this.os.write(0);
            this.os.write(0);
        } else {
            int n = string.length();
            this.os.write(n >> 8);
            this.os.write(n);
            this.printString(string, 0, n);
        }
    }

    public void printString(String string) throws IOException {
        this.printString(string, 0, string.length());
    }

    public void printString(String string, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3 + n);
            if (c < '\u0080') {
                this.os.write(c);
            } else if (c < '\u0800') {
                this.os.write(192 + (c >> 6 & 0x1F));
                this.os.write(128 + (c & 0x3F));
            } else {
                this.os.write(224 + (c >> 12 & 0xF));
                this.os.write(128 + (c >> 6 & 0x3F));
                this.os.write(128 + (c & 0x3F));
            }
            ++n3;
        }
    }

    public void printString(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3 + n];
            if (c < '\u0080') {
                this.os.write(c);
            } else if (c < '\u0800') {
                this.os.write(192 + (c >> 6 & 0x1F));
                this.os.write(128 + (c & 0x3F));
            } else {
                this.os.write(224 + (c >> 12 & 0xF));
                this.os.write(128 + (c >> 6 & 0x3F));
                this.os.write(128 + (c & 0x3F));
            }
            ++n3;
        }
    }

    public HessianOutput(OutputStream outputStream) {
        this.init(outputStream);
    }

    public HessianOutput() {
    }
}

