/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.client;

import com.caucho.burlap.client.BurlapProtocolException;
import com.caucho.burlap.client.BurlapRemote;
import com.caucho.burlap.client.BurlapServiceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MicroBurlapInput {
    private static int[] base64Decode = new int[256];
    private InputStream is;
    protected int peek;
    protected boolean peekTag;
    protected Date date;
    protected Calendar utcCalendar;
    private Calendar localCalendar;
    protected Vector refs;
    protected String method;
    protected StringBuffer sbuf;
    protected StringBuffer entity;

    public String getMethod() {
        return this.method;
    }

    public void init(InputStream inputStream) {
        this.is = inputStream;
        this.refs = null;
    }

    public void startCall() throws IOException {
        this.expectStartTag("burlap:call");
        this.expectStartTag("method");
        this.method = this.parseString();
        this.expectEndTag("method");
        this.refs = null;
    }

    public void completeCall() throws IOException {
        this.expectEndTag("burlap:call");
    }

    public Object readReply(Class clazz) throws Exception {
        if (this.startReply()) {
            Object object = this.readObject(clazz);
            this.expectEndTag("value");
            this.completeReply();
            return object;
        }
        Hashtable hashtable = this.readFault();
        Object v = hashtable.get("detail");
        if (v instanceof Exception) {
            throw (Exception)v;
        }
        String string = (String)hashtable.get("code");
        String string2 = (String)hashtable.get("message");
        throw new BurlapServiceException(string2, string, v);
    }

    public boolean startReply() throws IOException {
        this.refs = null;
        this.expectStartTag("burlap:reply");
        if (!this.parseTag()) {
            throw new BurlapProtocolException("expected <value>");
        }
        String string = this.sbuf.toString();
        if (string.equals("fault")) {
            this.peekTag = true;
            return false;
        }
        if (string.equals("value")) {
            return true;
        }
        throw this.expectBeginTag("value", string);
    }

    public void completeReply() throws IOException {
        this.expectEndTag("burlap:reply");
    }

    public boolean readBoolean() throws IOException {
        this.expectStartTag("boolean");
        int n = this.parseInt();
        this.expectEndTag("boolean");
        boolean bl = false;
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    public int readInt() throws IOException {
        this.expectStartTag("int");
        int n = this.parseInt();
        this.expectEndTag("int");
        return n;
    }

    public long readLong() throws IOException {
        this.expectStartTag("long");
        long l = this.parseLong();
        this.expectEndTag("long");
        return l;
    }

    public long readUTCDate() throws IOException {
        this.expectStartTag("date");
        if (this.utcCalendar == null) {
            this.utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        long l = this.parseDate(this.utcCalendar);
        this.expectEndTag("date");
        return l;
    }

    public long readLocalDate() throws IOException {
        this.expectStartTag("date");
        if (this.localCalendar == null) {
            this.localCalendar = Calendar.getInstance();
        }
        long l = this.parseDate(this.localCalendar);
        this.expectEndTag("date");
        return l;
    }

    public BurlapRemote readRemote() throws IOException {
        this.expectStartTag("remote");
        String string = this.readType();
        String string2 = this.readString();
        this.expectEndTag("remote");
        return new BurlapRemote(string, string2);
    }

    public String readString() throws IOException {
        if (!this.parseTag()) {
            throw new BurlapProtocolException("expected <string>");
        }
        String string = this.sbuf.toString();
        if (string.equals("null")) {
            this.expectEndTag("null");
            return null;
        }
        if (string.equals("string")) {
            this.sbuf.setLength(0);
            this.parseString(this.sbuf);
            String string2 = this.sbuf.toString();
            this.expectEndTag("string");
            return string2;
        }
        throw this.expectBeginTag("string", string);
    }

    public byte[] readBytes() throws IOException {
        if (!this.parseTag()) {
            throw new BurlapProtocolException("expected <base64>");
        }
        String string = this.sbuf.toString();
        if (string.equals("null")) {
            this.expectEndTag("null");
            return null;
        }
        if (string.equals("base64")) {
            this.sbuf.setLength(0);
            byte[] byArray = this.parseBytes();
            this.expectEndTag("base64");
            return byArray;
        }
        throw this.expectBeginTag("base64", string);
    }

    public Object readObject(Class clazz) throws IOException {
        if (!this.parseTag()) {
            throw new BurlapProtocolException("expected <tag>");
        }
        String string = this.sbuf.toString();
        if (string.equals("null")) {
            this.expectEndTag("null");
            return null;
        }
        if (string.equals("boolean")) {
            int n = this.parseInt();
            this.expectEndTag("boolean");
            boolean bl = false;
            if (n != 0) {
                bl = true;
            }
            return new Boolean(bl);
        }
        if (string.equals("int")) {
            int n = this.parseInt();
            this.expectEndTag("int");
            return new Integer(n);
        }
        if (string.equals("long")) {
            long l = this.parseLong();
            this.expectEndTag("long");
            return new Long(l);
        }
        if (string.equals("string")) {
            this.sbuf.setLength(0);
            this.parseString(this.sbuf);
            String string2 = this.sbuf.toString();
            this.expectEndTag("string");
            return string2;
        }
        if (string.equals("xml")) {
            this.sbuf.setLength(0);
            this.parseString(this.sbuf);
            String string3 = this.sbuf.toString();
            this.expectEndTag("xml");
            return string3;
        }
        if (string.equals("date")) {
            if (this.utcCalendar == null) {
                this.utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            }
            long l = this.parseDate(this.utcCalendar);
            this.expectEndTag("date");
            return new Date(l);
        }
        if (string.equals("map")) {
            String string4 = this.readType();
            return this.readMap(clazz, string4);
        }
        if (string.equals("list")) {
            String string5 = this.readType();
            int n = this.readLength();
            return this.readList(clazz, string5, n);
        }
        if (string.equals("ref")) {
            int n = this.parseInt();
            this.expectEndTag("ref");
            return this.refs.elementAt(n);
        }
        if (string.equals("remote")) {
            String string6 = this.readType();
            String string7 = this.readString();
            this.expectEndTag("remote");
            return this.resolveRemote(string6, string7);
        }
        return this.readExtensionObject(clazz, string);
    }

    public String readType() throws IOException {
        if (!this.parseTag()) {
            throw new BurlapProtocolException("expected <type>");
        }
        String string = this.sbuf.toString();
        if (!string.equals("type")) {
            throw new BurlapProtocolException("expected <type>");
        }
        this.sbuf.setLength(0);
        this.parseString(this.sbuf);
        String string2 = this.sbuf.toString();
        this.expectEndTag("type");
        return string2;
    }

    public int readLength() throws IOException {
        int n;
        this.expectStartTag("length");
        this.peek = n = this.skipWhitespace();
        if (n == 60) {
            this.expectEndTag("length");
            return -1;
        }
        int n2 = this.parseInt();
        this.expectEndTag("length");
        return n2;
    }

    public Object resolveRemote(String string, String string2) throws IOException {
        return new BurlapRemote(string, string2);
    }

    public Hashtable readFault() throws IOException {
        this.expectStartTag("fault");
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        while (this.parseTag()) {
            this.peekTag = true;
            Object object = this.readObject(null);
            Object object2 = this.readObject(null);
            if (object == null || object2 == null) continue;
            hashtable.put(object, object2);
        }
        if (!this.sbuf.toString().equals("fault")) {
            throw new BurlapProtocolException("expected </fault>");
        }
        return hashtable;
    }

    public Object readMap(Class clazz, String string) throws IOException {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        if (this.refs == null) {
            this.refs = new Vector();
        }
        this.refs.addElement(hashtable);
        while (this.parseTag()) {
            this.peekTag = true;
            Object object = this.readObject(null);
            Object object2 = this.readObject(null);
            hashtable.put(object, object2);
        }
        if (!this.sbuf.toString().equals("map")) {
            throw new BurlapProtocolException("expected </map>");
        }
        return hashtable;
    }

    protected Object readExtensionObject(Class clazz, String string) throws IOException {
        throw new BurlapProtocolException("unknown object tag <" + string + '>');
    }

    public Object readList(Class clazz, String string, int n) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        if (this.refs == null) {
            this.refs = new Vector();
        }
        this.refs.addElement(vector);
        while (this.parseTag()) {
            this.peekTag = true;
            Object object = this.readObject(null);
            vector.addElement(object);
        }
        if (!this.sbuf.toString().equals("list")) {
            throw new BurlapProtocolException("expected </list>");
        }
        return vector;
    }

    protected int parseInt() throws IOException {
        int n = 1;
        int n2 = 0;
        int n3 = this.skipWhitespace();
        if (n3 == 43) {
            n3 = this.read();
        } else if (n3 == 45) {
            n = -1;
            n3 = this.read();
        }
        while (n3 >= 48 && n3 <= 57) {
            n2 = 10 * n2 + n3 - 48;
            n3 = this.read();
        }
        this.peek = n3;
        return n * n2;
    }

    protected long parseLong() throws IOException {
        long l = 1L;
        long l2 = 0L;
        int n = this.skipWhitespace();
        if (n == 43) {
            n = this.read();
        } else if (n == 45) {
            l = -1;
            n = this.read();
        }
        while (n >= 48 && n <= 57) {
            l2 = 10L * l2 + (long)n - 48L;
            n = this.read();
        }
        this.peek = n;
        return l * l2;
    }

    protected long parseDate(Calendar calendar) throws IOException {
        int n = this.skipWhitespace();
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            if (n < 48 || n > 57) {
                throw this.expectedChar("year", n);
            }
            n2 = 10 * n2 + n - 48;
            n = this.read();
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        while (n4 < 2) {
            if (n < 48 || n > 57) {
                throw this.expectedChar("month", n);
            }
            n3 = 10 * n3 + n - 48;
            n = this.read();
            ++n4;
        }
        n4 = 0;
        int n5 = 0;
        while (n5 < 2) {
            if (n < 48 || n > 57) {
                throw this.expectedChar("day", n);
            }
            n4 = 10 * n4 + n - 48;
            n = this.read();
            ++n5;
        }
        if (n != 84) {
            throw this.expectedChar("`T'", n);
        }
        n = this.read();
        n5 = 0;
        int n6 = 0;
        while (n6 < 2) {
            if (n < 48 || n > 57) {
                throw this.expectedChar("hour", n);
            }
            n5 = 10 * n5 + n - 48;
            n = this.read();
            ++n6;
        }
        n6 = 0;
        int n7 = 0;
        while (n7 < 2) {
            if (n < 48 || n > 57) {
                throw this.expectedChar("minute", n);
            }
            n6 = 10 * n6 + n - 48;
            n = this.read();
            ++n7;
        }
        n7 = 0;
        int n8 = 0;
        while (n8 < 2) {
            if (n < 48 || n > 57) {
                throw this.expectedChar("second", n);
            }
            n7 = 10 * n7 + n - 48;
            n = this.read();
            ++n8;
        }
        while (n > 0 && n != 60) {
            n = this.read();
        }
        this.peek = n;
        calendar.set(1, n2);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        calendar.set(11, n5);
        calendar.set(12, n6);
        calendar.set(13, n7);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    protected String parseString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.parseString(stringBuffer).toString();
    }

    protected StringBuffer parseString(StringBuffer stringBuffer) throws IOException {
        int n = this.read();
        while (n >= 0 && n != 60) {
            if (n == 38) {
                n = this.read();
                if (n == 35) {
                    n = this.read();
                    if (n >= 48 && n <= 57) {
                        int n2 = 0;
                        while (n >= 48 && n <= 57) {
                            n2 = 10 * n2 + n - 48;
                            n = this.read();
                        }
                        stringBuffer.append((char)n2);
                    }
                } else {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while (n >= 97 && n <= 122) {
                        stringBuffer2.append((char)n);
                        n = this.read();
                    }
                    String string = stringBuffer2.toString();
                    if (string.equals("amp")) {
                        stringBuffer.append('&');
                    } else if (string.equals("apos")) {
                        stringBuffer.append('\'');
                    } else if (string.equals("quot")) {
                        stringBuffer.append('\"');
                    } else if (string.equals("lt")) {
                        stringBuffer.append('<');
                    } else if (string.equals("gt")) {
                        stringBuffer.append('>');
                    } else {
                        throw new BurlapProtocolException("unknown XML entity &" + string + "; at `" + (char)n + '\'');
                    }
                }
                if (n != 59) {
                    throw this.expectedChar("';'", n);
                }
            } else if (n < 128) {
                stringBuffer.append((char)n);
            } else if ((n & 0xE0) == 192) {
                int n3 = this.read();
                int n4 = ((n & 0x1F) << 6) + (n3 & 0x3F);
                stringBuffer.append((char)n4);
            } else if ((n & 0xF0) == 224) {
                int n5 = this.read();
                int n6 = this.read();
                int n7 = ((n & 0xF) << 12) + ((n5 & 0x3F) << 6) + (n6 & 0x3F);
                stringBuffer.append((char)n7);
            } else {
                throw new BurlapProtocolException("bad utf-8 encoding");
            }
            n = this.read();
        }
        this.peek = n;
        return stringBuffer;
    }

    protected byte[] parseBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.parseBytes(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected ByteArrayOutputStream parseBytes(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n = this.read();
        while (n >= 0 && n != 60) {
            int n2;
            int n3 = n;
            int n4 = this.read();
            int n5 = this.read();
            int n6 = this.read();
            if (n6 != 61) {
                n2 = (base64Decode[n3] << 18) + (base64Decode[n4] << 12) + (base64Decode[n5] << 6) + base64Decode[n6];
                byteArrayOutputStream.write(n2 >> 16);
                byteArrayOutputStream.write(n2 >> 8);
                byteArrayOutputStream.write(n2);
            } else if (n5 != 61) {
                n2 = (base64Decode[n3] << 12) + (base64Decode[n4] << 6) + base64Decode[n5];
                byteArrayOutputStream.write(n2 >> 8);
                byteArrayOutputStream.write(n2);
            } else {
                n2 = (base64Decode[n3] << 6) + base64Decode[n4];
                byteArrayOutputStream.write(n2);
            }
            n = this.read();
        }
        if (n == 60) {
            this.peek = n;
        }
        return byteArrayOutputStream;
    }

    protected void expectStartTag(String string) throws IOException {
        if (!this.parseTag()) {
            throw new BurlapProtocolException("expected <" + string + '>');
        }
        if (!this.sbuf.toString().equals(string)) {
            throw new BurlapProtocolException("expected <" + string + "> at <" + this.sbuf + '>');
        }
    }

    protected void expectEndTag(String string) throws IOException {
        if (this.parseTag()) {
            throw new BurlapProtocolException("expected </" + string + '>');
        }
        if (!this.sbuf.toString().equals(string)) {
            throw new BurlapProtocolException("expected </" + string + "> at </" + this.sbuf + '>');
        }
    }

    protected boolean parseTag() throws IOException {
        if (this.peekTag) {
            this.peekTag = false;
            return true;
        }
        int n = this.skipWhitespace();
        boolean bl = true;
        if (n != 60) {
            throw this.expectedChar("'<'", n);
        }
        n = this.read();
        if (n == 47) {
            bl = false;
            n = this.is.read();
        }
        if (!this.isTagChar(n)) {
            throw this.expectedChar("tag", n);
        }
        this.sbuf.setLength(0);
        while (this.isTagChar(n)) {
            this.sbuf.append((char)n);
            n = this.read();
        }
        if (n != 62) {
            throw this.expectedChar("'>'", n);
        }
        return bl;
    }

    protected IOException expectedChar(String string, int n) {
        return new BurlapProtocolException("expected " + string + " at " + (char)n + '\'');
    }

    protected IOException expectBeginTag(String string, String string2) {
        return new BurlapProtocolException("expected <" + string + "> at <" + string2 + '>');
    }

    private final boolean isTagChar(int n) {
        boolean bl = false;
        if (n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 58 || n == 45) {
            bl = true;
        }
        return bl;
    }

    protected int skipWhitespace() throws IOException {
        int n = this.read();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            n = this.read();
        }
        return n;
    }

    protected boolean isWhitespace(int n) throws IOException {
        boolean bl = false;
        if (n == 32 || n == 9 || n == 10 || n == 13) {
            bl = true;
        }
        return bl;
    }

    protected int read() throws IOException {
        if (this.peek > 0) {
            int n = this.peek;
            this.peek = 0;
            return n;
        }
        return this.is.read();
    }

    private final /* synthetic */ void this() {
        this.sbuf = new StringBuffer();
        this.entity = new StringBuffer();
    }

    public MicroBurlapInput(InputStream inputStream) {
        this.this();
        this.init(inputStream);
    }

    public MicroBurlapInput() {
        this.this();
    }

    static {
        int n = 65;
        while (n <= 90) {
            MicroBurlapInput.base64Decode[n] = n - 65;
            ++n;
        }
        n = 97;
        while (n <= 122) {
            MicroBurlapInput.base64Decode[n] = n - 97 + 26;
            ++n;
        }
        n = 48;
        while (n <= 57) {
            MicroBurlapInput.base64Decode[n] = n - 48 + 52;
            ++n;
        }
        MicroBurlapInput.base64Decode[43] = 62;
        MicroBurlapInput.base64Decode[47] = 63;
    }
}

