/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

public class ThreadBlocker {
    private boolean mBlocked = false;
    private boolean mWokenUp = false;
    private String mCancelMessage = null;

    public void blockNoThrow() {
        try {
            this.block();
        }
        catch (CancelledBlockException cancelledBlockException) {
            // empty catch block
        }
    }

    public synchronized void block() throws CancelledBlockException {
        this.mBlocked = true;
        while (!this.mWokenUp) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.cancel(interruptedException.toString());
            }
        }
        this.mBlocked = false;
        if (this.mCancelMessage != null) {
            throw new CancelledBlockException(this.mCancelMessage);
        }
    }

    public synchronized void wakeup() {
        this.mWokenUp = true;
        this.notifyAll();
    }

    public synchronized void cancel(String string) {
        this.mCancelMessage = string == null ? "" : string;
        this.wakeup();
    }

    synchronized boolean isBlocked() {
        return this.mBlocked;
    }

    public static class CancelledBlockException
    extends Exception {
        public CancelledBlockException(String string) {
            super(string);
        }
    }
}

