/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import RuntimeTool.DebugManager;
import com.intelerad.tools.lib.concurrent.AsynchronousCallable;
import com.intelerad.tools.lib.concurrent.BasicTaskController;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.CallListenerWrapper;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CompositeAsynchronousCallable;
import com.intelerad.tools.lib.concurrent.CompositeCallListener;
import com.intelerad.tools.lib.concurrent.CompositeCallListenerWrapper;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TaskControllerHelper {
    private Map mOutstandingTasks = new HashMap();
    private TaskControllerHelperListener mHelperListener;
    private BasicTaskController mBasicTaskController;

    public TaskControllerHelper(CallListener callListener, Invoker invoker, TaskControllerHelperListener taskControllerHelperListener) {
        Cancellable cancellable = new Cancellable(){

            public void cancel() {
                TaskControllerHelper.this.cancel();
            }
        };
        this.mBasicTaskController = new BasicTaskController(cancellable, callListener, invoker);
        this.mHelperListener = taskControllerHelperListener;
    }

    public TaskControllerHelper(CallListener callListener, Invoker invoker) {
        this(callListener, invoker, null);
    }

    public CompositeCallListener wrapComposite(CompositeCallListener compositeCallListener) {
        CompositeCallListenerWrapper compositeCallListenerWrapper = new CompositeCallListenerWrapper(compositeCallListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleFinally() {
                try {
                    super.handleFinally();
                }
                finally {
                    TaskControllerHelper.this.removeCancellablePrivate(this);
                }
            }
        };
        return compositeCallListenerWrapper;
    }

    public CallListener wrap(CallListener callListener) {
        CallListenerWrapper callListenerWrapper = new CallListenerWrapper(callListener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleFinally() {
                try {
                    super.handleFinally();
                }
                finally {
                    TaskControllerHelper.this.removeCancellablePrivate(this);
                }
            }
        };
        return callListenerWrapper;
    }

    public TaskController startNewTask(AsynchronousCallable asynchronousCallable, CallListener callListener) {
        CallListener callListener2 = this.wrap(callListener);
        TaskController taskController = asynchronousCallable.call(callListener2);
        this.addCancellablePrivate(callListener2, taskController);
        return taskController;
    }

    public TaskController startNewTask(CompositeAsynchronousCallable compositeAsynchronousCallable, CompositeCallListener compositeCallListener) {
        CompositeCallListener compositeCallListener2 = this.wrapComposite(compositeCallListener);
        TaskController taskController = compositeAsynchronousCallable.compositeCall(compositeCallListener2);
        this.addCancellablePrivate(compositeCallListener2, taskController);
        return taskController;
    }

    public boolean addCancellable(CallListener callListener, Cancellable cancellable) {
        return this.addCancellablePrivate(callListener, cancellable);
    }

    public boolean addCancellable(CompositeCallListener compositeCallListener, Cancellable cancellable) {
        return this.addCancellablePrivate(compositeCallListener, cancellable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCancellablePrivate(Object object, Cancellable cancellable) {
        BasicTaskController basicTaskController = this.mBasicTaskController;
        synchronized (basicTaskController) {
            if (this.mOutstandingTasks.containsKey(object)) {
                throw new IllegalStateException("Duplicate key");
            }
            this.mOutstandingTasks.put(object, cancellable);
            if (this.mBasicTaskController.isCancelled()) {
                cancellable.cancel();
            }
            return this.mBasicTaskController.isCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCancellablePrivate(Object object) {
        BasicTaskController basicTaskController = this.mBasicTaskController;
        synchronized (basicTaskController) {
            this.mOutstandingTasks.remove(object);
            if (this.isEmpty() && !this.mBasicTaskController.isCancelled() && !this.mBasicTaskController.hasTaskReturnedAResult()) {
                if (this.mHelperListener != null) {
                    this.mHelperListener.endOfTasks(this);
                }
                if (!this.mBasicTaskController.hasTaskReturnedAResult()) {
                    throw new IllegalStateException("setResult(), setException() or cancel() must be called in endOfTasks()!");
                }
            }
            return this.mBasicTaskController.isCancelled();
        }
    }

    public boolean removeCancellable(CompositeCallListener compositeCallListener) {
        return this.removeCancellablePrivate(compositeCallListener);
    }

    public boolean removeCancellable(CallListener callListener) {
        return this.removeCancellablePrivate(callListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        BasicTaskController basicTaskController = this.mBasicTaskController;
        synchronized (basicTaskController) {
            return this.mOutstandingTasks.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object object) {
        BasicTaskController basicTaskController = this.mBasicTaskController;
        synchronized (basicTaskController) {
            if (this.mBasicTaskController.hasTaskReturnedAResult()) {
                return;
            }
            this.mBasicTaskController.setResult(object);
            this.cancelOutstanding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Exception exception) {
        BasicTaskController basicTaskController = this.mBasicTaskController;
        synchronized (basicTaskController) {
            if (this.mBasicTaskController.hasTaskReturnedAResult()) {
                return;
            }
            this.mBasicTaskController.setException(exception);
            this.cancelOutstanding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        BasicTaskController basicTaskController = this.mBasicTaskController;
        synchronized (basicTaskController) {
            this.cancelOutstanding();
        }
    }

    private void cancelOutstanding() {
        Iterator iterator = new ArrayList(this.mOutstandingTasks.values()).iterator();
        while (iterator.hasNext()) {
            try {
                ((Cancellable)iterator.next()).cancel();
            }
            catch (Throwable throwable) {
                DebugManager.getDefault().printException("Error cancelling", throwable);
            }
        }
    }

    public TaskController getTaskController() {
        return this.mBasicTaskController;
    }

    public static interface TaskControllerHelperListener {
        public void endOfTasks(TaskControllerHelper var1);
    }
}

