/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import RuntimeTool.DebugManager;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.Callable;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CancellationException;
import com.intelerad.tools.lib.concurrent.ExecutionException;
import com.intelerad.tools.lib.concurrent.FunctionResult;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;

public final class BasicTaskController
implements TaskController {
    private CallListener mListener;
    private Invoker mInvoker;
    private boolean mTaskHasReturnedAResult;
    private boolean mCommittedToAResult;
    private boolean mCancelled;
    private Object mResult;
    private Throwable mException;
    private Cancellable mCancellable;
    private FunctionResult mGetFunctionResult;

    public BasicTaskController(Cancellable cancellable, CallListener callListener, Invoker invoker) {
        if (invoker == Invoker.SYNCHRONOUS_INVOKER) {
            throw new IllegalArgumentException("The synchronous invoker can never, ever, under any circumstances be used with the BasicTaskController. Ever. See Invoker and CallListener javadocs.");
        }
        this.mListener = callListener;
        this.mCancellable = cancellable;
        this.mInvoker = invoker;
    }

    public final synchronized void setResult(Object object) {
        if (this.hasTaskReturnedAResult()) {
            return;
        }
        this.mResult = object;
        this.fireRunnableIfNeeded();
    }

    public final synchronized void setException(Throwable throwable) {
        if (this.hasTaskReturnedAResult()) {
            return;
        }
        boolean bl2 = throwable instanceof Error;
        if (!bl2 && !(throwable instanceof Exception)) {
            throw new IllegalArgumentException("Throwable argument must be either an exception or an Error - " + throwable);
        }
        this.mException = bl2 ? new UnexpectedErrorException(throwable) : throwable;
        this.fireRunnableIfNeeded();
    }

    final synchronized boolean hasTaskReturnedAResult() {
        return this.mTaskHasReturnedAResult;
    }

    private final synchronized void fireRunnableIfNeeded() {
        if (this.hasTaskReturnedAResult()) {
            return;
        }
        this.mTaskHasReturnedAResult = true;
        this.notifyAll();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BasicTaskController.this.getRunnable().run();
                }
                finally {
                    BasicTaskController.this.mListener.handleFinally();
                }
            }
        };
        this.mInvoker.invoke(runnable);
    }

    private final Runnable getRunnable() {
        try {
            final Object object = this.getPrivate();
            return new Runnable(){

                public void run() {
                    BasicTaskController.this.mListener.handleSuccess(object);
                }
            };
        }
        catch (CancellationException cancellationException) {
            return new Runnable(){

                public void run() {
                    BasicTaskController.this.mListener.handleCancel();
                }
            };
        }
        catch (ExecutionException executionException) {
            return new Runnable(){

                public void run() {
                    if (executionException.getCause() instanceof Exception) {
                        BasicTaskController.this.mListener.handleException((Exception)executionException.getCause());
                    } else {
                        BasicTaskController.this.mListener.handleException(executionException);
                    }
                }
            };
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        BasicTaskController basicTaskController = this;
        synchronized (basicTaskController) {
            if (this.mCommittedToAResult) {
                return;
            }
            if (this.mCancelled) {
                return;
            }
            this.mCancelled = true;
            this.fireRunnableIfNeeded();
        }
        try {
            this.mCancellable.cancel();
        }
        catch (Throwable throwable) {
            DebugManager.getDefault().printException("Unexpected exception while cancelling", throwable);
        }
    }

    public final synchronized Object get() throws ExecutionException, InterruptedException {
        while (!this.hasTaskReturnedAResult()) {
            this.wait();
        }
        return this.getPrivate();
    }

    private final synchronized Object getPrivate() throws ExecutionException, CancellationException {
        this.mCommittedToAResult = true;
        if (this.mGetFunctionResult == null) {
            Callable callable = new Callable(){

                public Object call() throws Exception {
                    if (BasicTaskController.this.isCancelled()) {
                        throw new CancellationException();
                    }
                    if (BasicTaskController.this.mException != null) {
                        throw new ExecutionException(BasicTaskController.this.mException);
                    }
                    return BasicTaskController.this.mResult;
                }
            };
            this.mGetFunctionResult = FunctionResult.saveFunctionResult(callable);
        }
        try {
            return this.mGetFunctionResult.call();
        }
        catch (ExecutionException executionException) {
            throw executionException;
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized boolean isCancelled() {
        return this.mCancelled;
    }

    public synchronized boolean isDone() {
        return this.mTaskHasReturnedAResult;
    }

    private static class UnexpectedErrorException
    extends RuntimeException {
        public UnexpectedErrorException(Throwable throwable) {
            super(throwable);
        }
    }
}

