/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.CompositeCallListener;
import com.intelerad.tools.lib.concurrent.ExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AccumulatingCallListener
implements CompositeCallListener {
    private Map mResults = new HashMap();
    private CallListener mFinalListener;

    public AccumulatingCallListener(CallListener callListener) {
        this.mFinalListener = callListener;
    }

    public void handlePartialSuccess(Object object, Object object2) {
        this.mResults.put(object2, object);
    }

    public void handlePartialException(Exception exception, Object object) {
        this.mResults.put(object, new ExecutionException(exception));
    }

    public void handleCancel() {
        this.mResults = null;
        this.mFinalListener.handleCancel();
    }

    public void handleFinally() {
        if (this.mResults != null) {
            this.mFinalListener.handleSuccess(this.mResults);
        }
        this.mFinalListener.handleFinally();
    }

    public static List extractExceptions(Map map) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            if (!(v2 instanceof ExecutionException)) continue;
            arrayList.add(v2);
        }
        return arrayList;
    }

    public static boolean logErrors(String string, Map map) {
        boolean bl2 = false;
        Debug debug = DebugManager.getDefault();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof ExecutionException)) continue;
            bl2 = true;
            debug.printException(string + " : " + entry.getKey(), (Throwable)entry.getValue());
        }
        return bl2;
    }

    public static List extractResults(Map map) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            if (v2 instanceof Throwable) continue;
            if (v2 instanceof Collection) {
                arrayList.addAll((Collection)v2);
                continue;
            }
            arrayList.add(v2);
        }
        return arrayList;
    }
}

