/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib;

import StringUtilities.StringConverter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class RandomSource {
    private static final String RANDOM_SOURCE = "/dev/urandom";
    private static RandomSource mInstance = null;
    private InputStream mRandomFile;

    public static RandomSource getInstance() {
        if (mInstance == null) {
            mInstance = new RandomSource(RANDOM_SOURCE);
        }
        return mInstance;
    }

    private RandomSource(String string) {
        try {
            this.mRandomFile = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("random source '" + string + "' not found");
        }
    }

    public byte[] readBytes(int n2) {
        byte[] byArray = new byte[n2];
        try {
            int n3 = this.mRandomFile.read(byArray);
            if (n3 != n2) {
                throw new IllegalStateException("requested " + n2 + " bytes from " + RANDOM_SOURCE + ", but got " + n3);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to read from random source /dev/urandom: " + iOException.toString());
        }
        return byArray;
    }

    public String encodeBytes(int n2) {
        return StringConverter.hexString(this.readBytes(n2));
    }
}

