/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.roamingprofiles.inteleviewer;

import RuntimeTool.ControlFile;
import StringUtilities.StringCheck;
import StringUtilities.StringEscape;
import com.intelerad.datamodels.userprofile.RoamingTemplate;
import com.intelerad.datamodels.userprofile.RoamingTemplateIdentifier;
import com.intelerad.roamingprofiles.inteleviewer.InteleViewerTemplateConstants;
import com.intelerad.roamingprofiles.inteleviewer.InteleViewerTemplateUtilities;
import java.util.Iterator;

public class InteleViewerGeneralSiteDefaultConverter {
    private static final String CF_USE_MODALITY_SPECIFIC_SETTING = "Use_Modality_Specific_Setting";
    private static final String CF_COMPRESSION_RATIO = "Compression_Ratio";
    private static final String CF_DEFAULT_WINDOW_LEVEL = "Default_Window_Level";
    private static final String CF_FALLBACK_WINDOW_LEVEL = "Fallback_Window_Level";
    private static final String CF_WINDOW_LEVEL_PRESETS = "Window_Level_Presets";
    private static final String CF_PRESET_KEY_CODE = "Preset_Key_Code";
    private static final String CF_PRESET_NAME = "Preset_Name";
    private static final String CF_WINDOW_LEVEL_WIDTH = "Window_Level_Width";
    private static final String CF_WINDOW_LEVEL_CENTRE = "Window_Level_Centre";
    private static final String RP_USE_MODALITY_SPECIFIC_SETTING = "Use Modality Specific Setting";
    private static final String RP_COMPRESSION_RATIO = "Compression Ratio";
    private static final String RP_WINDOW_LEVEL = "Window Level";
    private static final String RP_FALLBACK_WINDOW_LEVEL = "Fallback Window Level";
    private static final String RP_WINDOW_LEVEL_PRESETS = "Window Level Presets";
    private static final int MAXIMUM_WINDOW_LEVEL_PRESETS = 10;
    private static final char ESCAPE_CHAR = '\\';
    private static final char SEPARATOR_CHAR = '|';
    private final ControlFile mInteleViewerSiteDefaults;
    private final String mTemplateName;
    private final boolean mForceLosslessCompressionRatio;

    public static RoamingTemplate createTemplate(ControlFile controlFile, String string, boolean bl2) {
        return new InteleViewerGeneralSiteDefaultConverter(controlFile, string, bl2).convertConfigToTemplate();
    }

    private InteleViewerGeneralSiteDefaultConverter(ControlFile controlFile, String string, boolean bl2) {
        this.mInteleViewerSiteDefaults = controlFile;
        this.mTemplateName = string;
        this.mForceLosslessCompressionRatio = bl2;
    }

    private RoamingTemplate convertConfigToTemplate() {
        RoamingTemplateIdentifier roamingTemplateIdentifier = new RoamingTemplateIdentifier(this.mTemplateName, InteleViewerTemplateConstants.GENERAL_CATEGORY, InteleViewerTemplateConstants.INTELEVIEWER_CONTEXT);
        RoamingTemplate roamingTemplate = new RoamingTemplate(roamingTemplateIdentifier);
        Iterator iterator = InteleViewerTemplateUtilities.getModalityStrings().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addModalityPreferences(roamingTemplate, string, this.mForceLosslessCompressionRatio);
        }
        this.addDefaultModalityPreference(roamingTemplate);
        return roamingTemplate;
    }

    private void addDefaultModalityPreference(RoamingTemplate roamingTemplate) {
        if (this.mForceLosslessCompressionRatio) {
            roamingTemplate.put(InteleViewerTemplateUtilities.getTemplateModalityPrefix("") + RP_COMPRESSION_RATIO, "1.0");
        }
    }

    private void addModalityPreferences(RoamingTemplate roamingTemplate, String string, boolean bl2) {
        String string2;
        String string3;
        Double d2;
        String string4 = InteleViewerTemplateUtilities.getSiteDefaultModalityPrefix(string);
        String string5 = InteleViewerTemplateUtilities.getTemplateModalityPrefix(string) + "/";
        Boolean bl3 = this.getBooleanSitePref(string4 + CF_USE_MODALITY_SPECIFIC_SETTING);
        if (bl3 != null) {
            roamingTemplate.put(string5 + RP_USE_MODALITY_SPECIFIC_SETTING, bl3.toString());
        }
        Double d3 = d2 = bl2 ? new Double(1.0) : this.getDoubleSitePref(string4 + CF_COMPRESSION_RATIO);
        if (d2 != null) {
            roamingTemplate.put(string5 + RP_COMPRESSION_RATIO, d2.toString());
        }
        if (!StringCheck.isStringBlank(string3 = this.mInteleViewerSiteDefaults.GetStringValue("CLINICAL_VIEWER_SITE_PREFERENCES", string4 + CF_DEFAULT_WINDOW_LEVEL))) {
            roamingTemplate.put(string5 + RP_WINDOW_LEVEL, string3);
        }
        if (!StringCheck.isStringBlank(string2 = this.mInteleViewerSiteDefaults.GetStringValue("CLINICAL_VIEWER_SITE_PREFERENCES", string4 + CF_FALLBACK_WINDOW_LEVEL))) {
            roamingTemplate.put(string5 + RP_FALLBACK_WINDOW_LEVEL, string2);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            String string6 = this.getPresetSitePref(string4 + CF_WINDOW_LEVEL_PRESETS + "-" + i2 + "-");
            if (string6 == null) continue;
            roamingTemplate.put(string5 + RP_WINDOW_LEVEL_PRESETS + "/" + i2, string6);
        }
    }

    private Boolean getBooleanSitePref(String string) {
        try {
            return new Boolean(this.mInteleViewerSiteDefaults.GetBooleanValue("CLINICAL_VIEWER_SITE_PREFERENCES", string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Double getDoubleSitePref(String string) {
        try {
            return new Double(this.mInteleViewerSiteDefaults.GetDoubleValue("CLINICAL_VIEWER_SITE_PREFERENCES", string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String getPresetSitePref(String string) {
        try {
            int n2 = this.mInteleViewerSiteDefaults.GetIntValue("CLINICAL_VIEWER_SITE_PREFERENCES", string + CF_PRESET_KEY_CODE);
            String string2 = this.mInteleViewerSiteDefaults.GetStringValue("CLINICAL_VIEWER_SITE_PREFERENCES", string + CF_PRESET_NAME);
            double d2 = this.mInteleViewerSiteDefaults.GetDoubleValue("CLINICAL_VIEWER_SITE_PREFERENCES", string + CF_WINDOW_LEVEL_WIDTH);
            double d3 = this.mInteleViewerSiteDefaults.GetDoubleValue("CLINICAL_VIEWER_SITE_PREFERENCES", string + CF_WINDOW_LEVEL_CENTRE);
            if (StringCheck.isStringBlank(string2)) {
                return null;
            }
            return StringEscape.createEscapedSeparatedString(new String[]{n2 + "", string2, String.valueOf(d2), String.valueOf(d3)}, '|', '\\');
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

