/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.serialization.protocol;

import RuntimeTool.DebugManager;
import com.intelerad.lib.serialization.exception.AuthorizationException;
import com.intelerad.lib.serialization.exception.CommunicationException;
import com.intelerad.lib.serialization.exception.ServiceException;
import com.intelerad.lib.serialization.exception.UnsupportedProtocolException;
import com.intelerad.lib.serialization.protocol.Protocol;
import com.intelerad.lib.serialization.protocol.ProtocolCatalog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractProtocol
implements Protocol {
    private Map mTransferClasses = new TreeMap();
    private Map mNewClassNames = new HashMap();
    private Map mOldClassNames = new HashMap();
    private Set mExceptions = new HashSet();

    public AbstractProtocol() {
        ProtocolCatalog.getInstance().addProtocol(this);
        this.addException(ServiceException.class);
        this.addException(AuthorizationException.class);
        this.addException(CommunicationException.class);
        this.addException(UnsupportedProtocolException.class);
    }

    protected void addTransferClass(Class clazz, Class clazz2) {
        DebugManager.getDefault().printDebug(this.getName() + " transfer object for " + clazz.getName() + ": " + clazz2.getName());
        this.mTransferClasses.put(clazz.getName(), clazz2);
    }

    protected void addException(Class clazz) {
        this.mExceptions.add(clazz.getName());
    }

    protected void setNewClassName(Class clazz, String string) {
        this.mNewClassNames.put(string, clazz.getName());
        this.mOldClassNames.put(clazz.getName(), string);
    }

    protected static String getUnqualifiedClassName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public List getKnownClasses() {
        return new ArrayList(this.mTransferClasses.keySet());
    }

    public List getKnownExceptions() {
        return new ArrayList(this.mExceptions);
    }

    public List getTransferClasses() {
        return new ArrayList(this.mTransferClasses.values());
    }

    public boolean knows(String string) {
        return this.mTransferClasses.containsKey(string);
    }

    public boolean knowsException(String string) {
        return this.mExceptions.contains(string);
    }

    public Class getTransferClass(Class clazz) {
        if (!this.knows(clazz.getName())) {
            throw new IllegalArgumentException("Class " + clazz.getName() + "is unknown to Protocol " + this.getName());
        }
        return (Class)this.mTransferClasses.get(clazz.getName());
    }

    public Object getTransferObject(Object object) {
        String string = object.getClass().getName();
        if (!this.knows(string)) {
            throw new IllegalArgumentException("Class " + string + "is unknown to Protocol " + this.getName());
        }
        Class clazz = (Class)this.mTransferClasses.get(string);
        try {
            Constructor constructor = clazz.getConstructor(object.getClass());
            return constructor.newInstance(object);
        }
        catch (Exception exception) {
            String string2 = "Cannot create transfer object for class " + object.getClass();
            DebugManager.getDefault().printException(string2, exception);
            throw new IllegalArgumentException(string2 + ": " + exception.getMessage());
        }
    }

    public String resolveClassName(String string) {
        if (this.mNewClassNames.containsKey(string)) {
            return (String)this.mNewClassNames.get(string);
        }
        if (this.mOldClassNames.containsKey(string)) {
            return (String)this.mOldClassNames.get(string);
        }
        return string;
    }

    public String getMajorVersion() {
        return AbstractProtocol.getUnqualifiedClassName(this.getClass().getName());
    }

    public String getName() {
        return this.getMajorVersion() + "." + this.getMinorVersion();
    }
}

