/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.process;

import RuntimeTool.Debug;
import RuntimeTool.DebugManager;
import StringUtilities.ToString;
import com.intelerad.lib.process.CommandLauncher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;

public class UrlLauncher {
    private static final String URL_FILE_SUFFIX = ".url";
    private URL mUrl;
    private Debug mDebug;
    private boolean mDeleteOldTempFiles;
    private String mTempFilePrefix;

    public UrlLauncher(URL uRL, String string, boolean bl2) {
        this.mUrl = uRL;
        this.mTempFilePrefix = string;
        this.mDeleteOldTempFiles = bl2;
        this.mDebug = DebugManager.getDefault();
    }

    public Process launch() throws IOException {
        if ("Linux".equals(System.getProperty("os.name"))) {
            return this.linuxLaunch();
        }
        File file = this.createUrlFile(this.mUrl.toExternalForm());
        Process process = this.launchUrlFile(file);
        new Thread(new FileRemover(process, file)).start();
        return process;
    }

    private Process linuxLaunch() throws IOException {
        CommandLauncher commandLauncher = new CommandLauncher("Linux Browser", "htmlview");
        commandLauncher.appendParameter(this.mUrl.toExternalForm());
        return commandLauncher.launch();
    }

    private Process launchUrlFile(File file) throws IOException {
        CommandLauncher commandLauncher = new CommandLauncher("rundll32.exe", "rundll32.exe");
        commandLauncher.appendParameter("shdocvw.dll,OpenURL");
        commandLauncher.appendParameter(file.getAbsolutePath());
        return commandLauncher.launch();
    }

    private File createUrlFile(String string) throws IOException {
        File file = File.createTempFile(this.mTempFilePrefix, URL_FILE_SUFFIX);
        file.deleteOnExit();
        String string2 = "[InternetShortcut]\nURL=" + string;
        this.mDebug.printTrace("Creating temporary URL file: '" + file.getAbsolutePath() + "'," + "contents: [" + string2 + "]");
        if (this.mDeleteOldTempFiles) {
            this.deleteTempUrlFiles(file);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));
        bufferedWriter.write(string2);
        bufferedWriter.close();
        return file;
    }

    private void deleteTempUrlFiles(final File file) {
        File file2 = file.getParentFile();
        this.mDebug.printTrace("Finding and deleting temp URL files in " + file2.getAbsolutePath() + " except for " + file.getName());
        Object[] objectArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file2, String string) {
                return !string.equals(file.getName()) && string.startsWith(UrlLauncher.this.mTempFilePrefix) && string.endsWith(UrlLauncher.URL_FILE_SUFFIX);
            }
        });
        this.mDebug.printTrace("Temp URL files to delete: " + ToString.array(objectArray));
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            this.mDebug.printTrace("Deleting temp URL file " + ((File)object).getName());
            ((File)object).delete();
        }
    }

    private static class FileRemover
    implements Runnable {
        private final Process mProcess;
        private final File mFile;

        public FileRemover(Process process, File file) {
            this.mProcess = process;
            this.mFile = file;
        }

        public void run() {
            while (true) {
                try {
                    this.mProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.mFile.delete();
        }
    }
}

