/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools.metrics;

import TimeUtilities.StopWatch;
import com.intelerad.lib.dicomtools.metrics.PixelFileMetrics;

class PixelFileMetricsImpl
implements PixelFileMetrics {
    private volatile long mDataWritten = 0L;
    private volatile long mDataRead = 0L;
    private StopWatch mWriteIOWatch;
    private StopWatch mReadIOWatch;
    private StopWatch mWriteImageWatch;
    private StopWatch mReadImageWatch;

    public PixelFileMetricsImpl() {
        this(StopWatch.DEFAULT_STOP_WATCH_FACTORY);
    }

    public PixelFileMetricsImpl(StopWatch.StopWatchFactory stopWatchFactory) {
        this.mWriteImageWatch = stopWatchFactory.createStopWatch();
        this.mWriteIOWatch = stopWatchFactory.createStopWatch();
        this.mReadIOWatch = stopWatchFactory.createStopWatch();
        this.mReadImageWatch = stopWatchFactory.createStopWatch();
    }

    public void addDataWritten(int n2) {
        this.mDataWritten += (long)n2;
    }

    public void addDataRead(int n2) {
        this.mDataRead += (long)n2;
    }

    public void writeIOStarted() {
        this.mWriteIOWatch.start();
    }

    public void writeIOFinished() {
        this.mWriteIOWatch.stop();
    }

    public void readIOFinished() {
        this.mReadIOWatch.stop();
    }

    public void readIOStarted() {
        this.mReadIOWatch.start();
    }

    public void writeImageStarted() {
        this.mWriteImageWatch.start();
    }

    public void writeImageFinished() {
        this.mWriteImageWatch.stop();
    }

    public void readImageFinished() {
        this.mReadImageWatch.stop();
    }

    public void readImageStarted() {
        this.mReadImageWatch.start();
    }

    public long getDataRead() {
        return this.mDataRead;
    }

    public long getDataWritten() {
        return this.mDataWritten;
    }

    public long getCumulativeReadIOTime() {
        return this.mReadIOWatch.getCumulativeTime();
    }

    public long getCumulativeReadImageTime() {
        return this.mReadImageWatch.getCumulativeTime();
    }

    public long getCumulativeWriteIOTime() {
        return this.mWriteIOWatch.getCumulativeTime();
    }

    public long getCumulativeWriteImageTime() {
        return this.mWriteImageWatch.getCumulativeTime();
    }
}

