/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import StringUtilities.StringCheck;
import StringUtilities.StringSplit;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class Uid {
    public static final int UID_MAX_LENGTH = 64;
    public static final String IMS_UID_ROOT = "1.2.840.114202";
    static final String STUDY_UID_ALGORITHM_CODE = "1";
    static final String RANDOM_UID_ALGORITHM_CODE = "2";
    static final String STUDY_AND_TIME_UID_ALGORITHM_CODE = "3";
    static final String STUDY_UID_MD5_ALGORITHM_CODE = "4";
    static final String CONSTANT_UID_ALGORITHM_CODE = "5";
    public static final String IMS_IMPLEMENTATION_CLASS_UID = "1.2.840.114202.5.3";
    public static final String SOP_UID_MD5_ALGORITHM_CODE = "6";
    public static final String JAVA_DICOM_DIR_BUILDER_IMPLEMENTATION_CLASS_UID = "1.2.840.114202.5.1";
    public static final String JAVA_DICOM_FILE_IMPLEMENTATION_CLASS_UID = "1.2.840.114202.5.2";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getNewSopInstanceUid(String string, String string2, String string3) throws ParseException {
        if (StringCheck.isStringBlank(string)) {
            throw new ParseException("Original SOP instance UID is empty or null", 0);
        }
        if (StringCheck.isStringBlank(string2)) {
            throw new ParseException("Source AE is empty or null", 0);
        }
        if (StringCheck.isStringBlank(string3)) {
            throw new ParseException("Organization code is empty or null", 0);
        }
        String string4 = Uid.getUnverifiedSopInstanceUid(string, string2, string3);
        return Uid.getVerifiedUid(string4);
    }

    public static String getNewStudyInstanceUid(String string, String string2, String string3, String string4) throws ParseException {
        return Uid.getNewStudyInstanceUid(string, string2, string3, string4, false);
    }

    public static String getNewStudyInstanceUid(String string, String string2, String string3, String string4, boolean bl2) throws ParseException {
        Object object;
        String string5 = "";
        if (StringCheck.isStringEmpty(string)) {
            throw new ParseException("PatientId is empty or null", 0);
        }
        if (StringCheck.isStringEmpty(string4)) {
            throw new ParseException("OrganizationCode is empty or null", 0);
        }
        if (StringCheck.isStringEmpty(string2)) {
            throw new ParseException("AccessionNumber is empty or null", 0);
        }
        if (bl2) {
            object = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            string5 = simpleDateFormat.format(((Calendar)object).getTime());
        }
        object = Uid.getUnverifiedStudyInstanceUid(string5, string, string2, string3, string4);
        return Uid.getVerifiedUid((String)object);
    }

    static String getUnverifiedStudyInstanceUid(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!StringCheck.isStringEmpty(string)) {
            stringBuffer.append(string).append('?');
        }
        stringBuffer.append(string5).append('?');
        stringBuffer.append(string2).append('?');
        stringBuffer.append(string3).append('?');
        stringBuffer.append(string4);
        return Uid.getMd5Uid(STUDY_UID_MD5_ALGORITHM_CODE, stringBuffer.toString());
    }

    static String getUnverifiedSopInstanceUid(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('?').append(string3).append('?').append(string2);
        return Uid.getMd5Uid(SOP_UID_MD5_ALGORITHM_CODE, stringBuffer.toString());
    }

    static String getVerifiedUid(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = StringSplit.split(string, ".");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.startsWith("0") && string2.length() > 1) {
                StringBuffer stringBuffer2 = new StringBuffer(string2.length());
                for (int i2 = 0; i2 < string2.length() - 1; ++i2) {
                    char c2 = string2.charAt(i2);
                    if (c2 == '0') continue;
                    stringBuffer2.append(c2);
                }
                stringBuffer2.append(string2.charAt(string2.length() - 1));
                string2 = stringBuffer2.toString();
            }
            stringBuffer.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static boolean verifyUid(String string) {
        if (string.equals("0")) {
            return false;
        }
        String string2 = Uid.getVerifiedUid(string);
        return string2.equals(string) && string.length() <= 64;
    }

    public static String getRandomUid() {
        StringBuffer stringBuffer = new StringBuffer("1.2.840.114202.2.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        stringBuffer.append(simpleDateFormat.format(Calendar.getInstance().getTime()));
        stringBuffer.append(".");
        int n2 = (int)(Math.random() * 2.147483647E9);
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    static String getMd5Uid(String string, String string2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IllegalStateException illegalStateException = new IllegalStateException(noSuchAlgorithmException.getMessage());
            illegalStateException.setStackTrace(noSuchAlgorithmException.getStackTrace());
            throw illegalStateException;
        }
        messageDigest.update(string2.getBytes());
        String string3 = "1.2.840.114202." + string + Uid.convertDigest(messageDigest.digest());
        if (!$assertionsDisabled && string3.length() > 64) {
            throw new AssertionError();
        }
        return string3;
    }

    static String convertDigest(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 5 - byArray.length % 4;
        long l2 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 = l2 * 256L + (long)(0xFF & byArray[i2]);
            if ((i2 + n2) % 4 != 0) continue;
            stringBuffer.append(".").append(Long.toString(l2));
            l2 = 0L;
        }
        if (!$assertionsDisabled && l2 != 0L) {
            throw new AssertionError();
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !Uid.class.desiredAssertionStatus();
    }
}

