/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.TagValue;
import com.intelerad.lib.dicomtools.DicomObjectUpdater;
import com.intelerad.lib.dicomtools.PrivateElement;
import java.util.Enumeration;
import java.util.HashSet;

public class PrivateGroupStripper
implements DicomObjectUpdater {
    private final boolean mPreserveImsInstitution;

    public PrivateGroupStripper(boolean bl2) {
        this.mPreserveImsInstitution = bl2;
    }

    public void update(DicomObject dicomObject) throws DicomException {
        String string = null;
        if (this.mPreserveImsInstitution) {
            string = PrivateElement.getImsInstitution(dicomObject);
        }
        DicomObject dicomObject2 = this.copyNonPrivateGroups(dicomObject);
        dicomObject.clear();
        dicomObject.addGroups(dicomObject2);
        if (string != null) {
            PrivateElement.setImsInstitution(dicomObject, string, true);
        }
    }

    private DicomObject copyNonPrivateGroups(DicomObject dicomObject) {
        DicomObject dicomObject2 = new DicomObject();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Enumeration enumeration = dicomObject.enumerateVRs(false);
        while (enumeration.hasMoreElements()) {
            TagValue tagValue = (TagValue)enumeration.nextElement();
            Integer n2 = new Integer(tagValue.getGroup());
            if ((n2 & 1) != 0 || hashSet.contains(n2)) continue;
            hashSet.add(n2);
            dicomObject2.addGroups(dicomObject.copyGroup(n2.intValue()));
        }
        return dicomObject2;
    }
}

