/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import DataStructures.Arrays;
import RuntimeTool.DebugManager;
import com.intelerad.lib.dicomtools.metrics.PixelFileMetrics;
import com.intelerad.lib.imaging.ArraySampleBuffer;
import com.intelerad.lib.imaging.SampleSink;
import com.intelerad.lib.imaging.SampleSource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PixelFile {
    static String mId;
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    private static final int BYTE_SHIFT = 8;
    private static final int IO_WRITE_BUFFER_SIZE = 262144;
    private static final int IO_READ_BUFFER_SIZE = 8192;
    private final File mFilename;
    private long mPixelDataOffset = -1L;
    private final int mSamplesPerPixel;
    private final long mNumberOfPixels;
    private final int mBytesPerSample;
    private final int mBitsStored;
    private final boolean mSigned;
    private final boolean mColourByPixel;
    private final long mImageSize;
    private final int mNumberOfFrames;
    private boolean mSwapPixels = false;
    private final boolean mLittleEndian;
    private int mWriteBufferSize = 262144;
    private int mReadBufferSize = 8192;
    private boolean mMustExtendFile = false;
    private boolean mPixelMaskingEnabled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PixelFile(File file, int n2, long l2, int n3, int n4, boolean bl2, boolean bl3, int n5, boolean bl4) {
        this.mFilename = file;
        this.mSamplesPerPixel = n2;
        this.mNumberOfPixels = l2;
        this.mBytesPerSample = n3;
        this.mBitsStored = n4;
        this.mSigned = bl2;
        this.mColourByPixel = bl3;
        this.mImageSize = (long)n2 * l2 * (long)n3;
        this.mNumberOfFrames = n5;
        this.mLittleEndian = bl4;
        if (this.mBytesPerSample != 1 && this.mBytesPerSample != 2) {
            throw new IllegalArgumentException("Bytes-per-sample must be 1 or 2, not: " + this.mBytesPerSample);
        }
    }

    public String toString() {
        return this.mFilename + " " + (this.mSigned ? "signed" : "unsigned") + " " + this.mBitsStored + "-bit" + ", " + this.mBytesPerSample + " bytes/sample" + ", " + this.mImageSize + " bytes/frame" + ", " + this.mNumberOfFrames + " frames";
    }

    public void setReadBufferSize(int n2) {
        this.mReadBufferSize = n2;
    }

    public void setWriteBufferSize(int n2) {
        this.mWriteBufferSize = n2;
    }

    public void setPixelDataOffset(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("pixel data offset must be >= 0");
        }
        this.mPixelDataOffset = l2;
    }

    long getPixelDataOffset() {
        return this.mPixelDataOffset;
    }

    public long getImageSize() {
        return this.mImageSize;
    }

    public int getSamplesPerPixel() {
        return this.mSamplesPerPixel;
    }

    public long getNumberOfSamples() {
        return this.mNumberOfPixels * (long)this.mSamplesPerPixel;
    }

    private long getFrameOffset(int n2) {
        return this.mPixelDataOffset + this.mImageSize * (long)n2;
    }

    long getPixelDataLength() {
        long l2 = this.mImageSize * (long)this.mNumberOfFrames;
        if (l2 % 2L == 1L) {
            ++l2;
        }
        return l2;
    }

    public boolean isLittleEndian() {
        return this.mLittleEndian;
    }

    public int getNumberOfFrames() {
        return this.mNumberOfFrames;
    }

    public boolean isSigned() {
        return this.mSigned;
    }

    public void setSwapPixels(boolean bl2) {
        this.mSwapPixels = bl2;
    }

    public int getBytesPerSample() {
        return this.mBytesPerSample;
    }

    public void setExtendOnClose(boolean bl2) {
        this.mMustExtendFile = bl2;
    }

    public void close() throws IOException {
        if (this.mMustExtendFile) {
            this.extendFile();
            this.mMustExtendFile = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean extendFile() throws IOException {
        long l2 = this.getPixelDataLength();
        long l3 = this.getPixelDataOffset() + l2;
        if (this.mFilename.length() >= l3) {
            return false;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.mFilename, "rw");
        try {
            randomAccessFile.seek(l3 - 1L);
            randomAccessFile.write(0);
        }
        finally {
            randomAccessFile.close();
        }
        return true;
    }

    public void writeImage(int n2, SampleSource sampleSource, int n3) throws IOException {
        this.writeImage(n2, sampleSource, n3, PixelFileMetrics.NULL_METRICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(int n2, SampleSource sampleSource, int n3, PixelFileMetrics pixelFileMetrics) throws IOException {
        boolean bl2;
        block10: {
            RandomAccessFile randomAccessFile = null;
            bl2 = true;
            try {
                int n4;
                pixelFileMetrics.writeImageStarted();
                this.checkPixelDataOffset();
                this.checkImageSize(sampleSource.numSamples());
                this.checkFrameIndex(n2);
                if (!this.mColourByPixel) {
                    throw new IllegalStateException("Writing in colour-by-plane format not implemented yet");
                }
                if (this.mSwapPixels) {
                    throw new IllegalStateException("sorry, I don't swap pixels on output (big-endian, 8-bit, OW pixel data)");
                }
                randomAccessFile = new RandomAccessFile(this.mFilename, "rw");
                long l2 = this.getFrameOffset(n2);
                randomAccessFile.seek(l2);
                short[] sArray = new short[this.mWriteBufferSize / 2];
                byte[] byArray = new byte[this.mWriteBufferSize];
                for (int i2 = 0; i2 < sampleSource.numSamples(); i2 += n4) {
                    n4 = Math.min(sampleSource.numSamples() - i2, sArray.length);
                    sampleSource.getSamples(sArray, i2, n4);
                    int n5 = this.serializePixels(sArray, byArray, n4, n3);
                    this.writeBufferToFile(randomAccessFile, byArray, 0, n5, pixelFileMetrics);
                }
                if (n2 == this.mNumberOfFrames - 1) {
                    long l3 = this.mImageSize * (long)this.mNumberOfFrames;
                    if (l3 % 2L == 1L) {
                        this.writeBufferToFile(randomAccessFile, new byte[]{0}, 0, 1, PixelFileMetrics.NULL_METRICS);
                    }
                    this.mMustExtendFile = false;
                }
                bl2 = false;
                Object var15_14 = null;
                pixelFileMetrics.writeImageFinished();
                if (randomAccessFile == null) break block10;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                pixelFileMetrics.writeImageFinished();
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (bl2) {
                    DebugManager.getDefault().printWarning("Caught exception while writing file " + this.mFilename + ". Deleting file.");
                    this.mFilename.delete();
                }
                throw throwable;
            }
            randomAccessFile.close();
        }
        if (bl2) {
            DebugManager.getDefault().printWarning("Caught exception while writing file " + this.mFilename + ". Deleting file.");
            this.mFilename.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBufferToFile(RandomAccessFile randomAccessFile, byte[] byArray, int n2, int n3, PixelFileMetrics pixelFileMetrics) throws IOException {
        try {
            pixelFileMetrics.writeIOStarted();
            randomAccessFile.write(byArray, n2, n3);
            pixelFileMetrics.addDataWritten(n3);
        }
        finally {
            pixelFileMetrics.writeIOFinished();
        }
    }

    public void readImage(int n2, SampleSink sampleSink, int n3) throws IOException {
        this.readImage(n2, sampleSink, n3, PixelFileMetrics.NULL_METRICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readImage(int n2, SampleSink sampleSink, int n3, PixelFileMetrics pixelFileMetrics) throws IOException {
        try {
            pixelFileMetrics.readImageStarted();
            this.checkPixelDataOffset();
            this.checkImageSize(sampleSink.numSamples());
            this.checkFrameIndex(n2);
            long l2 = this.getFrameOffset(n2);
            if (l2 + this.mImageSize > this.mFilename.length()) {
                throw new IOException(this.mFilename + ": Cannot read frame " + n2 + ": it has not been written yet");
            }
            boolean bl2 = this.mSamplesPerPixel > 1 && !this.mColourByPixel;
            SampleSink sampleSink2 = bl2 ? new ArraySampleBuffer(new short[sampleSink.numSamples()]) : sampleSink;
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.mFilename, "r");
            try {
                int n4;
                randomAccessFile.seek(l2);
                short[] sArray = new short[this.mReadBufferSize / 2];
                byte[] byArray = new byte[this.mReadBufferSize];
                for (int i2 = 0; i2 < sampleSink2.numSamples(); i2 += n4) {
                    n4 = Math.min(sampleSink2.numSamples() - i2, sArray.length);
                    int n5 = n4 * this.mBytesPerSample;
                    this.readBufferFromFile(randomAccessFile, byArray, n5, pixelFileMetrics);
                    this.deserializePixels(byArray, sArray, n4, n3);
                    sampleSink2.putSamples(sArray, i2, n4);
                }
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            if (bl2) {
                this.rearrangePlanes(((ArraySampleBuffer)sampleSink2).getSampleBuffer(), sampleSink);
            }
        }
        finally {
            pixelFileMetrics.readImageFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBufferFromFile(RandomAccessFile randomAccessFile, byte[] byArray, int n2, PixelFileMetrics pixelFileMetrics) throws IOException {
        try {
            pixelFileMetrics.readIOStarted();
            randomAccessFile.readFully(byArray, 0, n2);
            pixelFileMetrics.addDataRead(n2);
        }
        finally {
            pixelFileMetrics.readIOFinished();
        }
    }

    private void rearrangePlanes(short[] sArray, SampleSink sampleSink) {
        if ((long)sArray.length != this.mNumberOfPixels * (long)this.mSamplesPerPixel) {
            throw new IllegalArgumentException("Expected source array of length " + this.mNumberOfPixels * (long)this.mSamplesPerPixel + ", but source length is " + sArray.length);
        }
        if (this.mNumberOfPixels >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Image has " + this.mNumberOfPixels + " pixels, but I can handle only " + Integer.MAX_VALUE);
        }
        int n2 = (int)this.mNumberOfPixels;
        short[] sArray2 = new short[sArray.length];
        for (int i2 = 0; i2 < this.mSamplesPerPixel; ++i2) {
            Arrays.copyTuples(sArray, i2 * n2, 1, sArray2, i2, this.mSamplesPerPixel, n2, 1);
        }
        sampleSink.putSamples(sArray2, 0, sArray2.length);
    }

    void checkPixelDataOffset() {
        if (this.getPixelDataOffset() < 0L) {
            throw new IllegalStateException("Pixel data offset has not been set");
        }
    }

    private void checkImageSize(int n2) {
        if ((long)(n2 * this.mBytesPerSample) != this.mImageSize) {
            throw new IllegalStateException("Image size in file " + this.mFilename + " (" + this.mImageSize + " bytes) does not match size of SampleSource" + " (" + n2 + " samples x " + this.mBytesPerSample + " bytes)");
        }
    }

    private void checkFrameIndex(int n2) {
        if (n2 < 0 || n2 >= this.mNumberOfFrames) {
            throw new IllegalArgumentException(this.mFilename + ": Bad frame index: " + n2 + " (maximum: " + (this.mNumberOfFrames - 1) + ")");
        }
    }

    private int serializePixels(short[] sArray, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        if (this.mBytesPerSample > 1) {
            if (this.mSigned) {
                n5 = Short.MAX_VALUE;
                n4 = Short.MIN_VALUE;
            } else {
                n5 = 65535;
                n4 = 0;
            }
        } else if (this.mSigned) {
            n5 = 127;
            n4 = -128;
        } else {
            n5 = 255;
            n4 = 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7 = (sArray[i2] & 0xFFFF) - n3;
            if (n7 > n5) {
                n7 = n5;
            } else if (n7 < n4) {
                n7 = n4;
            }
            if (this.mLittleEndian) {
                byArray[n6++] = (byte)(0xFF & n7);
                if (this.mBytesPerSample <= 1) continue;
                byArray[n6++] = (byte)(0xFF & n7 >> 8);
                continue;
            }
            if (this.mBytesPerSample > 1) {
                byArray[n6++] = (byte)(0xFF & n7 >> 8);
            }
            byArray[n6++] = (byte)(0xFF & n7);
        }
        return n6;
    }

    void deserializePixels(byte[] byArray, short[] sArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = this.mBytesPerSample * 8 - this.mBitsStored;
        int n7 = (1 << this.mBitsStored) - 1;
        int n8 = 0;
        while (n8 < n2) {
            if (this.mBytesPerSample == 1) {
                sArray[n8] = this.mSigned ? (short)byArray[n5++] : (short)(0xFF & byArray[n5++]);
            } else {
                byte by2 = 0;
                if (this.mLittleEndian) {
                    n4 = 0xFF & byArray[n5++];
                    by2 = byArray[n5++];
                } else {
                    by2 = byArray[n5++];
                    n4 = 0xFF & byArray[n5++];
                }
                sArray[n8] = (short)(by2 << 8 | n4);
            }
            if (this.isPixelMaskingEnabled()) {
                if (this.mSigned) {
                    int n9 = n8;
                    sArray[n9] = (short)(sArray[n9] << n6);
                    int n10 = n8;
                    sArray[n10] = (short)(sArray[n10] >> n6);
                } else {
                    int n11 = n8;
                    sArray[n11] = (short)(sArray[n11] & n7);
                }
            }
            int n12 = n8++;
            sArray[n12] = (short)(sArray[n12] + n3);
        }
        if (this.mSwapPixels) {
            if (!$assertionsDisabled && n2 % 2 != 0) {
                throw new AssertionError((Object)"number of samples to copy must be an even number");
            }
            for (n8 = 0; n8 < n2; n8 += 2) {
                n4 = sArray[n8];
                sArray[n8] = sArray[n8 + 1];
                sArray[n8 + 1] = n4;
            }
        }
    }

    public boolean isPixelMaskingEnabled() {
        return this.mPixelMaskingEnabled;
    }

    public void enablePixelMasking(boolean bl2) {
        this.mPixelMaskingEnabled = bl2;
    }

    static {
        $assertionsDisabled = !PixelFile.class.desiredAssertionStatus();
        mId = "$Id: PixelFile.java,v 1.9.12.4 2007/09/26 20:43:24 dpitic Exp $";
    }
}

