/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import StringUtilities.StringStrip;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Modality {
    private static List mInstanceList = new ArrayList();
    public static final Modality UNKNOWN = new Modality("Unknown", -1);
    public static final Modality CR = new Modality("CR", 4118);
    public static final Modality CT = new Modality("CT", 4119);
    public static final Modality DX = new Modality("DX", 4178);
    public static final Modality ES = new Modality("ES", 4161);
    public static final Modality MG = new Modality("MG", 4176);
    public static final Modality MR = new Modality("MR", 4121);
    public static final Modality NM = new Modality("NM", 4131);
    public static final Modality OT = new Modality("OT", -1);
    public static final Modality PR = new Modality("PR", 4165);
    public static final Modality PT = new Modality("PT", 4151);
    public static final Modality RF = new Modality("RF", 4129);
    public static final Modality US = new Modality("US", 4122);
    public static final Modality XA = new Modality("XA", 4128);
    private String mModalityString;
    private String mDefaultSopClassUid;

    private Modality(String string, int n2) {
        this.mModalityString = string;
        this.mDefaultSopClassUid = Modality.lookupSopClassUid(n2);
        mInstanceList.add(this);
    }

    private static String lookupSopClassUid(int n2) {
        try {
            UIDEntry uIDEntry = UID.getUIDEntry((int)n2);
            if (uIDEntry == null) {
                return null;
            }
            return uIDEntry.getValue();
        }
        catch (IllegalValueException illegalValueException) {
            return null;
        }
    }

    public String getModalityString() {
        return this.mModalityString;
    }

    public String getDefaultSopClassUid() {
        return this.mDefaultSopClassUid;
    }

    public String toString() {
        return this.getModalityString();
    }

    public static Modality getInstance(String string) {
        string = StringStrip.trim(string);
        Iterator iterator = mInstanceList.iterator();
        while (iterator.hasNext()) {
            Modality modality = (Modality)iterator.next();
            if (!modality.getModalityString().equalsIgnoreCase(string)) continue;
            return modality;
        }
        return UNKNOWN;
    }

    public static List getAllModalities() {
        return new ArrayList(mInstanceList);
    }

    public static List getPreferenceModalities() {
        List list = Modality.getAllModalities();
        list.remove(PR);
        return list;
    }

    public static boolean isProjectionRadiography(Modality modality) {
        return modality == CR || modality == RF || modality == XA || modality == DX || modality == MG;
    }
}

