/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.intelerad.lib.dicomtools.FileMetaInformation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class JdtUtil {
    public static DicomObject readDicomObject(File file) throws IOException, DicomException {
        return JdtUtil.readDicomObject(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject readDicomObject(File file, boolean bl2) throws IOException, DicomException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            DicomReader dicomReader = new DicomReader();
            if (!bl2) {
                JdtUtil.addSkipAllTagReadListener(file, dicomReader);
            }
            DicomObject dicomObject = dicomReader.read((InputStream)bufferedInputStream);
            return dicomObject;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObjectItem getDicomObjectWithoutPixelData(File file) throws IOException, DicomException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            DicomReader dicomReader = new DicomReader();
            SkipAllTagReadListener skipAllTagReadListener = JdtUtil.addSkipAllTagReadListener(file, dicomReader);
            DicomObject dicomObject = dicomReader.read((InputStream)bufferedInputStream);
            long l2 = file.length() - skipAllTagReadListener.getSkippedBytes();
            DicomObjectItem dicomObjectItem = new DicomObjectItem(dicomObject, skipAllTagReadListener.foundPixelData(), l2, !skipAllTagReadListener.isSkippedTagDataOnly());
            return dicomObjectItem;
        }
        finally {
            bufferedInputStream.close();
        }
    }

    private static SkipAllTagReadListener addSkipAllTagReadListener(File file, DicomReader dicomReader) {
        SkipAllTagReadListener skipAllTagReadListener = new SkipAllTagReadListener(file);
        dicomReader.addTagReadListener((TagReadListener)skipAllTagReadListener, 1184);
        return skipAllTagReadListener;
    }

    public static final long skipBytes(InputStream inputStream, long l2) throws IOException {
        if (l2 < 0L) {
            return 0L;
        }
        return JdtUtil.skipBytesInternal(inputStream, l2);
    }

    static long getInputStreamOffset(InputStream inputStream) {
        try {
            Method method = inputStream.getClass().getMethod("if", null);
            method.setAccessible(true);
            Object object = method.invoke((Object)inputStream, null);
            if (object instanceof Long) {
                return (Long)object;
            }
            return -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static final long skipBytesInternal(InputStream inputStream, long l2) throws IOException {
        boolean bl2;
        long l3 = 0L;
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = inputStream.available();
        }
        while (bl2 ? l2 > 0L : l3 < l2) {
            long l4 = inputStream.skip(l2 - l3);
            if (l4 == 0L) {
                int n2 = inputStream.read();
                if (n2 == -1) break;
                ++l3;
            } else {
                l3 += l4;
            }
            if (!bl2) continue;
            l2 = inputStream.available();
        }
        return l3;
    }

    public static void writeDicomObject(OutputStream outputStream, DicomObject dicomObject, int n2, String string) throws DicomException, IOException {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        String string2 = JdtUtil.getUid(n2);
        if (dicomObject2 == null) {
            FileMetaInformation.setFileMetaInformation(dicomObject, string2, string);
        } else {
            dicomObject2.set(31, (Object)string2);
        }
        dicomObject.write(outputStream, true, n2, true, false);
    }

    public static String getUid(int n2) throws DicomException {
        try {
            return UID.getUIDEntry((int)n2).getValue();
        }
        catch (IllegalValueException illegalValueException) {
            throw new DicomException("No UIDEntry for tag " + n2);
        }
    }

    public static long getDicomObjectSizeInBytes(DicomObject dicomObject, int n2) throws IOException, DicomException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JdtUtil.writeDicomObject(byteArrayOutputStream, dicomObject, n2, "1.2.840.114202.5.2");
        long l2 = byteArrayOutputStream.size();
        long l3 = 0L;
        long l4 = 0L;
        long l5 = dicomObject.getI(466);
        long l6 = dicomObject.getI(467);
        long l7 = dicomObject.getI(464);
        long l8 = dicomObject.getI(461);
        long l9 = dicomObject.getI(475);
        if (l7 == Integer.MAX_VALUE) {
            l7 = 1L;
        }
        if (l8 == Integer.MAX_VALUE) {
            l8 = 1L;
        }
        if (l5 != Integer.MAX_VALUE && l6 != Integer.MAX_VALUE && l9 != Integer.MAX_VALUE) {
            if ((l3 += l5 * l6 * l7 * l8 * l9 / 8L) % 2L == 1L) {
                ++l3;
            }
            boolean bl2 = n2 == 8193;
            l4 = JdtUtil.getPixelDataHeaderLength(bl2);
        }
        return l2 + l3 + l4;
    }

    public static int getPixelDataHeaderLength(boolean bl2) {
        if (bl2) {
            return 8;
        }
        return 12;
    }

    public static String tagToString(int n2) {
        return "[" + Integer.toHexString(DDict.getGroup((int)n2)) + "," + Integer.toHexString(DDict.getElement((int)n2)) + "]";
    }

    public static int getTransferSyntax(DicomObject dicomObject) {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        String string = null;
        if (dicomObject2 != null) {
            try {
                string = dicomObject2.getS(31);
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
        }
        if (string == null) {
            return 8193;
        }
        try {
            return UID.getUIDEntry((String)string).getConstant();
        }
        catch (UnknownUIDException unknownUIDException) {
            return 8193;
        }
    }

    public static void ensureNoElementsAfterPixelData(DicomObject dicomObject) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Enumeration enumeration = dicomObject.enumerateVRs(false);
        while (enumeration.hasMoreElements()) {
            TagValue tagValue = (TagValue)enumeration.nextElement();
            if (tagValue.getGroup() <= DDict.getGroup((int)1184)) continue;
            hashSet.add(new Integer(tagValue.getGroup()));
        }
        if (hashSet.size() > 0) {
            enumeration = JdtUtil.copyAllGroups(dicomObject, hashSet);
            dicomObject.clear();
            dicomObject.addGroups((DicomObject)enumeration);
        }
    }

    private static DicomObject copyAllGroups(DicomObject dicomObject, Set set) {
        DicomObject dicomObject2 = new DicomObject();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Enumeration enumeration = dicomObject.enumerateVRs(false);
        while (enumeration.hasMoreElements()) {
            TagValue tagValue = (TagValue)enumeration.nextElement();
            Integer n2 = new Integer(tagValue.getGroup());
            if (set.contains(n2) || hashSet.contains(n2)) continue;
            hashSet.add(n2);
            dicomObject2.addGroups(dicomObject.copyGroup(n2.intValue()));
        }
        return dicomObject2;
    }

    public static class DicomObjectItem {
        private final DicomObject mDicomObject;
        private final boolean mPixelDataExists;
        private final long mPixelDataOffset;
        private final boolean mDiscardedElementsAfterPixelData;

        private DicomObjectItem(DicomObject dicomObject, boolean bl2, long l2, boolean bl3) {
            this.mDicomObject = dicomObject;
            this.mPixelDataExists = bl2;
            this.mPixelDataOffset = bl2 ? l2 : -1L;
            this.mDiscardedElementsAfterPixelData = bl3;
        }

        public DicomObject getDicomObject() {
            return this.mDicomObject;
        }

        public long getPixelDataOffset() {
            return this.mPixelDataOffset;
        }

        public boolean discardedElementsAfterPixelData() {
            return this.mDiscardedElementsAfterPixelData;
        }

        public boolean pixelDataExists() {
            return this.mPixelDataExists;
        }
    }

    private static class SkipAllTagReadListener
    implements TagReadListener {
        private long mSkippedBytes = 0L;
        private boolean mSkippedTagDataOnly = true;
        private boolean mFoundPixelData = false;
        private final File mFile;

        public SkipAllTagReadListener(File file) {
            this.mFile = file;
        }

        public void afterHeader(TagReadEvent tagReadEvent) {
            tagReadEvent.setDataReadStatus(0);
            DicomObject dicomObject = tagReadEvent.getDicomObject();
            if (dicomObject.getParent() == null) {
                this.skipPixelData(tagReadEvent);
                tagReadEvent.setDataReadStatus(3);
                tagReadEvent.setStopReading(true);
            }
        }

        private void skipPixelData(TagReadEvent tagReadEvent) {
            this.mFoundPixelData = true;
            try {
                InputStream inputStream = tagReadEvent.getInputStream();
                long l2 = JdtUtil.getInputStreamOffset(inputStream);
                this.mSkippedBytes = l2 >= 0L ? this.mFile.length() - l2 : JdtUtil.skipBytesInternal(inputStream, -1L);
                this.mSkippedTagDataOnly = (long)tagReadEvent.getLength() == this.mSkippedBytes;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public long getSkippedBytes() {
            return this.mSkippedBytes;
        }

        public boolean isSkippedTagDataOnly() {
            return this.mSkippedTagDataOnly;
        }

        public boolean foundPixelData() {
            return this.mFoundPixelData;
        }
    }
}

