/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.intelerad.lib.dicomtools.DicomObjectUpdater;
import com.intelerad.lib.dicomtools.Uid;

public class InstanceUidUpdater
implements DicomObjectUpdater {
    private final String mStudyInstanceUid;
    private final String mSeriesInstanceUid;
    private final boolean mUseInstanceNumberForSopSuffix;
    private int mSopSuffixIndex = 1;

    public InstanceUidUpdater(String string, String string2, boolean bl2) {
        InstanceUidUpdater.validateUid("study", string);
        InstanceUidUpdater.validateUid("series", string2);
        this.mStudyInstanceUid = string;
        this.mSeriesInstanceUid = string2;
        this.mUseInstanceNumberForSopSuffix = bl2;
    }

    private static void validateUid(String string, String string2) {
        if (!Uid.verifyUid(string2)) {
            throw new IllegalArgumentException("Invalid " + string + " instance UID [" + string2 + "]");
        }
    }

    public InstanceUidUpdater(String string, String string2) {
        this(string, string2, false);
    }

    public void update(DicomObject dicomObject) throws DicomException {
        String string = this.mSeriesInstanceUid + "." + this.getSopSuffix(dicomObject);
        if (!Uid.verifyUid(string)) {
            throw new DicomException("Invalid SOP instance UID [" + string + "]");
        }
        dicomObject.set(425, (Object)this.mStudyInstanceUid);
        dicomObject.set(426, (Object)this.mSeriesInstanceUid);
        dicomObject.set(63, (Object)string);
    }

    private int getSopSuffix(DicomObject dicomObject) throws DicomException {
        if (this.mUseInstanceNumberForSopSuffix) {
            int n2 = dicomObject.getI(430);
            if (n2 < 0 || n2 == Integer.MAX_VALUE) {
                throw new DicomException("Updater using instance number as SOP instance UID suffix, but instance number invalid: " + n2);
            }
            return n2;
        }
        return this.mSopSuffixIndex++;
    }
}

