/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.dicomtools;

import RuntimeTool.DebugManager;
import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.intelerad.lib.dicomtools.JdtUtil;
import com.intelerad.lib.dicomtools.PixelFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class DicomFile {
    static final int UNSIGNED_PIXEL_REPRESENTATION = 0;
    static final int SIGNED_PIXEL_REPRESENTATION = 1;
    public static final int OUTPUT_TRANSFER_SYNTAX = 8193;
    private File mFilename;
    private boolean mSeenHeader = false;
    private PixelFile mPixelFile = null;
    private int mTransferSyntax = -1;
    private boolean mLittleEndian;
    private boolean mImplicitVR;

    public DicomFile(File file) {
        this.mFilename = file;
    }

    public File getFilename() {
        return this.mFilename;
    }

    public int getTransferSyntaxCode() {
        return this.mTransferSyntax;
    }

    public PixelFile getPixelFile() throws DicomFileException {
        this.checkSeenHeader();
        this.checkPixelFile();
        return this.mPixelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.mPixelFile != null) {
                this.mPixelFile.close();
            }
        }
        finally {
            this.mPixelFile = null;
        }
    }

    public boolean exists() {
        return this.mFilename.exists();
    }

    public DicomObject readHeader() throws IOException, DicomException {
        this.mPixelFile = null;
        JdtUtil.DicomObjectItem dicomObjectItem = JdtUtil.getDicomObjectWithoutPixelData(this.mFilename);
        DicomObject dicomObject = dicomObjectItem.getDicomObject();
        this.parseTransferSyntax(dicomObject);
        PixelFile pixelFile = this.createPixelFile(dicomObject);
        if (pixelFile != null && this.findPixelData(pixelFile, dicomObjectItem.getPixelDataOffset()) && pixelFile.getPixelDataOffset() >= 0L) {
            this.mPixelFile = pixelFile;
        }
        this.mSeenHeader = true;
        return dicomObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader(DicomObject dicomObject, boolean bl2) throws IOException, DicomException {
        boolean bl3 = false;
        CloseableBufferedOutputStream closeableBufferedOutputStream = null;
        try {
            PixelFile pixelFile;
            this.mPixelFile = null;
            if (dicomObject.get(1184) != null) {
                throw new DicomFileException(this.mFilename, "DicomObject should not contain pixel data");
            }
            closeableBufferedOutputStream = new CloseableBufferedOutputStream(new FileOutputStream(this.mFilename));
            if (bl2) {
                JdtUtil.ensureNoElementsAfterPixelData(dicomObject);
            }
            this.mTransferSyntax = 8193;
            this.mImplicitVR = true;
            this.mLittleEndian = true;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JdtUtil.writeDicomObject(byteArrayOutputStream, dicomObject, this.mTransferSyntax, "1.2.840.114202.5.2");
            byte[] byArray = byteArrayOutputStream.toByteArray();
            long l2 = byArray.length;
            closeableBufferedOutputStream.write(byArray);
            if (bl2 && (pixelFile = this.createPixelFile(dicomObject)) != null) {
                byte[] byArray2 = this.createPixelDataHeader(pixelFile.getPixelDataLength());
                closeableBufferedOutputStream.write(byArray2);
                pixelFile.setPixelDataOffset(l2 += (long)byArray2.length);
                pixelFile.setExtendOnClose(true);
                this.mPixelFile = pixelFile;
            }
            if (this.mPixelFile == null) {
                this.mTransferSyntax = -1;
            }
            this.mSeenHeader = true;
            bl3 = true;
        }
        catch (Throwable throwable) {
            this.cleanupAfterHeaderWrite(bl3, closeableBufferedOutputStream);
            throw throwable;
        }
        this.cleanupAfterHeaderWrite(bl3, closeableBufferedOutputStream);
    }

    private void cleanupAfterHeaderWrite(boolean bl2, Closeable closeable) throws IOException {
        IOException iOException = null;
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException2) {
            if (bl2) {
                iOException = iOException2;
            }
            bl2 = false;
        }
        if (!bl2) {
            this.mTransferSyntax = -1;
            this.mFilename.delete();
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public boolean hasPixelData() {
        try {
            this.checkSeenHeader();
            this.checkPixelFile();
            this.checkTransferSyntax();
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (DicomFileException dicomFileException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteHeader(DicomObject dicomObject) throws IOException, DicomException {
        boolean bl2 = false;
        CloseableRandomAccessFile closeableRandomAccessFile = null;
        try {
            this.checkSeenHeader();
            this.checkPixelFile();
            this.checkTransferSyntax();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JdtUtil.writeDicomObject(byteArrayOutputStream, dicomObject, this.mTransferSyntax, "1.2.840.114202.5.2");
            long l2 = this.mPixelFile.getPixelDataOffset() - (long)JdtUtil.getPixelDataHeaderLength(this.isImplicitVR());
            if ((long)byteArrayOutputStream.size() != l2) {
                throw new DicomFileException(this.mFilename, "DICOM header size has changed: expected size = " + l2 + ", actual size = " + byteArrayOutputStream.size());
            }
            closeableRandomAccessFile = new CloseableRandomAccessFile(this.mFilename, "rw");
            closeableRandomAccessFile.seek(0L);
            closeableRandomAccessFile.write(byteArrayOutputStream.toByteArray());
            bl2 = true;
        }
        catch (Throwable throwable) {
            this.cleanupAfterHeaderWrite(bl2, closeableRandomAccessFile);
            throw throwable;
        }
        this.cleanupAfterHeaderWrite(bl2, closeableRandomAccessFile);
    }

    private void checkPixelFile() throws DicomFileException {
        if (this.mPixelFile == null) {
            throw new DicomFileException(this.mFilename, "File has no pixel data (or is corrupt)");
        }
    }

    private void parseTransferSyntax(DicomObject dicomObject) throws DicomException {
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        String string = null;
        if (dicomObject2 != null) {
            string = dicomObject2.getS(31);
        }
        try {
            this.mTransferSyntax = string == null ? 8193 : UID.getUIDEntry((String)string).getConstant();
        }
        catch (UnknownUIDException unknownUIDException) {
            throw new DicomFileException(this.mFilename, unknownUIDException);
        }
        if (this.mTransferSyntax == 8193) {
            this.mLittleEndian = true;
            this.mImplicitVR = true;
        } else if (this.mTransferSyntax == 8194) {
            this.mLittleEndian = true;
            this.mImplicitVR = false;
        } else if (this.mTransferSyntax == 8195) {
            this.mLittleEndian = false;
            this.mImplicitVR = false;
        } else {
            throw new DicomFileException(this.mFilename, "Unsupported transfer syntax: " + string);
        }
    }

    private boolean findPixelData(PixelFile pixelFile, long l2) throws DicomException {
        ElementHeader elementHeader;
        if (l2 > 0L && this.checkPixelDataHeader(elementHeader = this.readPixelDataHeader(this.mFilename, l2), pixelFile.getPixelDataLength())) {
            pixelFile.setSwapPixels(this.needPixelSwap(elementHeader, pixelFile));
            pixelFile.setPixelDataOffset(l2);
            return true;
        }
        return false;
    }

    private PixelFile createPixelFile(DicomObject dicomObject) throws DicomException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl2 = true;
        try {
            n9 = dicomObject.getI(466);
            n8 = dicomObject.getI(467);
            n7 = dicomObject.getI(464);
            n6 = dicomObject.getI(461);
            if (n6 != Integer.MAX_VALUE && n6 > 1) {
                bl2 = this.isColourByPixel(dicomObject);
            }
            n5 = dicomObject.getI(475);
            n4 = dicomObject.getI(476);
            n3 = dicomObject.getI(477);
            n2 = dicomObject.getI(478);
        }
        catch (DicomException dicomException) {
            DebugManager.getDefault().printException("Error reading DICOM headers in DicomFile.createPixelFile()", dicomException);
            return null;
        }
        if (n7 == Integer.MAX_VALUE) {
            n7 = 1;
        }
        if (n6 == Integer.MAX_VALUE) {
            n6 = 1;
        }
        if (n9 == Integer.MAX_VALUE || n8 == Integer.MAX_VALUE || n5 == Integer.MAX_VALUE || n4 == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return null;
        }
        if (n5 != 8 && n5 != 16) {
            throw new DicomFileException(this.mFilename, "unsupported value for bits allocated: " + n5 + " (must be 8 or 16)");
        }
        if (n4 > n5) {
            throw new DicomFileException(this.mFilename, "bits stored (" + n4 + ") is larger than " + "bits allocated (" + n5 + ")");
        }
        if (n3 != n4 - 1) {
            throw new DicomFileException(this.mFilename, "unsupported value for high bit: " + n3 + " (must be bits stored - 1, or " + (n4 - 1) + ")");
        }
        int n10 = n5 / 8;
        boolean bl3 = n2 == 1;
        return new PixelFile(this.mFilename, n6, n9 * n8, n10, n4, bl3, bl2, n7, this.mLittleEndian);
    }

    private boolean isColourByPixel(DicomObject dicomObject) throws DicomException {
        int n2 = dicomObject.getI(463);
        if (n2 == Integer.MAX_VALUE) {
            throw new DicomException("Missing required element Planar Configuration");
        }
        if (n2 == 0) {
            return true;
        }
        if (n2 == 1) {
            return false;
        }
        throw new DicomException("Unsupported planar configuration: " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ElementHeader readPixelDataHeader(File file, long l2) {
        ElementHeader elementHeader;
        long l3 = l2 - (long)JdtUtil.getPixelDataHeaderLength(this.isImplicitVR());
        if (l3 < 0L) {
            return null;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                FileChannel fileChannel = randomAccessFile.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.allocate(JdtUtil.getPixelDataHeaderLength(this.isImplicitVR()));
                fileChannel.read(byteBuffer, l3);
                byteBuffer.rewind();
                this.setByteOrder(byteBuffer);
                int n2 = byteBuffer.getShort() & 0xFFFF;
                int n3 = byteBuffer.getShort() & 0xFFFF;
                String string = "OW";
                if (!this.isImplicitVR()) {
                    string = new String(new byte[]{byteBuffer.get(), byteBuffer.get()}, "ISO-8859-1");
                    byteBuffer.getShort();
                }
                long l4 = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                elementHeader = new ElementHeader(n2, n3, string, l4);
                Object var16_14 = null;
                if (randomAccessFile == null) return elementHeader;
            }
            catch (IOException iOException) {
                ElementHeader elementHeader2 = null;
                Object var16_15 = null;
                if (randomAccessFile == null) return elementHeader2;
                try {
                    randomAccessFile.close();
                    return elementHeader2;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return elementHeader2;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (randomAccessFile == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            randomAccessFile.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return elementHeader;
        }
        randomAccessFile.close();
        return elementHeader;
    }

    private boolean checkPixelDataHeader(ElementHeader elementHeader, long l2) {
        return elementHeader.mGroup == DDict.getGroup((int)1184) && elementHeader.mElement == DDict.getElement((int)1184) && elementHeader.mLength == l2;
    }

    private boolean needPixelSwap(ElementHeader elementHeader, PixelFile pixelFile) throws DicomException {
        boolean bl2;
        boolean bl3 = bl2 = !this.isLittleEndian() && pixelFile.getBytesPerSample() == 1 && elementHeader.mVR.equals("OW");
        if (bl2 && pixelFile.getImageSize() % 2L != 0L) {
            throw new DicomFileException(this.mFilename, "Unsupported DICOM image format: big-endian, 8-bit, OW value representation for pixel data, odd number of pixels");
        }
        return bl2;
    }

    public boolean isInitialized() {
        return this.mSeenHeader;
    }

    private void checkSeenHeader() {
        if (!this.mSeenHeader) {
            throw new IllegalStateException("File header has not been read or written yet");
        }
    }

    private void checkTransferSyntax() {
        if (this.mTransferSyntax == -1) {
            throw new IllegalStateException("Transfer syntax not known yet");
        }
    }

    private boolean isImplicitVR() {
        this.checkTransferSyntax();
        return this.mImplicitVR;
    }

    private boolean isLittleEndian() {
        this.checkTransferSyntax();
        return this.mLittleEndian;
    }

    private void setByteOrder(ByteBuffer byteBuffer) {
        if (this.isLittleEndian()) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    private byte[] createPixelDataHeader(long l2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(JdtUtil.getPixelDataHeaderLength(this.isImplicitVR()));
        byteBuffer.rewind();
        this.setByteOrder(byteBuffer);
        byteBuffer.putShort((short)DDict.getGroup((int)1184));
        byteBuffer.putShort((short)DDict.getElement((int)1184));
        if (!this.isImplicitVR()) {
            byteBuffer.put((byte)79);
            byteBuffer.put((byte)87);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
        }
        byteBuffer.putInt((int)l2);
        byteBuffer.rewind();
        return byteBuffer.array();
    }

    public String toString() {
        return this.mFilename.toString();
    }

    public static class DicomFileException
    extends DicomException {
        public DicomFileException(File file, String string) {
            super(file + ": " + string);
        }

        public DicomFileException(File file, Throwable throwable) {
            this(file, throwable.getMessage());
            this.setStackTrace(throwable.getStackTrace());
        }
    }

    private static class ElementHeader {
        int mGroup;
        int mElement;
        String mVR;
        long mLength;

        ElementHeader(int n2, int n3, String string, long l2) {
            this.mGroup = n2;
            this.mElement = n3;
            this.mVR = string;
            this.mLength = l2;
        }
    }

    private class CloseableRandomAccessFile
    extends RandomAccessFile
    implements Closeable {
        private CloseableRandomAccessFile(File file, String string) throws FileNotFoundException {
            super(file, string);
        }
    }

    private class CloseableBufferedOutputStream
    extends BufferedOutputStream
    implements Closeable {
        private CloseableBufferedOutputStream(OutputStream outputStream) {
            super(outputStream);
        }
    }

    private static interface Closeable {
        public void close() throws IOException;
    }
}

