/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.lib.burlap.client;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.BurlapRemoteObject;
import com.intelerad.lib.burlap.io.BurlapInput;
import com.intelerad.lib.burlap.io.BurlapOutput;
import com.intelerad.lib.serialization.exception.CommunicationException;
import com.intelerad.lib.serialization.protocol.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipBurlapProxyFactory
extends BurlapProxyFactory {
    private final Protocol mProtocol;

    public GZipBurlapProxyFactory(Protocol protocol) {
        this.mProtocol = protocol;
    }

    public Object create(Class clazz, String string) throws MalformedURLException {
        final Object object = super.create(clazz, string);
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object object2, Method method, Object[] objectArray) throws Throwable {
                try {
                    return Proxy.getInvocationHandler(object).invoke(object2, method, objectArray);
                }
                catch (BurlapRuntimeException burlapRuntimeException) {
                    throw new CommunicationException(burlapRuntimeException);
                }
            }
        };
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, BurlapRemoteObject.class}, invocationHandler);
    }

    public AbstractBurlapInput getBurlapInput(InputStream inputStream) {
        try {
            return new BurlapInput(new GZIPInputStream(inputStream), this.mProtocol);
        }
        catch (IOException iOException) {
            throw new BurlapRuntimeException("Unable to decompress input stream", (Throwable)iOException);
        }
    }

    public com.caucho.burlap.io.BurlapOutput getBurlapOutput(OutputStream outputStream) {
        try {
            return new BurlapOutput(new GZIPOutputStream(outputStream), this.mProtocol);
        }
        catch (IOException iOException) {
            throw new BurlapRuntimeException("Unable to compress output stream", (Throwable)iOException);
        }
    }
}

