/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.validation;

import DataModels.DataModel;
import DataModels.ModelProperty;
import com.intelerad.datamodels.validation.CompositeValidator;
import com.intelerad.datamodels.validation.Validator;
import com.intelerad.datamodels.validation.ValueInListValidator;
import com.intelerad.datamodels.validation.ValueInRangeValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataModelValidator
implements Validator {
    private Map mPropertyValidators = new HashMap();

    public DataModelValidator() {
    }

    public DataModelValidator(DataModelValidator dataModelValidator) {
        this.mPropertyValidators.putAll(dataModelValidator.mPropertyValidators);
    }

    public boolean isValid(Object object) {
        if (!(object instanceof DataModel)) {
            return false;
        }
        DataModel dataModel = (DataModel)object;
        Iterator iterator = this.mPropertyValidators.keySet().iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            Validator validator = (Validator)this.mPropertyValidators.get(modelProperty);
            if (this.isValidProperty(validator, modelProperty, dataModel.getProperty(modelProperty))) continue;
            return false;
        }
        return true;
    }

    public List getValidValues() {
        throw new UnsupportedOperationException();
    }

    protected boolean isValidProperty(Validator validator, ModelProperty modelProperty, Object object) {
        return validator == null || validator.isValid(object);
    }

    public Map getValidators() {
        return new HashMap(this.mPropertyValidators);
    }

    public Validator getValidator(ModelProperty modelProperty) {
        return (Validator)this.mPropertyValidators.get(modelProperty);
    }

    public void addValidators(Map map) {
        this.mPropertyValidators.putAll(map);
    }

    public void setValidator(ModelProperty modelProperty, Validator validator) {
        if (validator == null) {
            this.mPropertyValidators.remove(modelProperty);
        } else {
            this.mPropertyValidators.put(modelProperty, validator);
        }
    }

    public void setValidRange(ModelProperty modelProperty, int n2, int n3) {
        this.mPropertyValidators.put(modelProperty, this.rangeValidator(modelProperty, n2, n3));
    }

    public void setValidValues(ModelProperty modelProperty, List list) {
        this.mPropertyValidators.put(modelProperty, new ValueInListValidator(list));
    }

    public void setValidValues(ModelProperty modelProperty, Object[] objectArray) {
        this.setValidValues(modelProperty, Arrays.asList(objectArray));
    }

    public void setValidValuesAndRange(ModelProperty modelProperty, Object[] objectArray, int n2, int n3) {
        List<Object> list = Arrays.asList(new ValueInListValidator(Arrays.asList(objectArray)), this.rangeValidator(modelProperty, n2, n3));
        this.mPropertyValidators.put(modelProperty, new CompositeValidator(list));
    }

    public void acceptAnyValue(ModelProperty modelProperty) {
        this.mPropertyValidators.put(modelProperty, null);
    }

    public int hashCode() {
        return ((Object)this.mPropertyValidators).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataModelValidator)) {
            return false;
        }
        return ((Object)this.mPropertyValidators).equals(((DataModelValidator)object).mPropertyValidators);
    }

    private ValueInRangeValidator rangeValidator(ModelProperty modelProperty, int n2, int n3) {
        boolean bl2 = modelProperty.getValueClass() == String.class;
        return new ValueInRangeValidator(new Integer(n2), new Integer(n3), bl2);
    }
}

