/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.userprofile;

import com.intelerad.datamodels.userprofile.ProfileIdentifier;
import com.intelerad.datamodels.userprofile.RoamingTemplate;
import com.intelerad.datamodels.userprofile.RoamingTemplateIdentifier;
import com.intelerad.datamodels.userprofile.UserProfile;

public class ProfileTemplatePair {
    private final UserProfile mUserProfile;
    private final RoamingTemplate mAssociatedTemplate;

    public ProfileTemplatePair(UserProfile userProfile, RoamingTemplate roamingTemplate) {
        this.validateProfileTemplatePair(userProfile, roamingTemplate);
        this.mUserProfile = userProfile;
        this.mAssociatedTemplate = roamingTemplate;
    }

    private void validateProfileTemplatePair(UserProfile userProfile, RoamingTemplate roamingTemplate) {
        if (roamingTemplate == null) {
            return;
        }
        ProfileIdentifier profileIdentifier = userProfile.getProfileIdentifier();
        RoamingTemplateIdentifier roamingTemplateIdentifier = roamingTemplate.getRoamingTemplateIdentifier();
        if (!roamingTemplateIdentifier.getTemplateName().equals(userProfile.getBackingTemplateName())) {
            throw new IllegalArgumentException("The associateTemplate name argument does not match the UserProfile backingTemplate name");
        }
        if (!profileIdentifier.getCategory().equals((Object)roamingTemplateIdentifier.getCategory()) || !profileIdentifier.getApplicationContext().equals((Object)roamingTemplateIdentifier.getApplicationContext())) {
            throw new IllegalArgumentException("The Category or ApplicationContext of the profile and template did not match.");
        }
    }

    public UserProfile getUserProfile() {
        return this.mUserProfile;
    }

    public RoamingTemplate getAssociatedTemplate() {
        return this.mAssociatedTemplate;
    }
}

