/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.teachingfile;

import DataModels.AbstractDataModel;
import DataModels.ModelProperty;
import StringUtilities.StringStrip;
import com.intelerad.datamodels.teachingfile.AccessLevel;
import com.intelerad.datamodels.teachingfile.Accessible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TeachingCase
extends AbstractDataModel
implements Accessible {
    private static final String TEMPORARY_ID_PREFIX = "CASE-temp_";
    public static final String DATABASE_FIELD_SEPARATOR = " ";
    private String mCaseId = "";
    private String mDescription = "";
    private List mAcrCodes = Collections.synchronizedList(new ArrayList());
    private String mAnatomy = "";
    private String mPathology = "";
    private String mClinicalHistory = "";
    private String mTeachingClinicalHistory = "";
    private String mClinicalImpression = "";
    private String mReasonForStudy = "";
    private List mKeywords = Collections.synchronizedList(new ArrayList());
    private String mNotes = "";
    private AccessLevel mAccessLevel = AccessLevel.PRIVATE;
    private String mLastModifiedBy = "";
    private Date mLastModifiedOn = new Date();
    private String mCreatedBy = "";
    private Date mCreatedOn = new Date();
    private List mSeriesUids = Collections.synchronizedList(new ArrayList());
    private String mPatientId = null;
    private String mDiagnosis = "";
    private Date mStudyDate = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$com$intelerad$datamodels$teachingfile$AccessLevel;
    static /* synthetic */ Class class$java$util$Date;

    public List getAcrCodes() {
        return new ArrayList(this.mAcrCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcrCodes(Collection collection) {
        List list = this.mAcrCodes;
        synchronized (list) {
            this.mAcrCodes.clear();
            this.mAcrCodes.addAll(collection);
        }
    }

    public String getAnatomy() {
        return this.mAnatomy;
    }

    public void setAnatomy(String string) {
        this.mAnatomy = StringStrip.trim(string);
    }

    public String getPathology() {
        return this.mPathology;
    }

    public void setPathology(String string) {
        this.mPathology = string;
    }

    public String getCaseId() {
        return this.mCaseId;
    }

    public void setCaseId(String string) {
        this.mCaseId = StringStrip.trim(string);
    }

    public String getClinicalHistory() {
        return this.mClinicalHistory;
    }

    public void setClinicalHistory(String string) {
        this.mClinicalHistory = StringStrip.trim(string);
    }

    public String getClinicalImpression() {
        return this.mClinicalImpression;
    }

    public void setClinicalImpression(String string) {
        this.mClinicalImpression = StringStrip.trim(string);
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = StringStrip.trim(string);
    }

    public List getKeywords() {
        return new ArrayList(this.mKeywords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeywords(Collection collection) {
        List list = this.mKeywords;
        synchronized (list) {
            this.mKeywords.clear();
            this.mKeywords.addAll(collection);
        }
    }

    public AccessLevel getAccessLevel() {
        return this.mAccessLevel;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.mAccessLevel = accessLevel;
    }

    public String getLastModifiedBy() {
        return this.mLastModifiedBy;
    }

    public void setLastModifiedBy(String string) {
        this.mLastModifiedBy = StringStrip.trim(string);
    }

    public Date getLastModifiedOn() {
        return new Date(this.mLastModifiedOn.getTime());
    }

    public void setLastModifiedOn(Date date) {
        if (date == null) {
            throw new NullPointerException("lastModifiedOn date cannot be null");
        }
        this.mLastModifiedOn = (Date)date.clone();
    }

    public String getCreatedBy() {
        return this.mCreatedBy;
    }

    public void setCreatedBy(String string) {
        this.mCreatedBy = StringStrip.trim(string);
    }

    public Date getCreatedOn() {
        return new Date(this.mCreatedOn.getTime());
    }

    public void setCreatedOn(Date date) {
        if (date == null) {
            throw new NullPointerException("createdOn date cannot be null");
        }
        this.mCreatedOn = new Date(date.getTime());
    }

    public String getNotes() {
        return this.mNotes;
    }

    public void setNotes(String string) {
        this.mNotes = StringStrip.trim(string);
    }

    public String getReasonForStudy() {
        return this.mReasonForStudy;
    }

    public void setReasonForStudy(String string) {
        this.mReasonForStudy = StringStrip.trim(string);
    }

    public String getTeachingClinicalHistory() {
        return this.mTeachingClinicalHistory;
    }

    public void setTeachingClinicalHistory(String string) {
        this.mTeachingClinicalHistory = StringStrip.trim(string);
    }

    public List getSeriesUids() {
        return new ArrayList(this.mSeriesUids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeriesUids(Collection collection) {
        List list = this.mSeriesUids;
        synchronized (list) {
            this.mSeriesUids.clear();
            this.mSeriesUids.addAll(collection);
        }
    }

    public static List getCaseIds(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TeachingCase teachingCase = (TeachingCase)iterator.next();
            arrayList.add(teachingCase.getCaseId());
        }
        return arrayList;
    }

    public Collection getProperties() {
        return Property.getAllProperties();
    }

    public static Set getSeriesUidList(Collection collection) {
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TeachingCase teachingCase = (TeachingCase)iterator.next();
            hashSet.addAll(teachingCase.getSeriesUids());
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TeachingCase)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        TeachingCase teachingCase = (TeachingCase)object;
        return this.mCaseId.equals(teachingCase.mCaseId);
    }

    public int hashCode() {
        return this.mCaseId.hashCode();
    }

    public void setTemporaryId(int n2) {
        this.setCaseId(TEMPORARY_ID_PREFIX + n2);
    }

    public boolean hasTemporaryId() {
        return this.mCaseId.startsWith(TEMPORARY_ID_PREFIX);
    }

    public static List getAllSeriesUids(Collection collection) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TeachingCase teachingCase = (TeachingCase)iterator.next();
            linkedHashSet.addAll(teachingCase.getSeriesUids());
        }
        return new ArrayList(linkedHashSet);
    }

    public boolean isModifiableBy(String string) {
        return this.mAccessLevel == AccessLevel.PUBLIC || this.getCreatedBy().equals(string);
    }

    public String getId() {
        return this.mCaseId;
    }

    public String getPatientId() {
        return this.mPatientId;
    }

    public void setPatientId(String string) {
        this.mPatientId = string;
    }

    public Date getStudyDate() {
        return this.mStudyDate;
    }

    public void setStudyDate(Date date) {
        this.mStudyDate = date;
    }

    public String getDiagnosis() {
        return this.mDiagnosis;
    }

    public void setDiagnosis(String string) {
        this.mDiagnosis = string;
    }

    public static class Property
    extends ModelProperty {
        private static Map mNameMap = new LinkedHashMap();
        public static final Property CaseId = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "CaseId", "Case ID");
        public static final Property Description = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "Description", "Description");
        public static final Property AcrCodes = new Property(class$java$util$List == null ? (class$java$util$List = TeachingCase.class$("java.util.List")) : class$java$util$List, "AcrCodes", "ACR Codes");
        public static final Property Anatomy = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "Anatomy", "Anatomy");
        public static final Property Pathology = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "Pathology", "Pathology");
        public static final Property ClinicalHistory = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "ClinicalHistory", "Clinical History");
        public static final Property TeachingClinicalHistory = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "TeachingClinicalHistory", "Teaching Clinical History");
        public static final Property ClinicalImpression = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "ClinicalImpression", "Clinical Findings");
        public static final Property ReasonForStudy = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "ReasonForStudy", "Reason For Study");
        public static final Property Keywords = new Property(class$java$util$List == null ? (class$java$util$List = TeachingCase.class$("java.util.List")) : class$java$util$List, "Keywords", "Keywords");
        public static final Property Notes = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "Notes", "Notes");
        public static final Property AccessLevel = new Property(class$com$intelerad$datamodels$teachingfile$AccessLevel == null ? (class$com$intelerad$datamodels$teachingfile$AccessLevel = TeachingCase.class$("com.intelerad.datamodels.teachingfile.AccessLevel")) : class$com$intelerad$datamodels$teachingfile$AccessLevel, "AccessLevel", "Access Level");
        public static final Property SeriesUids = new Property(class$java$util$List == null ? (class$java$util$List = TeachingCase.class$("java.util.List")) : class$java$util$List, "SeriesUids", "Series UIDs");
        public static final Property LastModifiedBy = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "LastModifiedBy", "Last Modified By");
        public static final Property LastModifiedOn = new Property(class$java$util$Date == null ? (class$java$util$Date = TeachingCase.class$("java.util.Date")) : class$java$util$Date, "LastModifiedOn", "Last Modified On");
        public static final Property CreatedBy = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "CreatedBy", "Author");
        public static final Property CreatedOn = new Property(class$java$util$Date == null ? (class$java$util$Date = TeachingCase.class$("java.util.Date")) : class$java$util$Date, "CreatedOn", "Created On");
        public static final Property PatientId = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "PatientId", "Patient ID");
        public static final Property StudyDate = new Property(class$java$util$Date == null ? (class$java$util$Date = TeachingCase.class$("java.util.Date")) : class$java$util$Date, "StudyDate", "Study Date");
        public static final Property Diagnosis = new Property(class$java$lang$String == null ? (class$java$lang$String = TeachingCase.class$("java.lang.String")) : class$java$lang$String, "Diagnosis", "Diagnosis");

        protected Property(Class clazz, String string, String string2) {
            super(clazz, string, string2);
            mNameMap.put(string, this);
        }

        public static Property getInstance(String string) {
            return (Property)mNameMap.get(string);
        }

        public static Collection getAllProperties() {
            return Collections.unmodifiableCollection(mNameMap.values());
        }

        public static Property[] getAllPropertiesAsArray() {
            return mNameMap.values().toArray(new Property[mNameMap.size()]);
        }
    }
}

