/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrinterProperty {
    private static final Map FIXED_VALUES = PrinterProperty.createFixedValuesMap();
    private static final List REQUIRED_PROPERTIES = Collections.unmodifiableList(Arrays.asList(PrintProtocol.Collate, PrintProtocol.TrueSize, DicomAttribute.ImageDisplayFormat, DicomAttribute.FilmOrientation, DicomAttribute.FilmSizeID));
    private static Map HELP_MESSAGES = PrinterProperty.createHelpMessagesMap();

    public static boolean hasFixedValues(ModelProperty modelProperty) {
        return FIXED_VALUES.containsKey(modelProperty);
    }

    public static List getFixedValues(ModelProperty modelProperty) {
        return (List)FIXED_VALUES.get(modelProperty);
    }

    public static boolean isRequired(ModelProperty modelProperty) {
        return REQUIRED_PROPERTIES.contains(modelProperty);
    }

    public static boolean allowsRange(ModelProperty modelProperty) {
        return !PrinterProperty.hasFixedValues(modelProperty) && modelProperty.getValueClass() != Boolean.class;
    }

    public static String getHelpString(ModelProperty modelProperty) {
        if (modelProperty instanceof DicomAttribute) {
            return ((DicomAttribute)modelProperty).getHelpString();
        }
        if (HELP_MESSAGES.containsKey(modelProperty)) {
            return (String)HELP_MESSAGES.get(modelProperty);
        }
        return "";
    }

    private static Map createFixedValuesMap() {
        HashMap<DicomAttribute, List<String>> hashMap = new HashMap<DicomAttribute, List<String>>();
        hashMap.put(DicomAttribute.FilmOrientation, Arrays.asList("LANDSCAPE", "PORTRAIT"));
        hashMap.put(DicomAttribute.FilmSizeID, Arrays.asList(DicomPrintConstants.getFilmSizes()));
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map createHelpMessagesMap() {
        HashMap<ModelProperty, String> hashMap = new HashMap<ModelProperty, String>();
        hashMap.put(PrintProtocol.Name, "The name of the printer protocol.");
        hashMap.put(PrintProtocol.Collate, "If enabled, multiple copies of films will be printed as\nseparate jobs, in sequential order. If disabled, each\nfilm will be printed the specified number of times before\nprinting the next one.");
        hashMap.put(PrintProtocol.TrueSize, "If enabled, images will be printed life-size.");
        return hashMap;
    }
}

