/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.DataModelBuilder;
import DataModels.MapDataModel;
import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrintProtocol
extends MapDataModel {
    public static ModelProperty Name = new ModelProperty(String.class, "Name", "Protocol");
    public static ModelProperty TrueSize = new ModelProperty(Boolean.class, "TrueSize", "True size");
    public static ModelProperty Collate = new ModelProperty(Boolean.class, "Collate", "Collate");
    public static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(Name, TrueSize, Collate, DicomAttribute.NumberOfCopies, DicomAttribute.PrintPriority, DicomAttribute.MediumType, DicomAttribute.FilmDestination, DicomAttribute.ImageDisplayFormat, DicomAttribute.FilmOrientation, DicomAttribute.FilmSizeID, DicomAttribute.MagnificationType, DicomAttribute.SmoothingType, DicomAttribute.BorderDensity, DicomAttribute.EmptyImageDensity, DicomAttribute.MinDensity, DicomAttribute.MaxDensity, DicomAttribute.Trim, DicomAttribute.ConfigurationInformation, DicomAttribute.RequestedResolutionID));

    public PrintProtocol() {
    }

    public PrintProtocol(PrintProtocol printProtocol) {
        DataModelBuilder.copyValues(this, printProtocol);
    }

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        super.setProperty(modelProperty, DataModelBuilder.convertValue(modelProperty, object));
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public void setName(String string) {
        this.setProperty(Name, string);
    }

    public String getName() {
        return (String)this.getProperty(Name);
    }

    public void setTrueSize(boolean bl2) {
        this.setProperty(TrueSize, new Boolean(bl2));
    }

    public boolean isTrueSize() {
        Boolean bl2 = (Boolean)this.getProperty(TrueSize);
        return bl2;
    }

    public boolean collate() {
        Boolean bl2 = (Boolean)this.getProperty(Collate);
        return bl2;
    }

    public int getImageDisplayFormatRows() {
        String string = (String)this.getProperty(DicomAttribute.ImageDisplayFormat);
        return DicomPrintConstants.getImageDisplayFormatDimension((String)string).height;
    }

    public int getImageDisplayFormatColumns() {
        String string = (String)this.getProperty(DicomAttribute.ImageDisplayFormat);
        return DicomPrintConstants.getImageDisplayFormatDimension((String)string).width;
    }

    public boolean isPortraitFilmOrientation() {
        return "PORTRAIT".equals((String)this.getProperty(DicomAttribute.FilmOrientation));
    }

    public int getImagesPerFilm() {
        return this.getImageDisplayFormatRows() * this.getImageDisplayFormatColumns();
    }

    public String toString() {
        return (String)this.getProperty(Name);
    }

    public int hashCode() {
        return DataModelBuilder.hashCode(this, this.getProperties());
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrintProtocol)) {
            return false;
        }
        return DataModelBuilder.equals(this, (PrintProtocol)object, this.getProperties());
    }
}

