/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;

public class KodakDryView8900 {
    private static final String IMAGE_DISPLAY_FORMATS = "1,1 1,2 2,1 2,2 2,3 3,2 2,4 4,2 3,3 3,4 4,3 3,5 5,3 4,4 4,5 5,4 4,6 6,4 5,6 6,5 5,7 7,5";

    public static PrinterConfiguration getConfiguration() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocolName("Kodak DryView 8900 Defaults");
        printerConfiguration.setValidRange(DicomAttribute.NumberOfCopies, 1, 99, 1);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.PrintPriority, new String[]{"LOW", "MED", "HIGH"}, (Object)"MED");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MediumType, new String[]{"CLEAR FILM", "BLUE FILM", "MAMMO BLUE FILM"}, (Object)"BLUE FILM");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmDestination, new String[]{"MAGAZINE", "PROCESSOR", "BIN1", "BIN2", "BIN3", "BIN4", "BIN5", "BIN6"}, (Object)"BIN1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ImageDisplayFormat, DicomPrintConstants.createEntries("STANDARD\\", IMAGE_DISPLAY_FORMATS), (Object)"STANDARD\\1,1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmOrientation, new String[]{"PORTRAIT", "LANDSCAPE"}, (Object)"PORTRAIT");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmSizeID, new String[]{"8INX10IN", "10INX12IN", "11INX14IN", "14INX14IN", "14INX17IN"}, (Object)"14INX17IN");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MagnificationType, new String[]{"NONE", "BILINEAR", "REPLICATE", "CUBIC"}, (Object)"CUBIC");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.SmoothingType, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "9", "10", "11", "12", "13", "14", "15", "NORMAL", "ENHANCED", "ENHANCED1"}, (Object)"5");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.RequestedResolutionID, new String[]{"STANDARD", "HIGH"}, (Object)"STANDARD");
        printerConfiguration.setValidValuesAndRange(DicomAttribute.BorderDensity, new String[]{"BLACK", "WHITE"}, 0, 399, "BLACK");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.EmptyImageDensity, new String[]{"BLACK", "WHITE"}, (Object)"BLACK");
        printerConfiguration.setValidRange(DicomAttribute.MinDensity, 0, 399, 21);
        printerConfiguration.setValidRange(DicomAttribute.MaxDensity, 170, 330, 300);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.Trim, new String[]{"YES", "NO"}, (Object)"NO");
        printerConfiguration.acceptAnyValue(DicomAttribute.ConfigurationInformation);
        printerConfiguration.verifyConfiguration();
        return printerConfiguration;
    }
}

