/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.DicomPrintConstants;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;

public class FujiDryPix7000 {
    private static final String IMAGE_DISPAY_FORMATS = "1,1 1,2 1,3 2,1 2,2 2,3 2,4 3,3 3,4 3,5 3,6 4,4 4,5 4,6 4,7 4,8 5,5 5,6 5,7 5,8 6,6 6,7 6,8 6,9 6,10 7,7 7,8 7,9 7,10 8,8 8,9 8,10";

    public static PrinterConfiguration getConfiguration() {
        PrinterConfiguration printerConfiguration = new PrinterConfiguration();
        printerConfiguration.setDefaultProtocolName("Fuji DRYPIX 7000 Defaults");
        printerConfiguration.setValidRange(DicomAttribute.NumberOfCopies, 1, 99, 1);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.PrintPriority, new String[]{"LOW", "MED", "HIGH"}, (Object)"MED");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MediumType, new String[]{"CLEAR FILM", "BLUE FILM"}, (Object)"CLEAR FILM");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmDestination, new String[]{"PROCESSOR", "BIN1", "BIN2", "BIN3", "BIN4", "BIN5", "BIN6", "BIN7", "BIN8", "BIN9", "BIN10"}, (Object)"BIN1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.ImageDisplayFormat, DicomPrintConstants.createEntries("STANDARD\\", IMAGE_DISPAY_FORMATS), (Object)"STANDARD\\1,1");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmOrientation, new String[]{"PORTRAIT", "LANDSCAPE"}, (Object)"PORTRAIT");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.FilmSizeID, new String[]{"8INX10IN", "10INX14IN", "14INX14IN", "14INX17IN"}, (Object)"14INX17IN");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.MagnificationType, new String[]{"NONE", "CUBIC"}, (Object)"CUBIC");
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.SmoothingType, new String[]{"SHARP", "MEDIUM", "SMOOTH"}, (Object)"MEDIUM");
        printerConfiguration.acceptAnyValue(DicomAttribute.RequestedResolutionID);
        printerConfiguration.setValidValuesAndRange(DicomAttribute.BorderDensity, new String[]{"BLACK", "WHITE"}, 0, 300, "BLACK");
        printerConfiguration.acceptAnyValue(DicomAttribute.EmptyImageDensity);
        printerConfiguration.setValidRange(DicomAttribute.MinDensity, 0, 300, 0);
        printerConfiguration.setValidRange(DicomAttribute.MaxDensity, 0, 360, 360);
        printerConfiguration.setValidValues((ModelProperty)DicomAttribute.Trim, new String[]{"YES", "NO"}, (Object)"NO");
        printerConfiguration.acceptAnyValue(DicomAttribute.ConfigurationInformation);
        printerConfiguration.verifyConfiguration();
        return printerConfiguration;
    }
}

