/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataModels.AbstractDataModel;
import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.print.AgfaDrystar3000;
import com.intelerad.datamodels.dicom.print.AgfaDrystar5500;
import com.intelerad.datamodels.dicom.print.AycanXrayPrint;
import com.intelerad.datamodels.dicom.print.EtiamDicomPri3;
import com.intelerad.datamodels.dicom.print.FujiDryPix7000;
import com.intelerad.datamodels.dicom.print.KodakDryView8150;
import com.intelerad.datamodels.dicom.print.KodakDryView8900;
import com.intelerad.datamodels.dicom.print.KonicaDryPro751And752;
import com.intelerad.datamodels.dicom.print.KonicaDryPro771;
import com.intelerad.datamodels.dicom.print.KonicaDryPro793;
import com.intelerad.datamodels.dicom.print.PrintProtocol;
import com.intelerad.datamodels.dicom.print.Printer;
import com.intelerad.datamodels.dicom.print.PrinterConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DicomPrintRepository
extends AbstractDataModel {
    public static final Printer EMPTY_PRINTER = DicomPrintRepository.createEmptyPrinter();
    public static final ModelProperty PrinterConfigurations = new ModelProperty(List.class, "PrinterConfigurations", "Printer Configurations");
    public static final ModelProperty Printers = new ModelProperty(List.class, "Printers", "Printers");
    public static final ModelProperty Protocols = new ModelProperty(List.class, "Protocols", "Protocols");
    public static final List PROPERTIES = Arrays.asList(PrinterConfigurations, Printers, Protocols);
    private List mPrinterConfigurations = new ArrayList();
    private List mPrintProtocols = new ArrayList();
    private List mPrinters = new ArrayList();

    private DicomPrintRepository() {
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public List getPrinterConfigurations() {
        return new ArrayList(this.mPrinterConfigurations);
    }

    public List getProtocols() {
        return new ArrayList(this.mPrintProtocols);
    }

    public List getProtocols(PrinterConfiguration printerConfiguration) {
        ArrayList<PrintProtocol> arrayList = new ArrayList<PrintProtocol>();
        arrayList.add(printerConfiguration.getDefaultProtocol());
        Iterator iterator = this.mPrintProtocols.iterator();
        while (iterator.hasNext()) {
            PrintProtocol printProtocol = (PrintProtocol)iterator.next();
            if (!printerConfiguration.isValid(printProtocol)) continue;
            arrayList.add(printProtocol);
        }
        return arrayList;
    }

    public List getPrinters() {
        if (this.mPrinters.isEmpty()) {
            return Collections.singletonList(EMPTY_PRINTER);
        }
        return new ArrayList(this.mPrinters);
    }

    public void setPrinterConfigurations(List list) {
        List list2 = this.mPrinterConfigurations;
        this.mPrinterConfigurations = new ArrayList(list);
        this.firePropertyChange(PrinterConfigurations, list2);
    }

    public void setProtocols(List list) {
        List list2 = this.mPrintProtocols;
        this.mPrintProtocols = new ArrayList(list);
        this.firePropertyChange(Protocols, list2);
    }

    public void setPrinters(List list) {
        List list2 = this.mPrinters;
        this.mPrinters = new ArrayList(list);
        this.firePropertyChange(Printers, list2);
    }

    public void addPrintProtocol(PrintProtocol printProtocol) {
        List list = this.getProtocols();
        this.mPrintProtocols.add(printProtocol);
        this.firePropertyChange(Protocols, list);
    }

    public void addPrinter(Printer printer) {
        List list = this.getPrinters();
        this.mPrinters.add(printer);
        this.firePropertyChange(Printers, list);
    }

    public void removePrintProtocol(PrintProtocol printProtocol) {
        List list = this.getProtocols();
        this.mPrintProtocols.remove(printProtocol);
        this.firePropertyChange(Protocols, list);
    }

    public void removePrintProtocol(String string) {
        List list = this.getProtocols();
        Iterator iterator = this.mPrintProtocols.iterator();
        while (iterator.hasNext()) {
            PrintProtocol printProtocol = (PrintProtocol)iterator.next();
            if (!printProtocol.getName().equals(string)) continue;
            iterator.remove();
            this.firePropertyChange(Protocols, list);
            return;
        }
    }

    public void removePrinter(Printer printer) {
        List list = this.getPrinters();
        this.mPrinters.remove(printer);
        this.firePropertyChange(Printers, list);
    }

    public static DicomPrintRepository createSampleRepository() {
        ArrayList<PrinterConfiguration> arrayList = new ArrayList<PrinterConfiguration>();
        arrayList.add(EtiamDicomPri3.getPrinterConfiguration());
        arrayList.add(KonicaDryPro751And752.getConfiguration());
        arrayList.add(KonicaDryPro771.getConfiguration());
        arrayList.add(KonicaDryPro793.getConfiguration());
        arrayList.add(KodakDryView8150.getConfiguration());
        arrayList.add(KodakDryView8900.getConfiguration());
        arrayList.add(AgfaDrystar5500.getConfiguration());
        arrayList.add(AgfaDrystar3000.getConfiguration());
        arrayList.add(FujiDryPix7000.getConfiguration());
        arrayList.add(AycanXrayPrint.getPrinterConfiguration());
        DicomPrintRepository dicomPrintRepository = new DicomPrintRepository();
        dicomPrintRepository.setPrinterConfigurations(arrayList);
        dicomPrintRepository.setProtocols(DicomPrintRepository.createSampleProtocols());
        dicomPrintRepository.setPrinters(DicomPrintRepository.createSamplePrinters(arrayList));
        return dicomPrintRepository;
    }

    public static DicomPrintRepository createInstance(List list, List list2, List list3) {
        DicomPrintRepository dicomPrintRepository = new DicomPrintRepository();
        dicomPrintRepository.setPrinterConfigurations(list);
        dicomPrintRepository.setProtocols(list2);
        dicomPrintRepository.setPrinters(list3);
        return dicomPrintRepository;
    }

    private static List createSamplePrinters(List list) {
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PrinterConfiguration printerConfiguration = (PrinterConfiguration)iterator.next();
            String string = printerConfiguration.getDefaultProtocol().getName();
            string = string.substring(0, string.indexOf(" Defaults"));
            arrayList.add(DicomPrintRepository.createPrinter(string, "AETITLE", "localhost", 1234, printerConfiguration));
        }
        return arrayList;
    }

    private static Printer createPrinter(String string, String string2, String string3, int n2, PrinterConfiguration printerConfiguration) {
        Printer printer = new Printer();
        printer.setProperty(Printer.Name, string);
        printer.setProperty(Printer.AeTitle, string2);
        printer.setProperty(Printer.Host, string3);
        printer.setProperty(Printer.Port, new Integer(n2));
        printer.setProperty(Printer.Configuration, printerConfiguration);
        return printer;
    }

    private static List createSampleProtocols() {
        ArrayList<PrintProtocol> arrayList = new ArrayList<PrintProtocol>();
        PrintProtocol printProtocol = new PrintProtocol();
        printProtocol.setName("1x1 Portrait Trim box 5 copies");
        printProtocol.setProperty((ModelProperty)DicomAttribute.ImageDisplayFormat, "STANDARD\\1,1");
        printProtocol.setProperty((ModelProperty)DicomAttribute.FilmOrientation, "PORTRAIT");
        printProtocol.setProperty((ModelProperty)DicomAttribute.Trim, "YES");
        printProtocol.setProperty((ModelProperty)DicomAttribute.NumberOfCopies, 5);
        arrayList.add(printProtocol);
        printProtocol = new PrintProtocol();
        printProtocol.setName("2x2 Portrait");
        printProtocol.setProperty((ModelProperty)DicomAttribute.ImageDisplayFormat, "STANDARD\\2,2");
        printProtocol.setProperty((ModelProperty)DicomAttribute.FilmOrientation, "PORTRAIT");
        arrayList.add(printProtocol);
        printProtocol = new PrintProtocol();
        printProtocol.setName("3x3 Landscape");
        printProtocol.setProperty((ModelProperty)DicomAttribute.ImageDisplayFormat, "STANDARD\\3,3");
        printProtocol.setProperty((ModelProperty)DicomAttribute.FilmOrientation, "LANDSCAPE");
        arrayList.add(printProtocol);
        printProtocol = new PrintProtocol();
        printProtocol.setName("5x5 Portrait 14\"x17\"");
        printProtocol.setProperty((ModelProperty)DicomAttribute.ImageDisplayFormat, "STANDARD\\5,5");
        printProtocol.setProperty((ModelProperty)DicomAttribute.FilmOrientation, "PORTRAIT");
        printProtocol.setProperty((ModelProperty)DicomAttribute.FilmSizeID, "14INX17IN");
        arrayList.add(printProtocol);
        return arrayList;
    }

    private static Printer createEmptyPrinter() {
        Printer printer = new Printer();
        printer.setProperty(Printer.Name, "No Printers Defined");
        printer.setProperty(Printer.AeTitle, "");
        printer.setProperty(Printer.Host, "");
        printer.setProperty(Printer.Port, new Integer(0));
        printer.setProperty(Printer.Configuration, PrinterConfiguration.getEmptyConfiguration());
        return printer;
    }
}

