/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom.print;

import DataStructures.Size;
import RuntimeTool.DebugManager;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.ImageDisplayParameters;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DicomPrintConstants {
    private static final Map FILM_SIZE_MAP = DicomPrintConstants.createFilmSizeMap();
    public static final String PRINT_PRIORITY_HIGH = "HIGH";
    public static final String PRINT_PRIORITY_MED = "MED";
    public static final String PRINT_PRIORITY_LOW = "LOW";
    public static final String MEDIUM_TYPE_PAPER = "PAPER";
    public static final String MEDIUM_TYPE_CLEAR = "CLEAR FILM";
    public static final String MEDIUM_TYPE_BLUE = "BLUE FILM";
    public static final String MEDIUM_TYPE_MAMMO_CLEAR_FILM = "MAMMO CLEAR FILM";
    public static final String MEDIUM_TYPE_MAMMO_BLUE_FILM = "MAMMO BLUE FILM";
    public static final String FILM_DESTINATION_MAGAZINE = "MAGAZINE";
    public static final String FILM_DESTINATION_PROCESSOR = "PROCESSOR";
    public static final String FILM_DESTINATION_BIN = "BIN";
    public static final String IMAGE_DISPLAY_FORMAT_STANDARD = "STANDARD\\";
    public static final String IMAGE_DISPLAY_FORMAT_ROW = "ROW\\";
    public static final String IMAGE_DISPLAY_FORMAT_COL = "COL\\";
    public static final String IMAGE_DISPLAY_FORMAT_SLIDE = "SLIDE";
    public static final String IMAGE_DISPLAY_FORMAT_SUPERSLIDE = "SUPERSLIDE";
    public static final String IMAGE_DISPLAY_FORMAT_CUSTOM = "CUSTOM\\";
    public static final String FILM_ORIENTATION_PORTRAIT = "PORTRAIT";
    public static final String FILM_ORIENTATION_LANDSCAPE = "LANDSCAPE";
    public static final String FILM_SIZE_ID_8INX10IN = "8INX10IN";
    public static final String FILM_SIZE_ID_8_5INX11IN = "8_5INX11IN";
    public static final String FILM_SIZE_ID_10INX12IN = "10INX12IN";
    public static final String FILM_SIZE_ID_10INX14IN = "10INX14IN";
    public static final String FILM_SIZE_ID_11INX14IN = "11INX14IN";
    public static final String FILM_SIZE_ID_11INX17IN = "11INX17IN";
    public static final String FILM_SIZE_ID_14INX14IN = "14INX14IN";
    public static final String FILM_SIZE_ID_14INX17IN = "14INX17IN";
    public static final String FILM_SIZE_ID_24CMX24CM = "24CMX24CM";
    public static final String FILM_SIZE_ID_24CMX30CM = "24CMX30CM";
    public static final String FILM_SIZE_ID_A4 = "A4";
    public static final String FILM_SIZE_ID_A3 = "A3";
    public static final String MAGNIFICATION_TYPE_REPLICATE = "REPLICATE";
    public static final String MAGNIFICATION_TYPE_BILINEAR = "BILINEAR";
    public static final String MAGNIFICATION_TYPE_CUBIC = "CUBIC";
    public static final String MAGNIFICATION_TYPE_NONE = "NONE";
    public static final String BORDER_DENSITY_BLACK = "BLACK";
    public static final String BORDER_DENSITY_WHITE = "WHITE";
    public static final String EMPTY_IMAGE_DENSITY_BLACK = "BLACK";
    public static final String EMPTY_IMAGE_DENSITY_WHITE = "WHITE";
    public static final String TRIM_YES = "YES";
    public static final String TRIM_NO = "NO";
    public static final String REQUESTED_RESOLUTION_ID_STANDARD = "STANDARD";
    public static final String REQUESTED_RESOLUTION_ID_HIGH = "HIGH";
    public static final String POLARITY_NORMAL = "NORMAL";
    public static final String POLARITY_REVERSE = "REVERSE";
    public static final String REQUESTED_DECIMATECROP_BEHAVIOR_DECIMATE = "DECIMATE";
    public static final String REQUESTED_DECIMATECROP_BEHAVIOR_CROP = "CROP";
    public static final String REQUESTED_DECIMATECROP_BEHAVIOR_FAIL = "FAIL";
    public static final String EXECUTION_STATUS_PENDING = "PENDING";
    public static final String EXECUTION_STATUS_PRINTING = "PRINTING";
    public static final String EXECUTION_STATUS_DONE = "DONE";
    public static final String EXECUTION_STATUS_FAILURE = "FAILURE";
    public static final String EXECUTION_STATUS_INFO_DONE = "DONE";
    public static final String EXECUTION_STATUS_INFO_NORMAL = "NORMAL";
    public static final String EXECUTION_STATUS_INFO_INVALID_PAGE_DES = "INVALID PAGE DES";
    public static final String EXECUTION_STATUS_INFO_INSUFFIC_MEMORY = "INSUFFIC MEMORY";
    public static final String PRINTER_STATUS_NORMAL = "NORMAL";
    public static final String PRINTER_STATUS_WARNING = "WARNING";
    public static final String PRINTER_STATUS_FAILURE = "FAILURE";
    public static final String PRINTER_STATUS_INFO_NORMAL = "NORMAL";
    public static final String COLOR_IMAGE_PRINTING_FLAG_BESTFIT = "BESTFIT";
    public static final String COLOR_IMAGE_PRINTING_FLAG_REJECT = "REJECT";
    public static final String COLLATION_FLAG_YES = "YES";
    public static final String COLLATION_FLAG_NO = "NO";
    public static final String ANNOTATION_FLAG_BESTFIT = "BESTFIT";
    public static final String ANNOTATION_FLAG_REJECT = "REJECT";
    public static final String IMAGE_OVERLAY_FLAG_BESTFIT = "BESTFIT";
    public static final String IMAGE_OVERLAY_FLAG_REJECT = "REJECT";
    public static final String PRESENTATION_LUT_FLAG_BESTFIT = "BESTFIT";
    public static final String PRESENTATION_LUT_FLAG_REJECT = "REJECT";
    public static final String IMAGE_BOX_PRESENTATION_LUT_FLAG_BESTFIT = "BESTFIT";
    public static final String IMAGE_BOX_PRESENTATION_LUT_FLAG_REJECT = "REJECT";

    public static List createEntries(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string2.split(" ");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].trim().length() == 0) continue;
            arrayList.add(string + stringArray[i2]);
        }
        return arrayList;
    }

    public static List createEntries(int n2, int n3) {
        ArrayList<String> arrayList = new ArrayList<String>(1 + n3 - n2);
        for (int i2 = n2; i2 <= n3; ++i2) {
            arrayList.add("" + i2);
        }
        return arrayList;
    }

    public static String createStandardImageDisplayFormat(int n2, int n3) {
        return IMAGE_DISPLAY_FORMAT_STANDARD + n3 + "," + n2;
    }

    public static Size getFilmSize(Object object) {
        return (Size)FILM_SIZE_MAP.get(object);
    }

    private static Map createFilmSizeMap() {
        HashMap<String, Size> hashMap = new HashMap<String, Size>();
        hashMap.put(FILM_SIZE_ID_8INX10IN, Size.inIN(8.0, 10.0));
        hashMap.put(FILM_SIZE_ID_8_5INX11IN, Size.inIN(8.5, 11.0));
        hashMap.put(FILM_SIZE_ID_10INX12IN, Size.inIN(10.0, 12.0));
        hashMap.put(FILM_SIZE_ID_10INX14IN, Size.inIN(10.0, 14.0));
        hashMap.put(FILM_SIZE_ID_11INX14IN, Size.inIN(11.0, 14.0));
        hashMap.put(FILM_SIZE_ID_11INX17IN, Size.inIN(11.0, 17.0));
        hashMap.put(FILM_SIZE_ID_14INX14IN, Size.inIN(14.0, 14.0));
        hashMap.put(FILM_SIZE_ID_14INX17IN, Size.inIN(14.0, 17.0));
        hashMap.put(FILM_SIZE_ID_24CMX24CM, Size.inCM(24.0, 24.0));
        hashMap.put(FILM_SIZE_ID_24CMX30CM, Size.inIN(24.0, 30.0));
        hashMap.put(FILM_SIZE_ID_A4, Size.inMM(210.0, 297.0));
        hashMap.put(FILM_SIZE_ID_A3, Size.inMM(297.0, 420.0));
        return Collections.unmodifiableMap(hashMap);
    }

    public static String[] getFilmSizes() {
        return new String[]{FILM_SIZE_ID_8INX10IN, FILM_SIZE_ID_8_5INX11IN, FILM_SIZE_ID_10INX12IN, FILM_SIZE_ID_10INX14IN, FILM_SIZE_ID_11INX14IN, FILM_SIZE_ID_11INX17IN, FILM_SIZE_ID_14INX14IN, FILM_SIZE_ID_14INX17IN, FILM_SIZE_ID_24CMX24CM, FILM_SIZE_ID_24CMX30CM, FILM_SIZE_ID_A4, FILM_SIZE_ID_A3};
    }

    public static List getBasicFilmSessionPresentationModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.NumberOfCopies);
        arrayList.add(DicomAttribute.PrintPriority);
        arrayList.add(DicomAttribute.MediumType);
        arrayList.add(DicomAttribute.FilmDestination);
        arrayList.add(DicomAttribute.FilmSessionLabel);
        arrayList.add(DicomAttribute.MemoryAllocation);
        arrayList.add(DicomAttribute.OwnerID);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getBasicFilmSessionRelationshipModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.ReferencedFilmBoxSequence);
        arrayList.add(DicomAttribute.ProposedStudySequence);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getBasicFilmBoxPresentationModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.ImageDisplayFormat);
        arrayList.add(DicomAttribute.AnnotationDisplayFormatID);
        arrayList.add(DicomAttribute.FilmOrientation);
        arrayList.add(DicomAttribute.FilmSizeID);
        arrayList.add(DicomAttribute.MagnificationType);
        arrayList.add(DicomAttribute.SmoothingType);
        arrayList.add(DicomAttribute.BorderDensity);
        arrayList.add(DicomAttribute.EmptyImageDensity);
        arrayList.add(DicomAttribute.MinDensity);
        arrayList.add(DicomAttribute.MaxDensity);
        arrayList.add(DicomAttribute.Trim);
        arrayList.add(DicomAttribute.ConfigurationInformation);
        arrayList.add(DicomAttribute.Illumination);
        arrayList.add(DicomAttribute.ReflectedAmbientLight);
        arrayList.add(DicomAttribute.RequestedResolutionID);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getBasicFilmBoxRelationshipModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.ReferencedFilmSessionSequence);
        arrayList.add(DicomAttribute.ReferencedImageBoxSequence);
        arrayList.add(DicomAttribute.ReferencedBasicAnnotationBox);
        arrayList.add(DicomAttribute.ReferencedPresentationLUT);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getImageBoxPixelPresentationModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.ImagePosition);
        arrayList.add(DicomAttribute.Polarity);
        arrayList.add(DicomAttribute.MagnificationType);
        arrayList.add(DicomAttribute.SmoothingType);
        arrayList.add(DicomAttribute.ConfigurationInformation);
        arrayList.add(DicomAttribute.RequestedImageSize);
        arrayList.add(DicomAttribute.RequestedDecimateCropBehavior);
        arrayList.add(DicomAttribute.BasicGrayscaleImageSequence);
        arrayList.add(DicomAttribute.BasicColorImageSequence);
        arrayList.add(DicomAttribute.ReferencedImageOverlayBox);
        arrayList.add(DicomAttribute.OriginalImageSequence);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getBasicAnnotationPresentationModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.AnnotationPosition);
        arrayList.add(DicomAttribute.TextString);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getPrintJobModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.ExecutionStatus);
        arrayList.add(DicomAttribute.ExecutionStatusInfo);
        arrayList.add(DicomAttribute.CreationDate);
        arrayList.add(DicomAttribute.CreationTime);
        arrayList.add(DicomAttribute.PrintPriority);
        arrayList.add(DicomAttribute.PrinterName);
        arrayList.add(DicomAttribute.Originator);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getPrinterModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.PrinterStatus);
        arrayList.add(DicomAttribute.PrinterStatusInfo);
        arrayList.add(DicomAttribute.PrinterName);
        arrayList.add(DicomAttribute.Manufacturer);
        arrayList.add(DicomAttribute.ManufacturerModelName);
        arrayList.add(DicomAttribute.DeviceSerialNumber);
        arrayList.add(DicomAttribute.SoftwareVersions);
        arrayList.add(DicomAttribute.DateOfLastCalibration);
        arrayList.add(DicomAttribute.TimeOfLastCalibration);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getPrintRequestModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.NumberOfCopies);
        arrayList.add(DicomAttribute.PrintPriority);
        arrayList.add(DicomAttribute.MediumType);
        arrayList.add(DicomAttribute.FilmDestination);
        arrayList.add(DicomAttribute.FilmSessionLabel);
        arrayList.add(DicomAttribute.MemoryAllocation);
        arrayList.add(DicomAttribute.ColorImagePrintingFlag);
        arrayList.add(DicomAttribute.CollationFlag);
        arrayList.add(DicomAttribute.AnnotationFlag);
        arrayList.add(DicomAttribute.ImageOverlayFlag);
        arrayList.add(DicomAttribute.PresentationLUTFlag);
        arrayList.add(DicomAttribute.ImageBoxPresentationLUTFlag);
        arrayList.add(DicomAttribute.ConfigurationInformation);
        arrayList.add(DicomAttribute.Illumination);
        arrayList.add(DicomAttribute.ReflectedAmbientLight);
        arrayList.add(DicomAttribute.OwnerID);
        arrayList.add(DicomAttribute.ReferencedStoredPrintSequence);
        return Collections.unmodifiableList(arrayList);
    }

    public static List getPrinterConfigurationModule() {
        ArrayList<DicomAttribute> arrayList = new ArrayList<DicomAttribute>();
        arrayList.add(DicomAttribute.PrinterConfiguration);
        return Collections.unmodifiableList(arrayList);
    }

    public static Dimension getImageDisplayFormatDimension(String string) {
        try {
            ImageDisplayParameters imageDisplayParameters = new ImageDisplayParameters(string);
            int[] nArray = imageDisplayParameters.getArguments();
            return new Dimension(nArray[0], nArray[1]);
        }
        catch (ParseException parseException) {
            DebugManager.getDefault().printException("Cannot convert image display format value to rows and columns: " + string, parseException);
            return new Dimension(1, 1);
        }
    }
}

