/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom;

import com.intelerad.datamodels.dicom.DimseStatus;
import com.intelerad.datamodels.dicom.print.DicomPrintDimseStatusList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DimseStatusRepository {
    private final Map mEntries = new HashMap();
    private final List mWarningCodes = new ArrayList();
    private static final DimseStatusRepository mInstance = DimseStatusRepository.createInstance();

    public static DimseStatus getStatus(String string, int n2) {
        return mInstance.getEntry(string, n2);
    }

    public static List getWarningCodes() {
        return new ArrayList(DimseStatusRepository.mInstance.mWarningCodes);
    }

    private DimseStatusRepository() {
    }

    private void addEntries(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DimseStatus dimseStatus = (DimseStatus)iterator.next();
            this.mEntries.put(DimseStatusRepository.getKey(dimseStatus.getSopClassUid(), dimseStatus.getCode()), dimseStatus);
            if (!dimseStatus.isWarning()) continue;
            this.mWarningCodes.add(new Integer(dimseStatus.getCode()));
        }
    }

    private DimseStatus getEntry(String string, int n2) {
        return (DimseStatus)this.mEntries.get(DimseStatusRepository.getKey(string, n2));
    }

    private static String getKey(String string, int n2) {
        return string + ":" + n2;
    }

    private static DimseStatusRepository createInstance() {
        DimseStatusRepository dimseStatusRepository = new DimseStatusRepository();
        dimseStatusRepository.addEntries(new DicomPrintDimseStatusList().getStatusList());
        return dimseStatusRepository;
    }
}

