/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom;

import DataModels.MapDataModel;
import DataModels.ModelProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DimseStatus
extends MapDataModel {
    public static final String BASIC_FILM_SESSION_SOP_CLASS = "1.2.840.10008.5.1.1.1";
    public static final String BASIC_FILM_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.2";
    public static final String BASIC_GRAYSCALE_IMAGE_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.4";
    public static final String BASIC_COLOR_IMAGE_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.4.1";
    public static final String PRESENTATION_LUT_SOP_CLASS = "1.2.840.10008.5.1.1.23";
    public static final String PULL_PRINT_REQUEST_SOP_CLASS = "1.2.840.10008.5.1.1.31";
    public static final String BASIC_PRINT_IMAGE_OVERLAY_BOX_SOP_CLASS = "1.2.840.10008.5.1.1.24.1";
    public static final StatusType SUCCESS = new StatusType();
    public static final StatusType WARNING = new StatusType();
    public static final StatusType FAILURE = new StatusType();
    public static final ModelProperty SopClassUid = new ModelProperty(String.class, "SopClassUid", "SOP Class UID");
    public static final ModelProperty Code = new ModelProperty(Integer.class, "Code", "Code");
    public static final ModelProperty Type = new ModelProperty(StatusType.class, "Error", "Error");
    public static final ModelProperty Message = new ModelProperty(String.class, "Message", "Message");
    public static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(SopClassUid, Code, Type, Message));

    public DimseStatus(String string, int n2, StatusType statusType, String string2) {
        this.setProperty(SopClassUid, string);
        this.setProperty(Code, new Integer(n2));
        this.setProperty(Type, statusType);
        this.setProperty(Message, string2);
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public String getSopClassUid() {
        return (String)this.getProperty(SopClassUid);
    }

    public int getCode() {
        return (Integer)this.getProperty(Code);
    }

    public boolean isSuccess() {
        return this.getProperty(Type) == SUCCESS;
    }

    public boolean isFailure() {
        return this.getProperty(Type) == FAILURE;
    }

    public boolean isWarning() {
        return this.getProperty(Type) == WARNING;
    }

    public String getMessage() {
        return (String)this.getProperty(Message);
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.getCode()) + " " + (this.isFailure() ? "Failure" : "Warning") + " " + this.getMessage();
    }

    public static final class StatusType {
    }
}

