/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.datamodels.dicom;

import DataModels.ModelProperty;
import DataModels.ObservableDataModel;
import DateUtilities.DateUtilities;
import RuntimeTool.DebugManager;
import com.archimed.dicom.DDate;
import com.archimed.dicom.DDateRange;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.TagValue;
import com.intelerad.datamodels.dicom.DicomAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class DicomDataModel
extends ObservableDataModel {
    private static final Comparator DICOM_OBJECT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            DicomAttribute dicomAttribute = (DicomAttribute)object;
            DicomAttribute dicomAttribute2 = (DicomAttribute)object2;
            if (dicomAttribute.getGroup() < dicomAttribute2.getGroup()) {
                return -1;
            }
            if (dicomAttribute.getGroup() > dicomAttribute2.getGroup()) {
                return 1;
            }
            if (dicomAttribute.getElement() < dicomAttribute2.getElement()) {
                return -1;
            }
            if (dicomAttribute.getElement() > dicomAttribute2.getElement()) {
                return 1;
            }
            return 0;
        }
    };
    private DicomObject mDicomObject;

    public DicomDataModel(DicomObject dicomObject) {
        this.mDicomObject = dicomObject;
    }

    public DicomDataModel() {
        this.mDicomObject = new DicomObject();
    }

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        if (!(modelProperty instanceof DicomAttribute)) {
            throw new ClassCastException("Argument must be a DicomAttribute");
        }
        DicomAttribute dicomAttribute = (DicomAttribute)modelProperty;
        if (dicomAttribute.getVR().equals("SQ") && object instanceof List) {
            DicomDataModel.setSequence(this.mDicomObject, dicomAttribute, (List)object);
        } else if (object instanceof List) {
            DicomDataModel.setValues(this.mDicomObject, dicomAttribute, (List)object);
        } else {
            DicomDataModel.setValue(this.mDicomObject, dicomAttribute, object);
        }
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        if (!(modelProperty instanceof DicomAttribute)) {
            throw new ClassCastException("Argument must be a DicomAttribute");
        }
        DicomAttribute dicomAttribute = (DicomAttribute)modelProperty;
        if (dicomAttribute.getVR().equals("SQ")) {
            return this.getSequence(dicomAttribute);
        }
        if (DicomDataModel.isMultivalue(this.mDicomObject, dicomAttribute)) {
            return this.getMultiValue(dicomAttribute);
        }
        return DicomDataModel.convertFromJdtObject(this.mDicomObject, dicomAttribute, this.mDicomObject.get_ge(dicomAttribute.getGroup(), dicomAttribute.getElement()));
    }

    public Collection getProperties() {
        Enumeration enumeration = this.mDicomObject.enumerateVRs(false);
        ArrayList arrayList = new ArrayList();
        List list = DicomAttribute.getAllAttributes();
        Collections.sort(list, DICOM_OBJECT_COMPARATOR);
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TagValue tagValue = (TagValue)enumeration.nextElement();
            int n3 = DicomDataModel.findGroupElement(list, n2, tagValue.getGroup(), tagValue.getElement());
            if (n3 == -1) continue;
            n2 = n3;
            arrayList.add(list.get(n3));
        }
        return arrayList;
    }

    public DicomObject getDicomObject() {
        return this.mDicomObject;
    }

    private static Object convertFromJdtObject(DicomObject dicomObject, DicomAttribute dicomAttribute, Object object) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof DDate) {
                if (dicomAttribute.getValueClass().equals(Date.class)) {
                    return DicomDataModel.getDate((DDate)object);
                }
                return new IllegalStateException("Don't know how to convert between DDate and " + dicomAttribute.getValueClass());
            }
            if (object instanceof DDateRange) {
                if (dicomAttribute.getValueClass().equals(Date.class)) {
                    return new Date[]{DicomDataModel.getDate(((DDateRange)object).getDate1()), DicomDataModel.getDate(((DDateRange)object).getDate2())};
                }
                return new IllegalStateException("Don't know how to convert between DDateRange and " + dicomAttribute.getValueClass());
            }
            if (object instanceof Person) {
                if (dicomAttribute.getValueClass().equals(String.class)) {
                    return ((Person)object).toDICOMString();
                }
                return new IllegalStateException("Don't know how to convert between Person and " + dicomAttribute.getValueClass());
            }
            if (object instanceof DicomObject && dicomAttribute.getValueClass().equals(List.class)) {
                return object;
            }
            if (!object.getClass().equals(dicomAttribute.getValueClass()) && !dicomAttribute.getValueClass().equals(List.class)) {
                return new IllegalStateException("Object from DICOM is " + object.getClass() + " and we were expecting " + dicomAttribute.getValueClass());
            }
            return object;
        }
        catch (ParseException parseException) {
            DebugManager.getDefault().printTrace("Error parsing a date \"" + object + "\" for attribute " + dicomAttribute + ". Will return null for the value. " + DicomDataModel.getIdentifierString(dicomObject));
            return null;
        }
    }

    private static String getIdentifierString(DicomObject dicomObject) {
        try {
            String string = dicomObject.getS(426);
            String string2 = dicomObject.getS(425);
            String string3 = dicomObject.getS(63);
            String string4 = dicomObject.getS(77);
            Person person = (Person)dicomObject.get(147);
            String string5 = "";
            if (string3 != null) {
                string5 = " Instance: " + string3;
            }
            if (string != null) {
                string5 = string5 + " Series: " + string;
            } else if (string2 != null) {
                string5 = string5 + " Study: " + string2;
            }
            if (string4 != null) {
                string5 = string5 + " Accession Number: " + string4;
            }
            if (person != null) {
                string5 = string5 + " Patient: " + person.toDICOMString();
            }
            return string5.trim();
        }
        catch (DicomException dicomException) {
            DebugManager.getDefault().printException("Could not get IdentifierString(). This is not a fatal error. Continuing...", dicomException);
            return "";
        }
    }

    private static Object convertToJdtObject(DicomAttribute dicomAttribute, Object object) {
        String string = dicomAttribute.getVR();
        if (string.equals("DA")) {
            if (object instanceof Date) {
                return new DDate(DateUtilities.getDicomDateString((Date)object));
            }
            if (object instanceof Date[]) {
                return new DDateRange(new DDate(DateUtilities.getDicomDateString(((Date[])object)[0])), new DDate(DateUtilities.getDicomDateString(((Date[])object)[1])));
            }
            return new IllegalStateException("Don't know how to convert " + dicomAttribute.getValueClass() + " to DDate.");
        }
        if (string.equals("PN")) {
            if (object instanceof String) {
                return new Person((String)object);
            }
            return new IllegalStateException("Don't know how to convert " + dicomAttribute.getValueClass() + " to Person.");
        }
        return object;
    }

    private static void setValues(DicomObject dicomObject, DicomAttribute dicomAttribute, List list) {
        DicomDataModel.deleteMultiValue(dicomObject, dicomAttribute);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            try {
                dicomObject.set_ge(dicomAttribute.getGroup(), dicomAttribute.getElement(), DicomDataModel.convertToJdtObject(dicomAttribute, list.get(i2)), i2);
                continue;
            }
            catch (DicomException dicomException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unexpected exception");
                illegalArgumentException.initCause(dicomException);
                throw illegalArgumentException;
            }
        }
    }

    private static void setSequence(DicomObject dicomObject, DicomAttribute dicomAttribute, List list) {
        ArrayList<DicomObject> arrayList = new ArrayList<DicomObject>(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            arrayList.add(((DicomDataModel)list.get(i2)).getDicomObject());
        }
        DicomDataModel.setValues(dicomObject, dicomAttribute, arrayList);
    }

    private static void deleteMultiValue(DicomObject dicomObject, DicomAttribute dicomAttribute) {
        int n2 = DicomDataModel.getMultivalueSize(dicomObject, dicomAttribute);
        if (n2 == -1) {
            n2 = 0;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            dicomObject.deleteItem_ge(dicomAttribute.getGroup(), dicomAttribute.getElement(), i2);
        }
    }

    private static int getMultivalueSize(DicomObject dicomObject, DicomAttribute dicomAttribute) {
        return dicomObject.getSize_ge(dicomAttribute.getGroup(), dicomAttribute.getElement());
    }

    private static boolean isMultivalue(DicomObject dicomObject, DicomAttribute dicomAttribute) {
        return DicomDataModel.getMultivalueSize(dicomObject, dicomAttribute) > 1;
    }

    private static void setValue(DicomObject dicomObject, DicomAttribute dicomAttribute, Object object) {
        try {
            dicomObject.set_ge(dicomAttribute.getGroup(), dicomAttribute.getElement(), DicomDataModel.convertToJdtObject(dicomAttribute, object));
        }
        catch (DicomException dicomException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unexpected dicom exception.");
            illegalArgumentException.initCause(dicomException);
            throw illegalArgumentException;
        }
    }

    private List getMultiValue(DicomAttribute dicomAttribute) {
        int n2 = DicomDataModel.getMultivalueSize(this.mDicomObject, dicomAttribute);
        if (n2 == -1) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = DicomDataModel.convertFromJdtObject(this.mDicomObject, dicomAttribute, this.mDicomObject.get_ge(dicomAttribute.getGroup(), dicomAttribute.getElement(), i2));
            if (object == null) {
                return null;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private Object getSequence(DicomAttribute dicomAttribute) {
        List list = this.getMultiValue(dicomAttribute);
        if (list == null) {
            return null;
        }
        ArrayList<DicomDataModel> arrayList = new ArrayList<DicomDataModel>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new DicomDataModel((DicomObject)iterator.next()));
        }
        return arrayList;
    }

    private static int findGroupElement(List list, int n2, int n3, int n4) {
        for (int i2 = n2; i2 < list.size(); ++i2) {
            DicomAttribute dicomAttribute = (DicomAttribute)list.get(i2);
            if (dicomAttribute.getGroup() == n3 && dicomAttribute.getElement() == n4) {
                return i2;
            }
            if (dicomAttribute.getGroup() > n3) {
                return -1;
            }
            if (dicomAttribute.getGroup() != n3 || dicomAttribute.getElement() <= n4) continue;
            return -1;
        }
        return -1;
    }

    private static Date getDate(DDate dDate) throws ParseException {
        Date date = DateUtilities.getDate(dDate.toDICOMString());
        if (date == null) {
            throw new ParseException("Cannot parse " + dDate + " into a java date.", 0);
        }
        return date;
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, DicomException {
        Object object;
        File file = new File("/home/at/Desktop/hope/DICOM/PA000001/ST000001/SE000001/IM000002");
        DicomObject dicomObject = new DicomObject();
        dicomObject.read((InputStream)new FileInputStream(file));
        dicomObject.dumpVRs((OutputStream)System.out);
        DicomDataModel dicomDataModel = new DicomDataModel(dicomObject);
        List list = (List)dicomDataModel.getProperty(DicomAttribute.RequestAttributesSequence);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (DicomDataModel)object2.next();
            ((DicomDataModel)object).getDicomObject().dumpVRs((OutputStream)System.out);
        }
        dicomObject.dumpVRs((OutputStream)System.out);
        System.out.println("grr : " + dicomDataModel.getProperty(DicomAttribute.StudyDate).getClass());
        dicomDataModel.getProperties();
        object2 = new ArrayList();
        object2.add("Item1");
        object2.add("Item2");
        object2.add("item3");
        dicomDataModel.setProperty(DicomAttribute.AccessionNumber, object2);
        object2 = (List)dicomDataModel.getProperty(DicomAttribute.AccessionNumber);
        System.out.println("" + object2);
        object = new ArrayList();
        for (int i2 = 0; i2 < 5; ++i2) {
            object.add(list.get(0));
        }
        dicomDataModel.setProperty(DicomAttribute.RequestAttributesSequence, new ArrayList());
        dicomDataModel.setProperty(DicomAttribute.RequestAttributesSequence, object);
        ((DicomDataModel)list.get(0)).setProperty(DicomAttribute.RequestedProcedureID, "sdf");
        list = (List)dicomDataModel.getProperty(DicomAttribute.RequestAttributesSequence);
        System.out.println();
        System.out.println();
        System.out.println();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DicomDataModel dicomDataModel2 = (DicomDataModel)iterator.next();
            dicomDataModel2.getDicomObject().dumpVRs((OutputStream)System.out);
        }
    }
}

