/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.generated.impl.runtime;

import XmlSchema.generated.impl.runtime.GrammarInfo;
import XmlSchema.generated.impl.runtime.SAXUnmarshallerHandler;
import XmlSchema.generated.impl.runtime.UnmarshallerImpl;
import XmlSchema.generated.impl.runtime.UnmarshallingContext;
import XmlSchema.generated.impl.runtime.UnmarshallingEventHandler;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.Tracer;
import com.sun.xml.bind.util.AttributesImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private boolean isUnmarshalInProgress = true;
    private boolean[] collectText = new boolean[16];
    private int collectTextTop = 0;
    private final GrammarInfo grammarInfo;
    private Object result;
    private UnmarshallingEventHandler[] handlers = new UnmarshallingEventHandler[16];
    private int[] mementos = new int[16];
    private int handlerLen = 0;
    private StringBuffer buffer = new StringBuffer();
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private int idxStackTop = 0;
    private final Stack attStack = new Stack();
    private Runnable[] patchers = null;
    private int patchersLen = 0;
    private Hashtable idmap = null;
    private Locator locator;
    private final UnmarshallerImpl parent;
    private boolean aborted = false;
    private Tracer tracer;

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl unmarshallerImpl, GrammarInfo grammarInfo) {
        this.parent = unmarshallerImpl;
        this.grammarInfo = grammarInfo;
        this.startPrefixMapping("", "");
    }

    public GrammarInfo getGrammarInfo() {
        return this.grammarInfo;
    }

    private final boolean shouldCollectText() {
        return this.collectText[this.collectTextTop];
    }

    public void startDocument() throws SAXException {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.collectTextTop = 0;
        this.attStack.clear();
    }

    public void endDocument() throws SAXException {
        this.runPatchers();
        this.isUnmarshalInProgress = false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        string = string.intern();
        string2 = string2.intern();
        string3 = string3.intern();
        if (this.result == null) {
            UnmarshallingEventHandler unmarshallingEventHandler = this.grammarInfo.createUnmarshaller(string, string2, this);
            if (unmarshallingEventHandler == null) {
                throw new SAXParseException(Messages.format((String)"SAXUnmarshallerHandlerImpl.UnexpectedRootElement2", (Object)string, (Object)string2, (Object)this.computeExpectedRootElements()), this.getLocator());
            }
            this.result = unmarshallingEventHandler.owner();
            this.pushContentHandler(unmarshallingEventHandler, 0);
        }
        this.processText(true);
        this.getCurrentHandler().enterElement(string, string2, string3, attributes);
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        string = string.intern();
        string2 = string2.intern();
        string3 = string3.intern();
        this.processText(false);
        this.getCurrentHandler().leaveElement(string, string2, string3);
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    public void pushContentHandler(UnmarshallingEventHandler unmarshallingEventHandler, int n2) {
        if (this.handlerLen == this.handlers.length) {
            UnmarshallingEventHandler[] unmarshallingEventHandlerArray = new UnmarshallingEventHandler[this.handlerLen * 2];
            int[] nArray = new int[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, unmarshallingEventHandlerArray, 0, this.handlerLen);
            System.arraycopy(this.mementos, 0, nArray, 0, this.handlerLen);
            this.handlers = unmarshallingEventHandlerArray;
            this.mementos = nArray;
        }
        this.handlers[this.handlerLen] = unmarshallingEventHandler;
        this.mementos[this.handlerLen] = n2;
        ++this.handlerLen;
    }

    public void popContentHandler() throws SAXException {
        --this.handlerLen;
        this.handlers[this.handlerLen] = null;
        this.getCurrentHandler().leaveChild(this.mementos[this.handlerLen]);
    }

    public UnmarshallingEventHandler getCurrentHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    protected void consumeText(String string, boolean bl2) throws SAXException {
        if (bl2 && string.trim().length() == 0) {
            return;
        }
        this.getCurrentHandler().text(string);
    }

    private void processText(boolean bl2) throws SAXException {
        if (this.shouldCollectText()) {
            this.consumeText(this.buffer.toString(), bl2);
        }
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuffer();
        }
    }

    public final void characters(char[] cArray, int n2, int n3) {
        if (this.shouldCollectText()) {
            this.buffer.append(cArray, n2, n3);
        }
    }

    public final void ignorableWhitespace(char[] cArray, int n2, int n3) {
        this.characters(cArray, n2, n3);
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.nsBind.length == this.nsLen) {
            String[] stringArray = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, stringArray, 0, this.nsLen);
            this.nsBind = stringArray;
        }
        this.nsBind[this.nsLen++] = string;
        this.nsBind[this.nsLen++] = string2;
    }

    public void endPrefixMapping(String string) {
        this.nsLen -= 2;
    }

    public String resolveNamespacePrefix(String string) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i2 = this.idxStack[this.idxStackTop] - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.nsBind[i2])) continue;
            return this.nsBind[i2 + 1];
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(string)).iterator();
    }

    private List getAllPrefixesInList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            arrayList.add("xml");
            return arrayList;
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            arrayList.add("xmlns");
            return arrayList;
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = this.nsLen - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.nsBind[i2 + 1]) || !this.getNamespaceURI(this.nsBind[i2]).equals(this.nsBind[i2 + 1])) continue;
            arrayList.add(this.nsBind[i2]);
        }
        return arrayList;
    }

    public String getPrefix(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i2 = this.idxStack[this.idxStackTop] - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.nsBind[i2 + 1]) || !this.getNamespaceURI(this.nsBind[i2]).equals(this.nsBind[i2 + 1])) continue;
            return this.nsBind[i2];
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.resolveNamespacePrefix(string);
    }

    public void pushAttributes(Attributes attributes, boolean bl2) {
        Object object;
        int n2;
        AttributesImpl attributesImpl = new AttributesImpl();
        for (n2 = 0; n2 < attributes.getLength(); ++n2) {
            attributesImpl.addAttribute(attributes.getURI(n2).intern(), attributes.getLocalName(n2).intern(), attributes.getQName(n2).intern(), attributes.getType(n2), attributes.getValue(n2));
        }
        n2 = attributesImpl.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (n2 != -1 && (((String)(object = attributesImpl.getValue(n2).trim())).equals("false") || ((String)object).equals("0"))) {
            attributesImpl.removeAttribute(n2);
        }
        this.attStack.push(attributesImpl);
        if (++this.idxStackTop == this.idxStack.length) {
            object = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, object, 0, this.idxStack.length);
            this.idxStack = (int[])object;
        }
        this.idxStack[this.idxStackTop] = this.nsLen;
        if (++this.collectTextTop == this.collectText.length) {
            object = new boolean[this.collectText.length * 2];
            System.arraycopy(this.collectText, 0, object, 0, this.collectText.length);
            this.collectText = (boolean[])object;
        }
        this.collectText[this.collectTextTop] = bl2;
    }

    public void popAttributes() {
        this.attStack.pop();
        --this.idxStackTop;
        --this.collectTextTop;
    }

    public Attributes getUnconsumedAttributes() {
        return (Attributes)this.attStack.peek();
    }

    public int getAttribute(String string, String string2) {
        if (this.attStack.isEmpty()) {
            return -1;
        }
        AttributesImpl attributesImpl = (AttributesImpl)this.attStack.peek();
        return attributesImpl.getIndexFast(string, string2);
    }

    public void consumeAttribute(int n2) throws SAXException {
        AttributesImpl attributesImpl = (AttributesImpl)this.attStack.peek();
        String string = attributesImpl.getURI(n2);
        String string2 = attributesImpl.getLocalName(n2);
        String string3 = attributesImpl.getQName(n2);
        String string4 = attributesImpl.getValue(n2);
        attributesImpl.removeAttribute(n2);
        this.getCurrentHandler().enterAttribute(string, string2, string3);
        this.consumeText(string4, false);
        this.getCurrentHandler().leaveAttribute(string, string2, string3);
    }

    public String eatAttribute(int n2) throws SAXException {
        AttributesImpl attributesImpl = (AttributesImpl)this.attStack.peek();
        String string = attributesImpl.getValue(n2);
        attributesImpl.removeAttribute(n2);
        return string;
    }

    public void addPatcher(Runnable runnable) {
        if (this.patchers == null) {
            this.patchers = new Runnable[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Runnable[] runnableArray = new Runnable[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, runnableArray, 0, this.patchersLen);
            this.patchers = runnableArray;
        }
        this.patchers[this.patchersLen++] = runnable;
    }

    private void runPatchers() {
        if (this.patchers != null) {
            for (int i2 = 0; i2 < this.patchersLen; ++i2) {
                this.patchers[i2].run();
            }
        }
    }

    public String addToIdTable(String string) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(string, this.getCurrentHandler().owner());
        return string;
    }

    public Object getObjectFromId(String string) {
        if (this.idmap == null) {
            return null;
        }
        return this.idmap.get(string);
    }

    public void skippedEntity(String string) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void handleEvent(ValidationEvent validationEvent, boolean bl2) throws SAXException {
        ValidationEventHandler validationEventHandler;
        try {
            validationEventHandler = this.parent.getEventHandler();
        }
        catch (JAXBException jAXBException) {
            throw new InternalError();
        }
        boolean bl3 = validationEventHandler.handleEvent(validationEvent);
        if (!bl3) {
            this.aborted = true;
        }
        if (!bl2 || !bl3) {
            throw new SAXException((Exception)new UnmarshalException(validationEvent.getMessage(), validationEvent.getLinkedException()));
        }
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public boolean isNotation(String string) {
        return true;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer.Standard();
        }
        return this.tracer;
    }

    private String computeExpectedRootElements() {
        String string = "";
        String[] stringArray = this.grammarInfo.getProbePoints();
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            if (!this.grammarInfo.recognize(stringArray[i2], stringArray[i2 + 1])) continue;
            if (string.length() != 0) {
                string = string + ',';
            }
            string = string + "<{" + stringArray[i2] + "}" + stringArray[i2 + 1] + ">";
        }
        return string;
    }
}

