/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.ViewerLayoutProtocol;

import java.util.HashMap;
import java.util.Map;

public class InitialCursorLocation {
    private static Map mNameLookup = new HashMap();
    private static Map mLabelLookup = new HashMap();
    public static InitialCursorLocation BEGINNING = new InitialCursorLocation("beginning", "Beginning of series");
    public static InitialCursorLocation MIDDLE = new InitialCursorLocation("middle", "Middle of series");
    public static InitialCursorLocation END = new InitialCursorLocation("end", "End of series");
    private final String mName;
    private final String mLabel;

    private InitialCursorLocation(String string, String string2) {
        this.mName = string;
        this.mLabel = string2;
        mNameLookup.put(this.mName, this);
        mLabelLookup.put(this.mLabel, this);
    }

    public String toString() {
        return this.mLabel;
    }

    public String getName() {
        return this.mName;
    }

    public String getUiString() {
        return this.mLabel;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public static InitialCursorLocation getInstance(String string) {
        InitialCursorLocation initialCursorLocation = (InitialCursorLocation)mNameLookup.get(string);
        if (initialCursorLocation == null) {
            throw new IllegalArgumentException("invalid cursor location: " + string);
        }
        return initialCursorLocation;
    }

    public static InitialCursorLocation getInstanceByLabel(String string) {
        InitialCursorLocation initialCursorLocation = (InitialCursorLocation)mLabelLookup.get(string);
        if (initialCursorLocation == null) {
            throw new IllegalArgumentException("invalid cursor location label: " + string);
        }
        return initialCursorLocation;
    }

    public static String[] getAllUiStrings() {
        return new String[]{InitialCursorLocation.BEGINNING.mLabel, InitialCursorLocation.MIDDLE.mLabel, InitialCursorLocation.END.mLabel};
    }

    public static String[] getAllLabels() {
        return InitialCursorLocation.getAllUiStrings();
    }

    public static int getInitialImageIndex(InitialCursorLocation initialCursorLocation, int n2) {
        if (initialCursorLocation == BEGINNING) {
            return 0;
        }
        if (initialCursorLocation == MIDDLE) {
            return (n2 - 1) / 2;
        }
        if (initialCursorLocation == END) {
            return n2 - 1;
        }
        throw new IllegalStateException("Initial cursor location is not set to a valid value");
    }
}

