/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.ViewerLayoutProtocol;

import java.util.HashMap;
import java.util.Map;

public class DragInterpolation {
    private static Map mNameLookup = new HashMap();
    private static Map mLabelLookup = new HashMap();
    public static final DragInterpolation FAST = new DragInterpolation("Fast", "Fast");
    public static final DragInterpolation SLOW = new DragInterpolation("Slow", "Slow");
    private final String mName;
    private final String mLabel;

    private DragInterpolation(String string, String string2) {
        this.mName = string;
        this.mLabel = string2;
        mNameLookup.put(this.mName, this);
        mLabelLookup.put(this.mLabel, this);
    }

    public String toString() {
        return this.mLabel;
    }

    public String getName() {
        return this.mName;
    }

    public String getUiString() {
        return this.mLabel;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public static DragInterpolation getInstance(String string) {
        DragInterpolation dragInterpolation = (DragInterpolation)mNameLookup.get(string);
        if (dragInterpolation == null) {
            throw new IllegalArgumentException("invalid drag interpolation: " + string);
        }
        return dragInterpolation;
    }

    public static DragInterpolation getInstanceByLabel(String string) {
        DragInterpolation dragInterpolation = (DragInterpolation)mLabelLookup.get(string);
        if (dragInterpolation == null) {
            throw new IllegalArgumentException("invalid drag interpolation label: " + string);
        }
        return dragInterpolation;
    }

    public static String[] getAllLabels() {
        return new String[]{DragInterpolation.FAST.mLabel, DragInterpolation.SLOW.mLabel};
    }
}

