/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.ViewerLayoutProtocol;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColourMapMode {
    private static Map mNameLookup = new LinkedHashMap();
    private static Map mLabelLookup = new HashMap();
    public static final ColourMapMode DICOM = new ColourMapMode("Dicom", "From DICOM data");
    public static final ColourMapMode INVERSE_DICOM = new ColourMapMode("InverseDicom", "Inverse of DICOM data");
    public static final ColourMapMode MONOCHROME1 = new ColourMapMode("Monochrome1", "Low pixel values as white");
    public static final ColourMapMode MONOCHROME2 = new ColourMapMode("Monochrome2", "Low pixel values as black");
    private String mName;
    private String mLabel;

    private ColourMapMode(String string, String string2) {
        this.mName = string;
        this.mLabel = string2;
        mNameLookup.put(this.mName, this);
        mLabelLookup.put(this.mLabel, this);
    }

    public String toString() {
        return this.mLabel;
    }

    public String getName() {
        return this.mName;
    }

    public String getUiString() {
        return this.mLabel;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public static ColourMapMode[] getAllModes() {
        return mNameLookup.values().toArray(new ColourMapMode[mNameLookup.size()]);
    }

    public static ColourMapMode getInstance(String string) {
        ColourMapMode colourMapMode = (ColourMapMode)mNameLookup.get(string);
        if (colourMapMode == null) {
            throw new IllegalArgumentException("invalid ColourMapMode name: " + string);
        }
        return colourMapMode;
    }

    public static ColourMapMode getInstanceByLabel(String string) {
        ColourMapMode colourMapMode = (ColourMapMode)mLabelLookup.get(string);
        if (colourMapMode == null) {
            throw new IllegalArgumentException("invalid ColourMapMode label: " + string);
        }
        return colourMapMode;
    }

    public static String[] getAllLabels() {
        return new String[]{ColourMapMode.MONOCHROME1.mLabel, ColourMapMode.MONOCHROME2.mLabel, ColourMapMode.DICOM.mLabel, ColourMapMode.INVERSE_DICOM.mLabel};
    }
}

