/*
 * Decompiled with CFR 0.152.
 */
package XmlSchema.MatchExpression;

import DataModels.SearchFramework.Clause;
import DataModels.SearchFramework.Match;
import DataModels.SearchFramework.Operator;
import DataModels.SearchFramework.Term;
import MatchExpressionXml.ObjectFactory;
import MatchExpressionXml.XmlClauseType;
import MatchExpressionXml.XmlMatchExpression;
import MatchExpressionXml.XmlMatchType;
import MatchExpressionXml.XmlTermType;
import XmlSchema.MatchExpression.NamedMatch;
import java.util.Iterator;
import javax.xml.bind.JAXBException;

public class MatchExpressionConvertor {
    static String mId = "$Id: MatchExpressionConvertor.java,v 1.6 2004/10/21 04:36:11 hormoz Exp $";

    public static NamedMatch createNamedMatch(XmlMatchType xmlMatchType) {
        NamedMatch namedMatch = new NamedMatch(xmlMatchType.getName());
        Iterator iterator = xmlMatchType.getClause().iterator();
        while (iterator.hasNext()) {
            XmlClauseType xmlClauseType = (XmlClauseType)iterator.next();
            namedMatch.addClause(MatchExpressionConvertor.createClause(xmlClauseType));
        }
        return namedMatch;
    }

    public static Clause createClause(XmlClauseType xmlClauseType) {
        Clause clause = new Clause();
        Iterator iterator = xmlClauseType.getTerm().iterator();
        while (iterator.hasNext()) {
            XmlTermType xmlTermType = (XmlTermType)iterator.next();
            clause.addTerm(MatchExpressionConvertor.createTerm(xmlTermType));
        }
        return clause;
    }

    public static Term createTerm(XmlTermType xmlTermType) {
        Operator operator = Operator.fromString(xmlTermType.getOperator());
        return new Term(xmlTermType.getAttribute(), operator, xmlTermType.getValue());
    }

    public static XmlMatchExpression createXmlMatchExpression(NamedMatch namedMatch) throws JAXBException {
        XmlMatchExpression xmlMatchExpression = new ObjectFactory().createXmlMatchExpression();
        MatchExpressionConvertor.copyMatchData(xmlMatchExpression, namedMatch);
        return xmlMatchExpression;
    }

    public static XmlMatchType createXmlMatch(NamedMatch namedMatch) throws JAXBException {
        XmlMatchType xmlMatchType = new ObjectFactory().createXmlMatchType();
        MatchExpressionConvertor.copyMatchData(xmlMatchType, namedMatch);
        return xmlMatchType;
    }

    public static XmlMatchExpression createXmlMatchExpression(Match match) throws JAXBException {
        return MatchExpressionConvertor.createXmlMatchExpression(new NamedMatch("Created by MatchExpressionConvertor", match));
    }

    public static XmlMatchType createXmlMatch(Match match) throws JAXBException {
        return MatchExpressionConvertor.createXmlMatch(new NamedMatch("Created by MatchExpressionConvertor", match));
    }

    private static void copyMatchData(XmlMatchType xmlMatchType, NamedMatch namedMatch) throws JAXBException {
        xmlMatchType.setName(namedMatch.getName());
        Iterator iterator = namedMatch.clauseIterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            xmlMatchType.getClause().add(MatchExpressionConvertor.createXmlClause(clause));
        }
    }

    public static XmlClauseType createXmlClause(Clause clause) throws JAXBException {
        XmlClauseType xmlClauseType = new ObjectFactory().createXmlClauseType();
        Iterator iterator = clause.termIterator();
        while (iterator.hasNext()) {
            Term term = (Term)iterator.next();
            xmlClauseType.getTerm().add(MatchExpressionConvertor.createXmlTerm(term));
        }
        return xmlClauseType;
    }

    public static XmlTermType createXmlTerm(Term term) throws JAXBException {
        XmlTermType xmlTermType = new ObjectFactory().createXmlTermType();
        xmlTermType.setAttribute(term.getAttribute());
        xmlTermType.setOperator(term.getOperator().toString());
        xmlTermType.setValue(term.getValue());
        return xmlTermType;
    }
}

