/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.ActiveImageSet;
import J2cProtocol.Association;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.J2cInconsistentDataException;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.SeriesHeader;
import RuntimeTool.Debug;
import WaveletClientLibrary.DataCacheContainer;
import WaveletClientLibrary.DataCacheException;
import WaveletClientLibrary.PrefixLog;
import WaveletClientLibrary.ProxyClient;
import WaveletClientLibrary.WaveletClient;
import WaveletClientLibrary.WaveletClientListener;
import WaveletClientLibrary.WaveletConnectionParameters;
import java.util.ArrayList;
import java.util.List;

public class WaveletClientManager
implements Runnable {
    private static final int MAX_SERIES_HEADER_WAIT_TIME = 600000;
    private static final long IMAGE_UPDATE_POLL_INTERVAL = 1000L;
    private volatile boolean mIsOpen = true;
    private SeriesHeader mSeriesHeader;
    private DataCacheContainer[] mDataCaches = null;
    private WaveletClientListener mWaveletClientListener;
    private final String mSeriesUid;
    private final WaveletConnectionParameters mConnectionParameters;
    private ProxyClient mProxyClient;
    private WaveletClient mWaveletClient;
    private DataCacheContainer mFirstDataCache = null;
    private volatile double mDefaultCompressionFraction = 1.0;
    private volatile ActiveImageSet mActiveImages = new ActiveImageSet();
    private int mReferenceCounter = 0;
    private Object mLockForReferenceCounter = new Object();
    private PrefixLog mPrefixLog;
    private J2cProtocolException mInitialConnectionException = null;
    private ErrorAccumulator mErrorAccumulator = new ErrorAccumulator(3, 20000L);
    private volatile int mPauseCounter = 0;
    private volatile boolean mNeedConnection = true;

    public WaveletClientManager(Debug debug, WaveletConnectionParameters waveletConnectionParameters, String string, WaveletClientListener waveletClientListener) {
        if (waveletClientListener == null) {
            throw new IllegalArgumentException("waveletClientListener should not be null");
        }
        this.mSeriesUid = string;
        this.mPrefixLog = new PrefixLog(debug, this.mSeriesUid + ": ");
        this.mWaveletClientListener = waveletClientListener;
        this.mConnectionParameters = waveletConnectionParameters;
    }

    WaveletClientListener getWaveletClientListener() {
        return this.mWaveletClientListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setSeriesHeader(SeriesHeader seriesHeader) throws J2cProtocolException {
        try {
            this.validateSeriesHeader(seriesHeader);
            this.restorePauseState();
            this.mSeriesHeader = seriesHeader;
        }
        finally {
            this.notifyAll();
        }
    }

    private void validateSeriesHeader(SeriesHeader seriesHeader) throws J2cProtocolException {
        if (this.mSeriesHeader == null) {
            return;
        }
        if (this.mSeriesHeader.getNumberOfImages() != seriesHeader.getNumberOfImages()) {
            throw new J2cInconsistentDataException("Number of images has changed from " + this.mSeriesHeader.getNumberOfImages() + " to " + seriesHeader.getNumberOfImages());
        }
        int n2 = this.mSeriesHeader.getNumberOfImages();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2;
            String string3 = this.mSeriesHeader.getImageSopInstanceUid(i2);
            if (!string3.equals(string2 = seriesHeader.getImageSopInstanceUid(i2))) {
                throw new J2cInconsistentDataException("SOP instance UID at index " + i2 + " changed from " + string3 + " to " + string2);
            }
            int n3 = this.mSeriesHeader.getImageColumns(i2);
            int n4 = this.mSeriesHeader.getImageRows(i2);
            int n5 = seriesHeader.getImageColumns(i2);
            int n6 = seriesHeader.getImageRows(i2);
            if (n3 != n5 || n4 != n6) {
                throw new J2cInconsistentDataException("Size of image " + i2 + " changed from " + n3 + "x" + n4 + " to " + n5 + "x" + n6);
            }
            String string4 = this.mSeriesHeader.getImagePhotometricInterpretation(i2);
            if (string4.equals(string = seriesHeader.getImagePhotometricInterpretation(i2))) continue;
            throw new J2cInconsistentDataException("Photometric interpretation of image " + i2 + " changed from " + string4 + " to " + string);
        }
    }

    public synchronized SeriesHeader getSeriesHeader() throws J2cProtocolException {
        long l2 = System.currentTimeMillis();
        while (this.mSeriesHeader == null) {
            try {
                if (this.mInitialConnectionException != null) {
                    throw this.mInitialConnectionException;
                }
                long l3 = System.currentTimeMillis() - l2;
                if (l3 >= 600000L) {
                    throw new J2cProtocolException("Wavelet client timeout after " + (double)l3 / 1000.0 + " seconds " + "(connection parameters: " + this.mConnectionParameters + ")");
                }
                this.wait(600000L - l3);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.mSeriesHeader;
    }

    public double getDefaultCompressionFraction() {
        return this.mDefaultCompressionFraction;
    }

    public int getNumberOfDataCaches() {
        return this.mDataCaches == null ? 0 : this.mDataCaches.length;
    }

    void createDataCaches(int[] nArray) throws J2cProtocolException, DataCacheException {
        if (this.mDataCaches != null) {
            if (this.mDataCaches.length == nArray.length) {
                return;
            }
            throw new J2cInconsistentDataException("Number of images has changed on the server from " + this.mDataCaches.length + " to " + nArray.length);
        }
        DataCacheContainer[] dataCacheContainerArray = new DataCacheContainer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dataCacheContainerArray[i2] = new DataCacheContainer(this, i2, nArray[i2]);
        }
        this.mDataCaches = dataCacheContainerArray;
    }

    public DataCacheContainer[] getDataCaches() {
        return this.mDataCaches;
    }

    public DataCacheContainer getDataCache(int n2) throws J2cProtocolException {
        if (this.mDataCaches == null) {
            throw new J2cProtocolException("Data cache not set up - cannot send image data until series reply been sent");
        }
        if (n2 < 0 || n2 >= this.mDataCaches.length) {
            throw new J2cProtocolException("Image index " + n2 + " out of range: " + "mDataCaches.length = " + this.mDataCaches.length);
        }
        return this.mDataCaches[n2];
    }

    DataCacheContainer getDataCacheNoThrow(int n2) {
        return this.mDataCaches[n2];
    }

    public void setDefaultCompressionFraction(double d2) {
        this.requireConnection(true);
        this.mDefaultCompressionFraction = d2;
        if (this.mDataCaches != null) {
            for (int i2 = 0; i2 < this.mDataCaches.length; ++i2) {
                if (this.mDataCaches[i2] == null) continue;
                this.mDataCaches[i2].defaultCompressionChanged(d2);
            }
        }
        if (this.mWaveletClient != null) {
            this.mWaveletClient.setDefaultCompressionFraction(d2);
        }
    }

    private synchronized void requireConnection(boolean bl2) {
        this.mNeedConnection = bl2;
        if (bl2) {
            this.notifyAll();
        }
    }

    void closeCaches() {
        if (this.mDataCaches != null) {
            for (int i2 = 0; i2 < this.mDataCaches.length; ++i2) {
                try {
                    this.mDataCaches[i2].close();
                    continue;
                }
                catch (DataCacheException dataCacheException) {
                    this.mPrefixLog.error("Error closing data cache [" + i2 + "] (" + this.mDataCaches[i2].toString() + "): ", dataCacheException);
                }
            }
        }
    }

    void setFirstDataCache(DataCacheContainer dataCacheContainer) {
        this.mFirstDataCache = dataCacheContainer;
    }

    DataCacheContainer getFirstDataCache() {
        return this.mFirstDataCache;
    }

    public void setActiveImages(ActiveImageSet activeImageSet) {
        ActiveImageSet activeImageSet2 = this.getActiveImages();
        if (activeImageSet2 != null && activeImageSet2.imagesMatch(activeImageSet)) {
            return;
        }
        this.mActiveImages = activeImageSet;
        if (this.mWaveletClient != null) {
            this.mWaveletClient.setActiveImages();
        }
    }

    ActiveImageSet getActiveImages() {
        return this.mActiveImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementReferenceCount() {
        Object object = this.mLockForReferenceCounter;
        synchronized (object) {
            ++this.mReferenceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementReferenceCount() {
        Object object = this.mLockForReferenceCounter;
        synchronized (object) {
            if (--this.mReferenceCounter <= 0) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCounter() {
        Object object = this.mLockForReferenceCounter;
        synchronized (object) {
            return this.mReferenceCounter;
        }
    }

    void requestUpdateImage(int n2) {
        if (this.isClosed()) {
            return;
        }
        this.mWaveletClientListener.considerImageUpdate(this.getDataCacheNoThrow(n2));
    }

    private void close() {
        if (this.isClosed()) {
            return;
        }
        this.mIsOpen = false;
        this.mPrefixLog.trace("Closing data caches");
        this.closeCaches();
        this.closeWaveletClient();
    }

    public boolean isClosed() {
        return !this.mIsOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.mPrefixLog.trace("Client protocol version " + Association.getProtocolVersionString());
        this.incrementReferenceCount();
        this.mPrefixLog.trace("Starting WaveletClientManager.run()");
        boolean bl2 = true;
        while (this.getReferenceCounter() > 1) {
            if (bl2 && this.mNeedConnection) {
                bl2 = this.connectAndService();
            }
            WaveletClientManager waveletClientManager = this;
            synchronized (waveletClientManager) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.mWaveletClientListener.updateImages();
        }
        this.decrementReferenceCount();
        this.mPrefixLog.trace("Ending WaveletClientManager.run()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectAndService() {
        Throwable throwable = null;
        try {
            this.connectWaveletClient();
            this.mWaveletClient.serviceAssociation();
            DisconnectMessage disconnectMessage = this.getDisconnectMessage();
            if (disconnectMessage != null && disconnectMessage.getStatus() != 0) {
                throwable = new J2cProtocolException(disconnectMessage.getDescription());
            } else {
                this.requireConnection(false);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            this.closeWaveletClient();
        }
        if (throwable != null && this.mSeriesHeader == null) {
            this.setInitialConnectionException(throwable);
        }
        if (throwable != null && this.mNeedConnection) {
            this.mPrefixLog.error("Exception in wavelet connection: " + throwable.getMessage(), throwable);
            this.mErrorAccumulator.addError(throwable);
            if (this.mErrorAccumulator.reachedLimit() || throwable instanceof J2cInconsistentDataException) {
                this.mWaveletClientListener.reportError(this.mErrorAccumulator.getLastError());
                return false;
            }
        } else {
            this.mErrorAccumulator.reset();
        }
        return true;
    }

    private void connectWaveletClient() throws J2cProtocolException {
        this.mPrefixLog.trace("Making wavelet connection: " + this.mConnectionParameters);
        this.mProxyClient = new ProxyClient(this.mConnectionParameters);
        this.mProxyClient.connect();
        this.mConnectionParameters.setUseProxy(this.mProxyClient.getConnectionParameters().useProxy());
        this.mWaveletClient = new WaveletClient(this, this.mProxyClient, this.mSeriesUid);
        this.mWaveletClient.setDebug(this.mPrefixLog);
        this.mWaveletClient.setDefaultCompressionFraction(this.mDefaultCompressionFraction);
        this.mWaveletClient.setActiveImages();
    }

    private void restorePauseState() {
        block3: {
            block2: {
                if (this.mPauseCounter <= 0) break block2;
                for (int i2 = 0; i2 < this.mPauseCounter; ++i2) {
                    this.mWaveletClient.pause();
                }
                break block3;
            }
            if (this.mPauseCounter >= 0) break block3;
            for (int i3 = 0; i3 < -this.mPauseCounter; ++i3) {
                this.mWaveletClient.resume();
            }
        }
    }

    private void closeWaveletClient() {
        this.mPrefixLog.trace("Closing wavelet connection: " + this.mConnectionParameters);
        if (this.mWaveletClient != null) {
            this.mWaveletClient.close();
        }
        if (this.mProxyClient != null) {
            this.mProxyClient.close();
        }
        this.mWaveletClient = null;
        this.mProxyClient = null;
    }

    private synchronized void setInitialConnectionException(Throwable throwable) {
        this.mInitialConnectionException = throwable instanceof J2cProtocolException ? (J2cProtocolException)throwable : new J2cProtocolException("Exception thrown in wavelet thread", throwable);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        WaveletClientManager waveletClientManager = this;
        synchronized (waveletClientManager) {
            this.notifyAll();
        }
        if (this.mWaveletClient != null) {
            this.mWaveletClient.wakeup();
        }
    }

    public void resumeConnection() {
        --this.mPauseCounter;
        if (this.mWaveletClient == null) {
            return;
        }
        this.mWaveletClient.resume();
    }

    public void pauseConnection() {
        ++this.mPauseCounter;
        if (this.mWaveletClient == null) {
            return;
        }
        this.mWaveletClient.pause();
    }

    public DisconnectMessage getDisconnectMessage() {
        if (this.mWaveletClient == null) {
            return null;
        }
        return this.mWaveletClient.getDisconnectMessage();
    }

    public void requestFullImage(int n2) {
        try {
            this.getDataCacheNoThrow(n2).requestFullImage();
        }
        catch (DataCacheException dataCacheException) {
            this.mPrefixLog.error("Error requesting full image: " + dataCacheException.toString(), dataCacheException);
        }
        if (this.mWaveletClient != null) {
            this.mWaveletClient.wakeup();
        } else {
            this.requireConnection(true);
        }
    }

    public void requestDisconnect(int n2, String string) {
        this.requireConnection(false);
        if (this.mWaveletClient == null) {
            return;
        }
        this.mWaveletClient.setDisconnectMessage(new DisconnectMessage(n2, string));
    }

    public WaveletConnectionParameters getConnectionParameters() {
        return this.mConnectionParameters;
    }

    public void allRequestedDataReceived() {
        this.requireConnection(false);
    }

    public static class ErrorAccumulator {
        private final int mErrorThreshold;
        private final long mMinimumTime;
        private List mErrorList = new ArrayList();
        private long mStartTime;

        public ErrorAccumulator(int n2, long l2) {
            this.mErrorThreshold = n2;
            this.mMinimumTime = l2;
        }

        public synchronized void reset() {
            this.mErrorList.clear();
        }

        public synchronized void addError(Throwable throwable) {
            this.mErrorList.add(throwable);
            if (this.mErrorList.size() == 1) {
                this.mStartTime = System.currentTimeMillis();
            }
        }

        public synchronized boolean reachedLimit() {
            return this.mErrorList.size() >= this.mErrorThreshold && System.currentTimeMillis() - this.mStartTime > this.mMinimumTime;
        }

        public synchronized Throwable getLastError() {
            return (Throwable)this.mErrorList.get(this.mErrorList.size() - 1);
        }
    }
}

