/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.ActiveImageRequestMessage;
import J2cProtocol.DisconnectMessage;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.Message;
import J2cProtocol.RoiRequestMessage;
import J2cProtocol.SeriesHeader;
import J2cProtocol.SeriesSettingsMessage;
import J2cProtocol.State;
import StringUtilities.PrintfFormat;
import WaveletClientLibrary.AbstractWaveletClient;
import WaveletClientLibrary.DataCacheContainer;
import WaveletClientLibrary.DataCacheException;
import WaveletClientLibrary.ProxyClient;
import WaveletClientLibrary.WaveletClientManager;

public class WaveletClient
extends AbstractWaveletClient {
    private static final double MIN_MEGA_BYTES_READ_FOR_LOGGING = 0.1;
    private static final long MIN_TIME_FOR_LOGGING = 500L;
    private final WaveletClientManager mManager;
    private volatile boolean mActiveImagesChanged = false;
    private SeriesSettingsMessage mSeriesSettingsMessage = null;
    private Object mLockForSeriesSettings = new Object();

    public WaveletClient(WaveletClientManager waveletClientManager, ProxyClient proxyClient, String string) {
        super(proxyClient, string);
        this.mManager = waveletClientManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCompressionFraction(double d2) {
        Object object = this.mLockForSeriesSettings;
        synchronized (object) {
            if (this.mSeriesSettingsMessage == null) {
                this.mSeriesSettingsMessage = new SeriesSettingsMessage();
            }
            this.mSeriesSettingsMessage.setDefaultCompressionFraction(d2);
        }
        this.wakeup();
    }

    public void prepareForDataTransfer() {
        this.mManager.getWaveletClientListener().prepareForDataTransfer();
    }

    protected void handleNextIteration() {
        this.mManager.getWaveletClientListener().updateImages();
    }

    protected Message createOutgoingMessage() {
        Message message = null;
        if (this.getState() == State.UNCONNECTED) {
            this.trace("Sending connect request");
            this.advanceState(null);
            message = this.createConnectRequestMessage();
        } else if (this.getState() == State.DATA_EXCHANGE) {
            message = this.getSeriesSettingsMessage();
            if (message == null) {
                message = this.getActiveImageMessage();
            }
            if (message == null) {
                message = this.createRoiRequestMessage();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getSeriesSettingsMessage() {
        Object object = this.mLockForSeriesSettings;
        synchronized (object) {
            if (this.mSeriesSettingsMessage != null) {
                SeriesSettingsMessage seriesSettingsMessage = this.mSeriesSettingsMessage;
                this.mSeriesSettingsMessage = null;
                return seriesSettingsMessage;
            }
        }
        return null;
    }

    private Message createRoiRequestMessage() {
        byte[] byArray = this.getOutputBuffer();
        for (int i2 = 0; i2 < this.mManager.getNumberOfDataCaches(); ++i2) {
            DataCacheContainer dataCacheContainer = this.mManager.getDataCacheNoThrow(i2);
            if (!dataCacheContainer.haveRoiRequest()) continue;
            try {
                int n2 = dataCacheContainer.serializeRoi(byArray, byArray.length);
                return new RoiRequestMessage(byArray, i2, n2);
            }
            catch (DataCacheException dataCacheException) {
                this.error("Caught error - disconnecting: " + dataCacheException.toString(), dataCacheException);
                return new DisconnectMessage(2, dataCacheException.toString());
            }
        }
        return null;
    }

    private Message getActiveImageMessage() {
        ActiveImageRequestMessage activeImageRequestMessage = null;
        if (this.mActiveImagesChanged) {
            this.mActiveImagesChanged = false;
            activeImageRequestMessage = new ActiveImageRequestMessage(this.mManager.getActiveImages());
        }
        return activeImageRequestMessage;
    }

    public void checkForTransferComplete() {
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.mManager.getNumberOfDataCaches(); ++i2) {
            if (this.mManager.getDataCacheNoThrow(i2).isImageComplete()) continue;
            bl2 = false;
        }
        if (bl2) {
            this.mManager.requestDisconnect(0, "All data transferred");
        }
    }

    public void setActiveImages() {
        this.mActiveImagesChanged = true;
        this.wakeup();
    }

    void requestUpdateImage(int n2) {
        this.mManager.requestUpdateImage(n2);
    }

    public DataCacheContainer getDataCache(int n2) throws J2cProtocolException {
        return this.mManager.getDataCache(n2);
    }

    void createDataCaches(int[] nArray) throws J2cProtocolException, DataCacheException {
        this.mManager.createDataCaches(nArray);
    }

    public void setSeriesHeader(SeriesHeader seriesHeader) throws J2cProtocolException {
        this.setPauseState();
        this.mManager.setSeriesHeader(seriesHeader);
    }

    public void allRequestedDataReceived() {
        this.mManager.allRequestedDataReceived();
    }

    protected void logConnectionStats() {
        PrintfFormat printfFormat = new PrintfFormat("%.3f");
        long l2 = this.getConnectionStopWatch().getCumulativeTime();
        long l3 = this.getReadStopWatch().getCumulativeTime();
        long l4 = this.getPauseStopWatch().getCumulativeTime();
        String string = printfFormat.sprintf((double)l2 / 1000.0) + " s";
        String string2 = printfFormat.sprintf((double)l3 / 1000.0) + " s";
        String string3 = printfFormat.sprintf((double)l4 / 1000.0) + " s";
        double d2 = (double)this.getBytesRead() / 1048576.0;
        StringBuffer stringBuffer = new StringBuffer("Connection closed after " + string + ", " + printfFormat.sprintf(d2) + " MB read" + ", paused for " + string3 + ", blocked or reading for " + string2);
        long l5 = l2 - l4;
        long l6 = l3 - l4;
        if (d2 > 0.1 && l5 > 500L) {
            double d3 = d2 / (double)l5 * 1000.0;
            double d4 = 100.0 * (double)l6 / (double)l5;
            stringBuffer.append(". Read throughput = " + printfFormat.sprintf(d3) + " MB/s");
            stringBuffer.append(", percent time reading = " + printfFormat.sprintf(d4) + "%");
        }
        stringBuffer.append(".");
        this.trace(stringBuffer.toString());
    }
}

