/*
 * Decompiled with CFR 0.152.
 */
package WaveletClientLibrary;

import J2cProtocol.Association;
import J2cProtocol.J2cProtocolException;
import J2cProtocol.RegionOfInterest;
import J2cProtocol.RoiCompleteMessage;
import WaveletClientLibrary.DataCacheContainer;
import WaveletClientLibrary.DataCacheException;
import WaveletClientLibrary.WaveletClient;

public class ClientRoiCompleteMessage
extends RoiCompleteMessage {
    public ClientRoiCompleteMessage(byte[] byArray) {
        super(byArray);
    }

    public void process(Association association) throws J2cProtocolException {
        WaveletClient waveletClient = (WaveletClient)association;
        int n2 = this.getImageIndex();
        byte[] byArray = this.getBufferReference();
        DataCacheContainer dataCacheContainer = waveletClient.getDataCache(n2);
        try {
            RegionOfInterest regionOfInterest = new RegionOfInterest(byArray);
            dataCacheContainer.roiComplete(regionOfInterest);
            waveletClient.requestUpdateImage(n2);
        }
        catch (J2cProtocolException j2cProtocolException) {
            waveletClient.setDisconnectMessage(this.createDisconnectMessage(2, j2cProtocolException));
        }
        catch (DataCacheException dataCacheException) {
            waveletClient.error("Caught exception - diconnecting: " + dataCacheException, dataCacheException);
            waveletClient.setDisconnectMessage(this.createDisconnectMessage(2, dataCacheException));
        }
    }
}

