/*
 * Decompiled with CFR 0.152.
 */
package Viewer.DicomPrint.PrinterEditor;

import DataModels.AbstractDataModel;
import DataModels.ModelProperty;
import com.intelerad.datamodels.dicom.DicomAttribute;
import com.intelerad.datamodels.dicom.ImageDisplayParameters;
import com.intelerad.datamodels.validation.CompositeValidator;
import com.intelerad.datamodels.validation.Validator;
import com.intelerad.datamodels.validation.ValueInListValidator;
import com.intelerad.datamodels.validation.ValueInRangeValidator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AttributeEditorModel
extends AbstractDataModel {
    public static final ModelProperty ValidValues = new ModelProperty(class$java$util$List == null ? (class$java$util$List = AttributeEditorModel.class$("java.util.List")) : class$java$util$List, "ValidValues", "List of valid values");
    public static final ModelProperty RangeValidator = new ModelProperty(class$com$intelerad$datamodels$validation$ValueInRangeValidator == null ? (class$com$intelerad$datamodels$validation$ValueInRangeValidator = AttributeEditorModel.class$("com.intelerad.datamodels.validation.ValueInRangeValidator")) : class$com$intelerad$datamodels$validation$ValueInRangeValidator, "RangeValidator", "Range validator");
    public static final ModelProperty Used = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "Used", "Not used");
    public static final ModelProperty NewValue = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = AttributeEditorModel.class$("java.lang.String")) : class$java$lang$String, "NewValue", "New value");
    public static final ModelProperty SelectedListIndex = new ModelProperty(class$java$lang$Integer == null ? (class$java$lang$Integer = AttributeEditorModel.class$("java.lang.Integer")) : class$java$lang$Integer, "SelectedListIndex", "Selected index");
    public static final ModelProperty DefaultValue = new ModelProperty(class$java$lang$Object == null ? (class$java$lang$Object = AttributeEditorModel.class$("java.lang.Object")) : class$java$lang$Object, "DefaultValue", "Default value");
    public static final ModelProperty RangeFirst = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = AttributeEditorModel.class$("java.lang.String")) : class$java$lang$String, "RangeFirst", "First");
    public static final ModelProperty RangeLast = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = AttributeEditorModel.class$("java.lang.String")) : class$java$lang$String, "RangeLast", "Last");
    public static final ModelProperty RangeDefault = new ModelProperty(class$java$lang$String == null ? (class$java$lang$String = AttributeEditorModel.class$("java.lang.String")) : class$java$lang$String, "RangeDefault", "Range default");
    public static final ModelProperty RangeEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "RangeEnabled", "Range enabled");
    public static final ModelProperty OkButtonEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "OkButtonEnabled", "Ok button enabled");
    public static final ModelProperty ValueSelected = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "ValueSelected", "value selected");
    public static final ModelProperty AddButtonEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "AddButtonEnabled", "add button enabled");
    public static final ModelProperty UpdateButtonEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "UpdateButtonEnabled", "update button enabled");
    public static final ModelProperty RangeSubComponentsEnabled = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "RangeSubComponentsEnabled", "range first and last enabled");
    public static final ModelProperty RangeUsed = new ModelProperty(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, "RangeUsed", "Range");
    public static final ModelProperty AllValues = new ModelProperty(class$java$util$List == null ? (class$java$util$List = AttributeEditorModel.class$("java.util.List")) : class$java$util$List, "AllValues", "All valid values");
    private static final List PROPERTIES = Collections.unmodifiableList(Arrays.asList(ValidValues, RangeValidator, Used, NewValue, SelectedListIndex, DefaultValue, RangeFirst, RangeLast, RangeDefault, RangeEnabled, RangeSubComponentsEnabled, OkButtonEnabled, ValueSelected, UpdateButtonEnabled, AddButtonEnabled, RangeUsed, AllValues));
    private List mValidValues = new ArrayList();
    private String mNewValue = "";
    private int mSelectedListIndex = -1;
    private boolean mRangeEnabled = false;
    private boolean mRangeUsed = false;
    private boolean mRangeSubComponentsEnabled;
    private String mRangeFirst = "";
    private String mRangeLast = "";
    private boolean mUsed = true;
    private boolean mOkButtonEnabled = true;
    private boolean mValueSelected = false;
    private boolean mUpdateButtonEnabled = false;
    private boolean mAddButtonEnabled = false;
    private Object mDefaultValue = null;
    private final boolean mRangeAllowed;
    private List mOldAllValues;
    private final ModelProperty mProperty;
    private final boolean mIsRequired;
    public static Class class$java$util$List;
    public static Class class$com$intelerad$datamodels$validation$ValueInRangeValidator;
    public static Class class$java$lang$Boolean;
    public static Class class$java$lang$String;
    public static Class class$java$lang$Integer;
    public static Class class$java$lang$Object;

    public AttributeEditorModel(ModelProperty modelProperty, Object object, Validator validator, boolean bl2, boolean bl3) {
        ValueInRangeValidator valueInRangeValidator;
        this.mIsRequired = bl2;
        this.mRangeAllowed = bl3;
        this.mProperty = modelProperty;
        if (validator == null) {
            this.setUsed(false);
            return;
        }
        ValueInListValidator valueInListValidator = CompositeValidator.getValueInListValidator(validator);
        if (valueInListValidator != null) {
            this.setValidValues(valueInListValidator.getValidValues());
        }
        if ((valueInRangeValidator = CompositeValidator.getValueInRangeValidator(validator)) != null) {
            this.setRangeFirst(valueInRangeValidator.getFirst().toString());
            this.setRangeLast(valueInRangeValidator.getLast().toString());
        }
        this.setRangeUsed(valueInRangeValidator != null);
        this.setDefaultValue(object);
    }

    public Collection getProperties() {
        return PROPERTIES;
    }

    public void addValue() {
        Object object = this.buildObjectFromNewValue();
        if (object == null) {
            return;
        }
        if (!this.mValidValues.contains(object)) {
            this.mValidValues.add(object);
        }
        this.firePropertyChange(ValidValues, null);
        this.allValuesChanged();
        this.setSelectedListIndex(this.mValidValues.indexOf(this.mNewValue));
        this.setNewValue("");
        this.setButtonEnabledStates();
    }

    private Object buildObjectFromNewValue() {
        if (this.mNewValue.length() == 0) {
            return null;
        }
        if (DicomAttribute.ImageDisplayFormat == this.mProperty) {
            return this.convertImageDisplayFormat(this.mNewValue);
        }
        if (this.mProperty.getValueClass() == (class$java$lang$String == null ? (class$java$lang$String = AttributeEditorModel.class$("java.lang.String")) : class$java$lang$String)) {
            return this.mNewValue;
        }
        if (this.mProperty.getValueClass() == (class$java$lang$Integer == null ? (class$java$lang$Integer = AttributeEditorModel.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            try {
                return new Integer(Integer.parseInt(this.mNewValue));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (this.mProperty.getValueClass() == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return this.convertBooleanValue(this.mNewValue);
        }
        throw new UnsupportedOperationException("I don't know how to turn Strings into " + this.mProperty.getValueClass());
    }

    private Object convertImageDisplayFormat(String string) {
        try {
            ImageDisplayParameters imageDisplayParameters = new ImageDisplayParameters(string);
            return imageDisplayParameters.toString();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Object convertBooleanValue(String string) {
        int n2;
        String[] stringArray = new String[]{"true", "yes", "on", "1"};
        String[] stringArray2 = new String[]{"false", "no", "off", "0"};
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equalsIgnoreCase(string)) continue;
            return Boolean.TRUE;
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (!stringArray2[n2].equalsIgnoreCase(string)) continue;
            return Boolean.FALSE;
        }
        return null;
    }

    private void allValuesChanged() {
        List list = this.getAllValues();
        if (((Object)list).equals(this.mOldAllValues)) {
            return;
        }
        this.mOldAllValues = list;
        this.firePropertyChange(AllValues, null);
        this.checkDefaultValue();
        if (!this.isIndexInRange(this.mSelectedListIndex)) {
            this.setSelectedListIndex(this.mValidValues.size() - 1);
        }
    }

    public void updateValue() {
        if (this.mNewValue.length() == 0) {
            return;
        }
        if (!this.removeSelection()) {
            return;
        }
        Object object = this.buildObjectFromNewValue();
        if (object == null) {
            return;
        }
        this.mValidValues.add(this.mSelectedListIndex, object);
        this.firePropertyChange(ValidValues, null);
        this.allValuesChanged();
        this.setNewValue("");
    }

    public void removeValue() {
        if (this.removeSelection()) {
            this.firePropertyChange(ValidValues, null);
            this.allValuesChanged();
            this.setNewValue("");
        }
        this.setButtonEnabledStates();
    }

    public void moveSelection(boolean bl2) {
        int n2 = this.mSelectedListIndex + (bl2 ? -1 : 1);
        if (!this.isIndexInRange(this.mSelectedListIndex) || !this.isIndexInRange(n2)) {
            return;
        }
        Object e2 = this.mValidValues.get(this.mSelectedListIndex);
        this.mValidValues.remove(this.mSelectedListIndex);
        this.mValidValues.add(n2, e2);
        this.firePropertyChange(ValidValues, null);
        this.allValuesChanged();
        this.setSelectedListIndex(n2);
    }

    private boolean isIndexInRange(int n2) {
        return 0 <= n2 && n2 <= this.mValidValues.size() - 1;
    }

    private boolean removeSelection() {
        if (this.isIndexInRange(this.mSelectedListIndex)) {
            if (this.isRequired() && this.mValidValues.size() == 1) {
                return false;
            }
            this.mValidValues.remove(this.mSelectedListIndex);
            return true;
        }
        return false;
    }

    public String getNewValue() {
        return this.mNewValue;
    }

    public int getSelectedListIndex() {
        return this.mSelectedListIndex;
    }

    public List getValidValues() {
        return this.mValidValues;
    }

    public String getRangeFirst() {
        return this.mRangeFirst;
    }

    public String getRangeLast() {
        return this.mRangeLast;
    }

    public void setNewValue(String string) {
        String string2 = this.mNewValue;
        String string3 = this.mNewValue = string == null ? "" : string;
        if (string.equals(string2)) {
            return;
        }
        this.firePropertyChange(NewValue, string2);
        this.setButtonEnabledStates();
    }

    public void setSelectedListIndex(int n2) {
        int n3 = this.mSelectedListIndex;
        this.mSelectedListIndex = n2;
        this.firePropertyChange(SelectedListIndex, new Integer(n3));
        if (this.isIndexInRange(this.mSelectedListIndex)) {
            this.setNewValue(this.mValidValues.get(this.mSelectedListIndex).toString());
        }
        this.setButtonEnabledStates();
    }

    public void setValidValues(List list) {
        this.mValidValues = new ArrayList(list);
        this.firePropertyChange(ValidValues, null);
        this.allValuesChanged();
    }

    public void setRangeFirst(String string) {
        String string2 = this.mRangeFirst;
        this.mRangeFirst = string;
        this.firePropertyChange(RangeFirst, string2);
        this.allValuesChanged();
    }

    public void setRangeLast(String string) {
        String string2 = this.mRangeLast;
        this.mRangeLast = string;
        this.firePropertyChange(RangeLast, string2);
        this.allValuesChanged();
    }

    public boolean isRangeEnabled() {
        return this.mRangeEnabled;
    }

    public void setRangeEnabled(boolean bl2) {
        Boolean bl3 = new Boolean(this.mRangeEnabled);
        this.mRangeEnabled = bl2;
        this.firePropertyChange(RangeEnabled, bl3);
        this.setRangeSubComponentsEnabled();
        this.allValuesChanged();
    }

    public boolean isRangeSubComponentsEnabled() {
        return this.mRangeSubComponentsEnabled;
    }

    private void setRangeSubComponentsEnabled() {
        Boolean bl2 = new Boolean(this.mRangeSubComponentsEnabled);
        this.mRangeSubComponentsEnabled = this.mRangeEnabled && this.mRangeUsed;
        this.firePropertyChange(RangeSubComponentsEnabled, bl2);
    }

    public boolean isRequired() {
        return this.mIsRequired;
    }

    public boolean getUsedFlag() {
        return this.mUsed;
    }

    public void setUsed(boolean bl2) {
        boolean bl3 = this.mUsed;
        this.mUsed = bl2;
        this.firePropertyChange(Used, new Boolean(bl3));
        this.setButtonEnabledStates();
    }

    public void setButtonEnabledStates() {
        this.setAddButtonEnabled(this.mUsed && this.buildObjectFromNewValue() != null);
        this.setOkButtonEnabled(this.mUsed && (this.mRangeEnabled || this.mValidValues.size() > 0 || !this.mUsed));
        this.setValueSelected(this.mUsed && this.isIndexInRange(this.mSelectedListIndex));
        this.setUpdateButtonEnabled(this.mUsed && this.isValueSelected() && this.isAddButtonEnabled());
        this.setRangeEnabled(this.mRangeAllowed && this.mUsed);
    }

    public boolean isAddButtonEnabled() {
        return this.mAddButtonEnabled;
    }

    public boolean isOkButtonEnabled() {
        return this.mOkButtonEnabled;
    }

    public boolean isValueSelected() {
        return this.mValueSelected;
    }

    public boolean isUpdateButtonEnabled() {
        return this.mUpdateButtonEnabled;
    }

    private void setAddButtonEnabled(boolean bl2) {
        boolean bl3 = this.mAddButtonEnabled;
        this.mAddButtonEnabled = bl2;
        this.firePropertyChange(AddButtonEnabled, new Boolean(bl3));
    }

    public void setRangeUsed(boolean bl2) {
        boolean bl3 = this.mRangeUsed;
        this.mRangeUsed = bl2;
        this.firePropertyChange(RangeUsed, new Boolean(bl3));
        this.setButtonEnabledStates();
    }

    public boolean isRangeUsed() {
        return this.mRangeUsed;
    }

    private void setOkButtonEnabled(boolean bl2) {
        boolean bl3 = this.mOkButtonEnabled;
        this.mOkButtonEnabled = bl2;
        this.firePropertyChange(OkButtonEnabled, new Boolean(bl3));
    }

    private void setUpdateButtonEnabled(boolean bl2) {
        boolean bl3 = this.mUpdateButtonEnabled;
        this.mUpdateButtonEnabled = bl2;
        this.firePropertyChange(UpdateButtonEnabled, new Boolean(bl3));
    }

    private void setValueSelected(boolean bl2) {
        boolean bl3 = this.mValueSelected;
        this.mValueSelected = bl2;
        this.firePropertyChange(ValueSelected, new Boolean(bl3));
    }

    public List getAllValues() {
        Validator validator = this.createValidator();
        if (validator == null) {
            return Collections.EMPTY_LIST;
        }
        return validator.getValidValues();
    }

    public Validator createValidator() {
        Object object;
        List<Object> list;
        if (!this.mUsed) {
            return null;
        }
        ValueInListValidator valueInListValidator = null;
        ValueInRangeValidator valueInRangeValidator = null;
        if (!this.mValidValues.isEmpty()) {
            list = this.mValidValues;
            if (this.mProperty.getValueClass() == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributeEditorModel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                list = new ArrayList();
                if (this.mValidValues.contains(Boolean.TRUE)) {
                    list.add(Boolean.TRUE);
                }
                if (this.mValidValues.contains(Boolean.FALSE)) {
                    list.add(Boolean.FALSE);
                }
            }
            valueInListValidator = new ValueInListValidator(list);
        }
        if (this.mRangeEnabled) {
            try {
                list = new Integer(Integer.parseInt(this.mRangeFirst));
                object = new Integer(Integer.parseInt(this.mRangeLast));
                boolean bl2 = this.mProperty.getValueClass() == (class$java$lang$String == null ? (class$java$lang$String = AttributeEditorModel.class$("java.lang.String")) : class$java$lang$String);
                valueInRangeValidator = new ValueInRangeValidator((Integer)((Object)list), (Integer)object, bl2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (valueInListValidator != null && valueInRangeValidator != null) {
            list = Arrays.asList(valueInListValidator, valueInRangeValidator);
            object = new CompositeValidator(list);
            return object;
        }
        if (valueInListValidator != null) {
            return valueInListValidator;
        }
        if (valueInRangeValidator != null) {
            return valueInRangeValidator;
        }
        return null;
    }

    private void checkDefaultValue() {
        List list = this.getAllValues();
        if (!this.getAllValues().contains(this.mDefaultValue)) {
            Object v1;
            AttributeEditorModel attributeEditorModel;
            if (list.isEmpty()) {
                attributeEditorModel = this;
                v1 = null;
            } else {
                attributeEditorModel = this;
                v1 = list.get(0);
            }
            attributeEditorModel.setDefaultValue(v1);
        }
    }

    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(Object object) {
        Object object2 = this.mDefaultValue;
        this.mDefaultValue = object;
        this.firePropertyChange(DefaultValue, object2);
    }

    public boolean isUsed() {
        return this.mUsed;
    }

    public static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

