/*
 * Decompiled with CFR 0.152.
 */
package TimeUtilities;

import TimeUtilities.TimeProvider;

public class StopWatch {
    public static final StopWatchFactory DEFAULT_STOP_WATCH_FACTORY = new StopWatchFactory(){

        public StopWatch createStopWatch() {
            return new StopWatch();
        }
    };
    private boolean mIsRunning;
    private long mStartTime;
    private long mElapsedTime;
    private long mCumulativeTime;
    private TimeProvider mTimeProvider;

    public StopWatch() {
        this(TimeProvider.DEFAULT);
    }

    public StopWatch(TimeProvider timeProvider) {
        this.mTimeProvider = timeProvider;
        this.reset();
    }

    protected long getCurrentTime() {
        return this.mTimeProvider.getCurrentTime();
    }

    public synchronized void start() {
        if (this.mIsRunning) {
            throw new IllegalStateException("Stopwatch is already running");
        }
        this.mIsRunning = true;
        this.mStartTime = this.getCurrentTime();
        this.mElapsedTime = 0L;
    }

    public synchronized long stop() {
        long l2 = this.getCurrentTime();
        if (!this.mIsRunning) {
            throw new IllegalStateException("Stopwatch is not running");
        }
        this.mIsRunning = false;
        this.mElapsedTime = l2 - this.mStartTime;
        this.mCumulativeTime += this.mElapsedTime;
        return this.mElapsedTime;
    }

    public synchronized void reset() {
        this.mIsRunning = false;
        this.mStartTime = -1L;
        this.mElapsedTime = 0L;
        this.mCumulativeTime = 0L;
    }

    public synchronized long getElapsedTime() {
        return this.mIsRunning ? this.getCurrentTime() - this.mStartTime : this.mElapsedTime;
    }

    public synchronized long getCumulativeTime() {
        long l2 = this.mIsRunning ? this.getCurrentTime() - this.mStartTime : 0L;
        return this.mCumulativeTime + l2;
    }

    public synchronized String getElapsedTimeUiString() {
        return this.getFormattedTime(this.getElapsedTime());
    }

    public synchronized String getCumulativeTimeUiString() {
        return this.getFormattedTime(this.getCumulativeTime());
    }

    private String getFormattedTime(long l2) {
        if (l2 < 1000L) {
            return l2 + " ms";
        }
        if (l2 < 90000L) {
            return (double)l2 / 1000.0 + " s";
        }
        return (double)l2 / 1000.0 / 60.0 + " m";
    }

    public String toString() {
        return this.getCumulativeTimeUiString();
    }

    public static interface StopWatchFactory {
        public StopWatch createStopWatch();
    }
}

