/*
 * Decompiled with CFR 0.152.
 */
package StringUtilities;

import RuntimeTool.Debug;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class StringEncoder {
    public static String getDefaultStringEncoding() {
        return new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    public static String urlEncodeISO_8859_1(String string, Debug debug) {
        return StringEncoder.urlEncode(string, "ISO-8859-1", debug);
    }

    public static String urlEncodeUTF8(String string, Debug debug) {
        return StringEncoder.urlEncode(string, "UTF-8", debug);
    }

    public static String urlEncode(String string, Debug debug) {
        return StringEncoder.urlEncode(string, "UTF-8", debug);
    }

    private static String urlEncode(String string, String string2, Debug debug) {
        if (string == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.printError("UnsupportedEncodingException while trying to encode (" + string + "). " + unsupportedEncodingException + ". Stack: " + unsupportedEncodingException.getStackTrace());
            return string;
        }
    }
}

