/*
 * Decompiled with CFR 0.152.
 */
package StringUtilities;

import StringUtilities.StringEscape;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class StringConverter {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public static String getPaddedString(String string, char c2, int n2) {
        if (string.length() > n2) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray, 0, n2 - string.length()).concat(string);
    }

    public static String getStringDecAscii(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            stringBuffer.append((int)string.charAt(i2));
        }
        return stringBuffer.toString();
    }

    public static String getStringDecAsciiNonNumeric(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isDigit(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append((int)string.charAt(i2));
        }
        return stringBuffer.toString();
    }

    public static int getIntFromHexString(String string) throws NumberFormatException {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string, 16);
    }

    public static int parseInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static double parseDouble(String string, double d2) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public static String hexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            cArray[2 * i2] = HEX_CHARS[n2 >> 4];
            cArray[2 * i2 + 1] = HEX_CHARS[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] unhexString(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("input string has odd number of characters: '" + string + "'");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            int n2 = Character.digit(c2, 16);
            if (n2 == -1) {
                throw new IllegalArgumentException("invalid hex digit '" + c2 + "' in string '" + string + "'");
            }
            if (i2 % 2 == 0) {
                byArray[i2 / 2] = (byte)(n2 << 4);
                continue;
            }
            int n3 = i2 / 2;
            byArray[n3] = (byte)(byArray[n3] | (byte)n2);
        }
        return byArray;
    }

    public static String makeSqlTuple(String[] stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("empty array not allowed (would generate bad SQL)");
        }
        return StringConverter.makeSqlTuple(Arrays.asList(stringArray));
    }

    public static String makeSqlTuple(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("empty collection not allowed (would generate bad SQL)");
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            string = StringEscape.escapeCharacters(string, "'", "'");
            stringBuffer.append("'").append(string).append("'");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

