/*
 * Decompiled with CFR 0.152.
 */
package Security;

import FileUtilities.FileOperations;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Encrypter {
    public static final String DES = "DES";
    public static final String AES = "AES";
    private static final String UTF8 = "UTF8";
    private static final String CIPHER = "Cipher";
    private String mAlgorithmName;
    private Cipher mEncipher;
    private Cipher mDecipher;

    private Encrypter(SecretKeySpec secretKeySpec) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        this.mAlgorithmName = secretKeySpec.getAlgorithm();
        this.mEncipher = Cipher.getInstance(this.mAlgorithmName);
        this.mDecipher = Cipher.getInstance(this.mAlgorithmName);
        this.mEncipher.init(1, secretKeySpec);
        this.mDecipher.init(2, secretKeySpec);
    }

    public static Encrypter getDesEncrypter(byte[] byArray) throws GeneralSecurityException {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, byArray2.length));
        return new Encrypter(new SecretKeySpec(byArray2, DES));
    }

    public static Encrypter getAesEncrypter(byte[] byArray) throws GeneralSecurityException {
        return new Encrypter(new SecretKeySpec(byArray, AES));
    }

    public String getAlgorithmName() {
        return this.mAlgorithmName;
    }

    public String encrypt(String string) throws GeneralSecurityException, IOException {
        byte[] byArray = string.getBytes(UTF8);
        byte[] byArray2 = this.encrypt(byArray);
        return new BASE64Encoder().encode(byArray2);
    }

    public byte[] encrypt(byte[] byArray) throws GeneralSecurityException {
        return this.mEncipher.doFinal(byArray);
    }

    public String decrypt(String string) throws GeneralSecurityException, IOException {
        byte[] byArray = new BASE64Decoder().decodeBuffer(string);
        byte[] byArray2 = this.decrypt(byArray);
        return new String(byArray2, UTF8);
    }

    public byte[] decrypt(byte[] byArray) throws GeneralSecurityException {
        return this.mDecipher.doFinal(byArray);
    }

    public void encrypt(InputStream inputStream, OutputStream outputStream) throws IOException {
        FilterOutputStream filterOutputStream = new FilterOutputStream(outputStream){

            public void close() throws IOException {
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        CipherOutputStream cipherOutputStream = new CipherOutputStream(filterOutputStream, this.mEncipher);
        FileOperations.copy(inputStream, cipherOutputStream);
        cipherOutputStream.close();
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream) throws IOException {
        FileOperations.copy(new CipherInputStream(inputStream, this.mDecipher), outputStream);
    }

    public SealedObject encrypt(Object object) throws GeneralSecurityException, IOException {
        return new SealedObject((Serializable)object, this.mEncipher);
    }

    public Object decrypt(SealedObject sealedObject) throws GeneralSecurityException, IOException, ClassNotFoundException {
        return sealedObject.getObject(this.mDecipher);
    }

    public static String[] getCryptoImpls() {
        HashSet<String> hashSet = new HashSet<String>();
        Provider[] providerArray = Security.getProviders();
        for (int i2 = 0; i2 < providerArray.length; ++i2) {
            Set<Object> set = providerArray[i2].keySet();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if ((string = string.split(" ")[0]).startsWith("Cipher.")) {
                    hashSet.add(string.substring(CIPHER.length() + 1));
                    continue;
                }
                if (!string.startsWith("Alg.Alias.Cipher.")) continue;
                hashSet.add(string.substring(CIPHER.length() + 11));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static SecretKey getRandomKey(String string) throws GeneralSecurityException {
        return Encrypter.getRandomKey(string, 0);
    }

    public static SecretKey getRandomKey(String string, int n2) throws GeneralSecurityException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string);
        if (n2 > 0) {
            keyGenerator.init(n2);
        }
        return keyGenerator.generateKey();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = Encrypter.getCryptoImpls();
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            System.out.println(stringArray2[i2]);
        }
    }
}

