/*
 * Decompiled with CFR 0.152.
 */
package RuntimeTool;

import RuntimeTool.ControlFile;
import RuntimeTool.ControlFileException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SectionData
implements Map {
    private LinkedHashMap mSectionMap = new LinkedHashMap();
    private boolean mOptional;
    private ControlFile mControlFile;

    SectionData(ControlFile controlFile) {
        this(controlFile, false);
    }

    SectionData(ControlFile controlFile, boolean bl2) {
        this.mControlFile = controlFile;
        this.mOptional = bl2;
    }

    SectionData(SectionData sectionData) {
        this.mSectionMap.putAll(sectionData.mSectionMap);
        this.mOptional = sectionData.mOptional;
        this.mControlFile = sectionData.mControlFile;
    }

    void store(String string, String string2) throws ControlFileException {
        if (this.mSectionMap.containsKey(string)) {
            throw this.mControlFile.syntaxError("key already exists: " + string);
        }
        this.mSectionMap.put(string, string2);
    }

    Map getSectionMap() {
        if (this.mOptional && this.mSectionMap.isEmpty()) {
            return null;
        }
        return this.mSectionMap;
    }

    private UnsupportedOperationException immutable() {
        return new UnsupportedOperationException("SectionData is an immutable map");
    }

    public int size() {
        return this.mSectionMap.size();
    }

    public void clear() {
        throw this.immutable();
    }

    public boolean isEmpty() {
        return this.mSectionMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.mSectionMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mSectionMap.containsValue(object);
    }

    public Collection values() {
        return this.mSectionMap.values();
    }

    public void putAll(Map map) {
        throw this.immutable();
    }

    public Set entrySet() {
        return this.mSectionMap.entrySet();
    }

    public Set keySet() {
        return this.mSectionMap.keySet();
    }

    public Object get(Object object) {
        return this.mSectionMap.get(object);
    }

    public Object remove(Object object) {
        throw this.immutable();
    }

    public Object put(Object object, Object object2) {
        throw this.immutable();
    }
}

