/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import DateUtilities.DateUtilities;
import ReportViewerXml.Order;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.OrderHeaderList;
import ReportViewerXml.OrderList;
import ReportViewerXml.Patient;
import ReportViewerXml.ReportViewer;
import ReportViewerXml.ReportViewerHeader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class ReportViewerModel {
    private final boolean mIheMode;
    private final Map mOrderMap;
    private final Map mOrderHeaderMap;
    private final ReportViewer mReportData;
    private final Predicate mOrderHeaderFilter;

    public ReportViewerModel(ReportViewer reportViewer, Predicate predicate) {
        this.mReportData = reportViewer;
        this.mOrderHeaderFilter = predicate;
        this.mIheMode = this.mReportData.getReportViewerHeader().isIheMode();
        this.changeToCurrentTimezone();
        this.filterOrderHeaders();
        this.mOrderHeaderMap = this.createOrderHeaderMap(this.mReportData.getReportViewerHeader().getOrderHeaderList().getOrderHeaderList());
        this.filterOrders(this.mOrderHeaderMap.keySet());
        this.mOrderMap = this.createOrderMap(this.mReportData.getOrderList().getOrderList());
    }

    public boolean isIheMode() {
        return this.mIheMode;
    }

    public ReportViewer getReportData() {
        return this.mReportData;
    }

    public Map getOrderMap() {
        return this.mOrderMap;
    }

    public Map getOrderHeaderMap() {
        return this.mOrderHeaderMap;
    }

    OrderHeader findBestMatchingOrderHeader(String string) {
        Iterator iterator = this.mOrderHeaderMap.values().iterator();
        while (iterator.hasNext()) {
            OrderHeader orderHeader = (OrderHeader)iterator.next();
            if (!orderHeader.getAccession().equalsIgnoreCase(string)) continue;
            return orderHeader;
        }
        return null;
    }

    private void changeToCurrentTimezone() {
        Patient patient = this.getReportData().getReportViewerHeader().getPatient();
        patient.setBirthDate(DateUtilities.changeToCurrentTimeZone(patient.getBirthDate()));
        List list = this.getReportData().getReportViewerHeader().getOrderHeaderList().getOrderHeaderList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            OrderHeader orderHeader = (OrderHeader)iterator.next();
            orderHeader.setStudyDate(DateUtilities.changeToCurrentTimeZone(orderHeader.getStudyDate()));
            orderHeader.setStudyDateTime(DateUtilities.changeToCurrentTimeZone(orderHeader.getStudyDateTime()));
            orderHeader.setDictatedStudyDate(DateUtilities.changeToCurrentTimeZone(orderHeader.getDictatedStudyDate()));
        }
    }

    private void filterOrders(Set set) {
        OrderList orderList = this.getReportData().getOrderList();
        final ArrayList<Order> arrayList = new ArrayList<Order>();
        Object object = orderList.getOrderList().iterator();
        while (object.hasNext()) {
            Order order = (Order)object.next();
            if (!set.contains(this.getExamId(order))) continue;
            arrayList.add(order);
        }
        object = new OrderList(){

            public int getNumberOfOrders() {
                return arrayList.size();
            }

            public void setNumberOfOrders(int n2) {
                throw new UnsupportedOperationException();
            }

            public List getOrderList() {
                return arrayList;
            }
        };
        this.getReportData().setOrderList((OrderList)object);
    }

    private Map createOrderMap(List list) {
        LinkedHashMap<String, Order> linkedHashMap = new LinkedHashMap<String, Order>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Order order = (Order)list.get(i2);
            if (order == null) continue;
            linkedHashMap.put(this.getExamId(order), order);
        }
        return linkedHashMap;
    }

    private Map createOrderHeaderMap(List list) {
        LinkedHashMap<String, OrderHeader> linkedHashMap = new LinkedHashMap<String, OrderHeader>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            OrderHeader orderHeader = (OrderHeader)list.get(i2);
            if (orderHeader == null) continue;
            linkedHashMap.put(this.getExamId(orderHeader), orderHeader);
        }
        return linkedHashMap;
    }

    private String getExamId(Order order) {
        return this.mIheMode ? order.getPacsKey() : order.getAccession();
    }

    private String getExamId(OrderHeader orderHeader) {
        return this.mIheMode ? orderHeader.getPacsKey() : orderHeader.getAccession();
    }

    private void filterOrderHeaders() {
        ReportViewerHeader reportViewerHeader = this.getReportData().getReportViewerHeader();
        final OrderHeaderList orderHeaderList = reportViewerHeader.getOrderHeaderList();
        final ArrayList arrayList = new ArrayList(orderHeaderList.getOrderHeaderList());
        CollectionUtils.filter(arrayList, (Predicate)this.mOrderHeaderFilter);
        OrderHeaderList orderHeaderList2 = new OrderHeaderList(){

            public int getNumberOfOrderHeaders() {
                return arrayList.size();
            }

            public void setNumberOfOrderHeaders(int n2) {
                throw new UnsupportedOperationException();
            }

            public List getOrderHeaderList() {
                return arrayList;
            }

            public String getStudyDateLabel() {
                return orderHeaderList.getStudyDateLabel();
            }

            public void setStudyDateLabel(String string) {
                throw new UnsupportedOperationException();
            }
        };
        reportViewerHeader.setOrderHeaderList(orderHeaderList2);
    }
}

