/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import DataModels.UserModels.PrivilegeSet;
import GuiUtilities.Icon.IconCache;
import GuiUtilities.Util.AlwaysOnTop;
import ReportViewerLibrary.Export.ExportConfiguration;
import ReportViewerLibrary.Export.ReportExportDialog;
import ReportViewerLibrary.Export.ReportImageProvider;
import ReportViewerLibrary.Gui.ActionHandler;
import ReportViewerLibrary.Gui.ImpressionsTool;
import ReportViewerLibrary.Gui.ListOfOrdersPane;
import ReportViewerLibrary.Gui.OrderStatusProvider;
import ReportViewerLibrary.Gui.PatientDemographicsPane;
import ReportViewerLibrary.Gui.ReportViewerModel;
import ReportViewerLibrary.Gui.ReportsPane;
import ReportViewerLibrary.Preferences.ReportViewerPreferenceProvider;
import ReportViewerLibrary.Util.ReportViewerUtil;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.Patient;
import RuntimeTool.Debug;
import StringUtilities.StringCheck;
import UserXml.XmlUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class ReportViewer
extends JSplitPane {
    public static final String EXPORT_ACTION = "EXPORT";
    public static final String CLOSE_ACTION = "CLOSE";
    public static final String ALWAYS_ON_TOP_ACTION = "ALWAYS_ON_TOP";
    public static final String CHANGE_VIEW_ACTION = "CHANGE_VIEW";
    public static final String ADD_IMPRESSION_ACTION = "ADD_IMPRESSION";
    private static final String EXPORT_LABEL = "Export to PDF";
    private static final String CLOSE_LABEL = "Close";
    private static final String ALWAYS_ON_TOP_LABEL = "Always On Top";
    private static final String CHANGE_VIEW_LABEL = "Change View";
    private static final String ADD_IMPRESSION_LABEL = "Add Impression";
    private final Frame mOwner;
    private final XmlUser mXmlUser;
    private final URL mBaseUrl;
    private final ReportViewerPreferenceProvider mPreferenceProvider;
    private final ActionHandler mActionHandler;
    private final ExportConfiguration mExportConfiguration;
    private final File mTempExportDirectory;
    private final Debug mDebug;
    private ReportViewerModel mModel;
    private ExamId mExamId;
    private boolean mExportEnabled = false;
    private ReportImageProvider mReportImageProvider;
    private final OrderStatusProvider mOrderStatusProvider;
    private JPanel mNorthPane;
    private PatientDemographicsPane mPatientDemographicsPane;
    private ListOfOrdersPane mListOfOrdersPane;
    private ReportsPane mReportsPane;
    private JButton mAddImpressionButton;
    private JButton mExportButton;
    private JButton mCloseButton;
    private JMenu mFileMenu;
    private JMenu mViewMenu;
    private JMenu mToolsMenu;
    private JMenuItem mExportMenuItem;
    private JMenuItem mCloseMenuItem;
    private JCheckBoxMenuItem mAlwaysOnTopCheckboxMenuItem;
    private JMenuItem mChangeViewMenuItem;
    private JMenuItem mAddImpressionMenuItem;
    private IconCache mIconCache = new IconCache();
    private ImpressionsTool mImpressionsTool;

    public ReportViewer(Frame frame, ReportViewerXml.ReportViewer reportViewer, XmlUser xmlUser, URL uRL, String string, String string2, ReportViewerPreferenceProvider reportViewerPreferenceProvider, ActionHandler actionHandler, ReportImageProvider reportImageProvider, ExportConfiguration exportConfiguration, File file, Predicate predicate, Debug debug) {
        this(frame, reportViewer, xmlUser, uRL, string, string2, reportViewerPreferenceProvider, actionHandler, reportImageProvider, exportConfiguration, file, predicate, Collections.EMPTY_MAP, debug);
    }

    public ReportViewer(Frame frame, ReportViewerXml.ReportViewer reportViewer, XmlUser xmlUser, URL uRL, String string, String string2, ReportViewerPreferenceProvider reportViewerPreferenceProvider, ActionHandler actionHandler, ReportImageProvider reportImageProvider, ExportConfiguration exportConfiguration, File file, Predicate predicate, Map map, Debug debug) {
        super(0);
        this.mOwner = frame;
        this.mXmlUser = xmlUser;
        this.mBaseUrl = uRL;
        this.mPreferenceProvider = reportViewerPreferenceProvider;
        this.mActionHandler = actionHandler;
        this.mReportImageProvider = reportImageProvider;
        this.mExportConfiguration = exportConfiguration;
        this.mTempExportDirectory = file;
        this.mOrderStatusProvider = new OrderStatusProviderImpl(map);
        this.mDebug = debug;
        this.mDebug.printTrace("ReportViewer invoked with accessionNumber [" + string + "], requestedProcedureId [" + string2 + "].");
        this.mModel = new ReportViewerModel(reportViewer, predicate);
        this.mDebug.printTrace("ReportViewer obtained report data from server. IHE mode? " + this.mModel.isIheMode());
        this.mExamId = new ExamId(string, string2);
        this.buildMenuBar();
        this.initControlButtons();
        this.buildNorthPane();
        this.buildReportsPane();
        frame.addWindowListener(new WindowHandler());
        this.addPropertyChangeListener(new PropertyChangeHandler());
    }

    void setAlwaysOnTop(boolean bl2) {
        this.mPreferenceProvider.setAlwaysOnTop(bl2);
        AlwaysOnTop.setAlwaysOnTop(this.mOwner, bl2);
        AlwaysOnTop.setAlwaysOnTop(this.mImpressionsTool, bl2);
    }

    public void resetAlwaysOnTop() {
        this.setAlwaysOnTop(this.mPreferenceProvider.isAlwaysOnTop());
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBorder(BorderFactory.createRaisedBevelBorder());
        this.mFileMenu = new JMenu("File", true);
        this.mFileMenu.setRolloverEnabled(true);
        this.mFileMenu.setMnemonic(70);
        this.mViewMenu = new JMenu("View", true);
        this.mViewMenu.setRolloverEnabled(true);
        this.mViewMenu.setMnemonic(86);
        this.mToolsMenu = new JMenu("Tools", true);
        this.mToolsMenu.setRolloverEnabled(true);
        this.mToolsMenu.setMnemonic(84);
        this.mAlwaysOnTopCheckboxMenuItem = new JCheckBoxMenuItem(ALWAYS_ON_TOP_LABEL);
        this.mAlwaysOnTopCheckboxMenuItem.setActionCommand(ALWAYS_ON_TOP_ACTION);
        this.mAlwaysOnTopCheckboxMenuItem.addActionListener(this.mActionHandler);
        this.mAlwaysOnTopCheckboxMenuItem.setSelected(this.mPreferenceProvider.isAlwaysOnTop());
        this.mCloseMenuItem = new JMenuItem(CLOSE_LABEL);
        this.mCloseMenuItem.setActionCommand(CLOSE_ACTION);
        this.mCloseMenuItem.addActionListener(this.mActionHandler);
        this.mExportMenuItem = new JMenuItem(EXPORT_LABEL);
        this.mExportMenuItem.setActionCommand(EXPORT_ACTION);
        this.mExportMenuItem.setEnabled(false);
        this.mExportMenuItem.addActionListener(this.mActionHandler);
        this.mChangeViewMenuItem = new JMenuItem(CHANGE_VIEW_LABEL);
        this.mChangeViewMenuItem.setActionCommand(CHANGE_VIEW_ACTION);
        this.mChangeViewMenuItem.addActionListener(this.mActionHandler);
        this.mAddImpressionMenuItem = new JMenuItem(ADD_IMPRESSION_LABEL);
        this.mAddImpressionMenuItem.setActionCommand(ADD_IMPRESSION_ACTION);
        this.mAddImpressionMenuItem.addActionListener(this.mActionHandler);
        this.enableImpression(true);
        this.mFileMenu.add(this.mExportMenuItem);
        this.mFileMenu.addSeparator();
        this.mFileMenu.add(this.mCloseMenuItem);
        if (AlwaysOnTop.isAvailable()) {
            this.mViewMenu.add(this.mAlwaysOnTopCheckboxMenuItem);
        }
        this.mViewMenu.add(this.mChangeViewMenuItem);
        this.mToolsMenu.add(this.mAddImpressionMenuItem);
        jMenuBar.add(this.mFileMenu);
        jMenuBar.add(this.mViewMenu);
        jMenuBar.add(this.mToolsMenu);
        this.determineRootPane().setJMenuBar(jMenuBar);
    }

    private JRootPane determineRootPane() {
        return ((JFrame)this.mOwner).getRootPane();
    }

    private void buildNorthPane() {
        this.mNorthPane = new JPanel(new BorderLayout());
        this.mNorthPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.buildPatientDemographicsPane(this.mNorthPane);
        this.buildListOfOrdersPane(this.mNorthPane);
        this.setTopComponent(this.mNorthPane);
    }

    private void buildPatientDemographicsPane(JPanel jPanel) {
        this.mPatientDemographicsPane = new PatientDemographicsPane(this.mModel.getReportData().getReportViewerHeader().getPatient());
        jPanel.add("North", this.mPatientDemographicsPane);
    }

    private void buildListOfOrdersPane(JPanel jPanel) {
        this.mListOfOrdersPane = new ListOfOrdersPane(this, this.mModel.getReportData().getReportViewerHeader().getOrderHeaderList(), this.getExamIdForUpdate(), this.mModel.isIheMode(), this.mOrderStatusProvider);
        jPanel.add("Center", this.mListOfOrdersPane);
    }

    private void buildReportsPane() {
        this.mReportsPane = new ReportsPane(this);
        this.mReportsPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setBottomComponent(this.mReportsPane);
    }

    public PatientDemographicsPane getPatienDemographicsPane() {
        return this.mPatientDemographicsPane;
    }

    public ListOfOrdersPane getListOfOrdersPane() {
        return this.mListOfOrdersPane;
    }

    public ReportsPane getReportsPane() {
        return this.mReportsPane;
    }

    public void updateExamId(String string, String string2) {
        this.mDebug.printTrace("ReportViewer updated with accessionNumber [" + string + "], requestedProcedureId [" + string2 + "].");
        this.mExamId = new ExamId(string, string2);
        this.getListOfOrdersPane().updateSelection(this.getExamIdForUpdate());
        this.getReportsPane().update(this.getExamIdForUpdate());
    }

    String getExamIdForUpdate() {
        if (!this.mModel.isIheMode()) {
            return this.mExamId.getAccessionNumber();
        }
        if (this.mExamId.hasRequestedProcedureId()) {
            return this.mExamId.getPacsKey();
        }
        if (this.updateExamIdWithBestMatch(this.mExamId.getAccessionNumber())) {
            return this.mExamId.getPacsKey();
        }
        return null;
    }

    private boolean updateExamIdWithBestMatch(String string) {
        OrderHeader orderHeader = this.mModel.findBestMatchingOrderHeader(string);
        if (orderHeader == null) {
            return false;
        }
        this.mExamId = new ExamId(orderHeader);
        return true;
    }

    public void updateReportImageProvider(ReportImageProvider reportImageProvider) {
        this.mReportImageProvider = reportImageProvider;
    }

    public String getAccession() {
        return this.mExamId.getAccessionNumber();
    }

    public ExamId getExamId() {
        return this.mExamId;
    }

    public boolean isIheMode() {
        return this.mModel.isIheMode();
    }

    public Map getOrderMap() {
        return this.mModel.getOrderMap();
    }

    public Map getOrderHeaderMap() {
        return this.mModel.getOrderHeaderMap();
    }

    public Window getOwner() {
        return this.mOwner;
    }

    public Patient getPatient() {
        return this.mModel.getReportData().getReportViewerHeader().getPatient();
    }

    public XmlUser getUser() {
        return this.mXmlUser;
    }

    String getEitServletBaseURL() {
        try {
            URL uRL = new URL(this.mBaseUrl.getProtocol(), this.mBaseUrl.getHost(), this.mBaseUrl.getPort(), "");
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.mDebug.printException("Unable to create URL for Eit Servlet", malformedURLException);
            return null;
        }
    }

    public void setExportButtonsEnabled(boolean bl2) {
        this.mExportEnabled = bl2;
        this.mExportButton.setEnabled(bl2);
        this.mExportMenuItem.setEnabled(bl2);
    }

    public boolean isExportEnabled() {
        return this.mExportEnabled;
    }

    public void showExportDialog() {
        ReportExportDialog reportExportDialog = new ReportExportDialog(this.mOwner, this, this.mReportImageProvider, this.mExportConfiguration, this.mTempExportDirectory);
        reportExportDialog.show();
    }

    Debug getDebug() {
        return this.mDebug;
    }

    ReportViewerPreferenceProvider getUserPreferences() {
        return this.mPreferenceProvider;
    }

    public boolean isAlwaysOnTopChecked() {
        return this.mAlwaysOnTopCheckboxMenuItem.isSelected();
    }

    public void changeView() {
        this.mReportsPane.changeInformationAreaView();
    }

    private boolean userHasAddImpressionPrivilege() {
        XmlUser xmlUser = this.getUser();
        if (xmlUser == null) {
            return false;
        }
        return xmlUser.getPrivileges().getPrivilegeList().contains(PrivilegeSet.MODIFY_EIT_IMPRESSIONS);
    }

    public IconCache getIconCache() {
        return this.mIconCache;
    }

    ImpressionsTool createImpressionsTool() {
        if (this.mImpressionsTool != null) {
            this.mImpressionsTool.setVisible(true);
            this.mImpressionsTool.setState(0);
            return this.mImpressionsTool;
        }
        this.mImpressionsTool = new ImpressionsTool(this.mOwner, this.mReportsPane, this.mPreferenceProvider, this.getPatient(), this.mXmlUser, this.getEitServletBaseURL(), this.mDebug);
        this.mImpressionsTool.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                ReportViewer.this.mImpressionsTool = null;
            }
        });
        return this.mImpressionsTool;
    }

    public ImpressionsTool getCurrentImpressionTool() {
        return this.mImpressionsTool;
    }

    public JPanel createButtonsPanel() {
        this.determineRootPane().setDefaultButton(this.mCloseButton);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 8;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.mAddImpressionButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.mExportButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.mCloseButton, gridBagConstraints);
        return jPanel;
    }

    private void initControlButtons() {
        this.mAddImpressionButton = new JButton(ADD_IMPRESSION_LABEL, this.mIconCache.getImageIcon("/ReportViewerLibrary/Gui/Icons/plus.png"));
        this.mAddImpressionButton.setActionCommand(ADD_IMPRESSION_ACTION);
        this.mAddImpressionButton.addActionListener(this.mActionHandler);
        this.enableImpression(true);
        this.mExportButton = new JButton(EXPORT_LABEL, this.mIconCache.getImageIcon("/ReportViewerLibrary/Gui/Icons/pdf-format-small.png"));
        this.mExportButton.setActionCommand(EXPORT_ACTION);
        this.mExportButton.addActionListener(this.mActionHandler);
        this.mExportButton.setEnabled(false);
        this.mCloseButton = new JButton(CLOSE_LABEL);
        this.mCloseButton.setActionCommand(CLOSE_ACTION);
        this.mCloseButton.addActionListener(this.mActionHandler);
    }

    void enableImpression(boolean bl2) {
        if (!this.userHasAddImpressionPrivilege()) {
            bl2 = false;
        }
        if (this.mAddImpressionButton != null) {
            this.mAddImpressionButton.setEnabled(bl2);
        }
        if (this.mAddImpressionMenuItem != null) {
            this.mAddImpressionMenuItem.setEnabled(bl2);
        }
    }

    public static String formatPatientBirthDate(Patient patient) {
        Calendar calendar = patient.getBirthDate();
        if (calendar == null) {
            return "";
        }
        return ReportViewerUtil.DEFAULT_DATE_FORMAT.format(calendar.getTime());
    }

    public static String formatOrderHeaderStudyDateTime(OrderHeader orderHeader, String string) {
        if (orderHeader.getStudyDateTime() != null) {
            return ReportViewerUtil.DEFAULT_DATETIME_FORMAT.format(orderHeader.getStudyDateTime().getTime());
        }
        if (orderHeader.getStudyDate() != null) {
            return ReportViewerUtil.DEFAULT_DATE_FORMAT.format(orderHeader.getStudyDate().getTime());
        }
        return string;
    }

    private static class OrderStatusProviderImpl
    implements OrderStatusProvider {
        private final Map mOrderStatusCodesDescription;

        private OrderStatusProviderImpl(Map map) {
            this.mOrderStatusCodesDescription = map;
        }

        public String getStatus(OrderHeader orderHeader) {
            String string = orderHeader.getStatusConfigKey();
            String string2 = orderHeader.getStatus();
            if (this.mOrderStatusCodesDescription == null || string == null) {
                return string2;
            }
            String string3 = (String)this.mOrderStatusCodesDescription.get(string);
            if (string3 == null) {
                return string2;
            }
            return string3 + " - " + string2;
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "dividerLocation") {
                double d2 = (double)ReportViewer.this.getDividerLocation() / ReportViewer.this.getSize().getHeight();
                ReportViewer.this.getUserPreferences().setReportViewerDividerLocation(d2);
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            double d2 = ReportViewer.this.getUserPreferences().getReportViewerDividerLocation();
            ReportViewer.this.setDividerLocation(d2);
        }
    }

    public static class ExamId {
        private String mAccessionNumber;
        private String mRequestedProcedureId = null;

        private ExamId(String string, String string2) {
            this.mAccessionNumber = string;
            this.mRequestedProcedureId = string2;
        }

        private ExamId(OrderHeader orderHeader) {
            this(orderHeader.getAccession(), orderHeader.getRequestedProcedureId());
        }

        public String getAccessionNumber() {
            return this.mAccessionNumber;
        }

        boolean hasRequestedProcedureId() {
            return !StringCheck.isStringEmpty(this.mRequestedProcedureId);
        }

        public String getPacsKey() {
            return this.mAccessionNumber + "^" + this.mRequestedProcedureId;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExamId)) {
                return false;
            }
            ExamId examId = (ExamId)object;
            return StringUtils.equals((String)this.mAccessionNumber, (String)examId.mAccessionNumber) && StringUtils.equals((String)this.mRequestedProcedureId, (String)examId.mRequestedProcedureId);
        }

        public int hashCode() {
            int n2 = this.mAccessionNumber == null ? 0 : this.mAccessionNumber.hashCode();
            int n3 = this.mRequestedProcedureId == null ? 0 : this.mRequestedProcedureId.hashCode();
            return n2 + 17 * n3;
        }
    }
}

