/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import ReportViewerLibrary.Gui.OrderStatusProvider;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.Util.ReportViewerUtil;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.OrderHeaderList;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;

public class ListOfOrdersPane
extends JPanel {
    private static final String STUDY_DATE_KEY = "dateTime";
    private static final String MODALITY_KEY = "modality";
    private static final String STATUS_KEY = "status";
    private static final String EXAM_ID_KEY = "examId";
    private static final String REPORTING_MD_KEY = "reportingMd";
    private static final String REFERRING_PHY_KEY = "referringMd";
    private static final String DESCRIPTION_KEY = "description";
    private static final String STUDY_DATE = "Study Date/Time";
    private static final String MODALITY = "Mod.";
    private static final String STATUS = "Status";
    private static final String EXAM_ID = "Exam";
    private static final String REPORTING_MD = "Reported By";
    private static final String REFERRING_PHY = "Ref. Phys.";
    private static final String DESCRIPTION = "Description";
    private static final int STUDY_DATETIME_INDEX = 0;
    private static final int EXAM_ID_INDEX = 1;
    private static final int MODALITY_INDEX = 2;
    private static final int STATUS_INDEX = 3;
    private static final int REPORTING_MD_INDEX = 4;
    private static final int REFERRING_PHY_INDX = 5;
    private static final int DESCRIPTION_INDEX = 6;
    private static final String COLUMN_ID_KEY = "Column Id";
    private static final String COLUMN_WIDTH_KEY = "Column Width";
    private OrderListTableModel mTableModel;
    private JTable mTableView;
    private JScrollPane mScroller;
    private ReportViewer mReportViewer;
    private String mExamId;
    private String[] mTableColumnNames;
    private final OrderStatusProvider mOrderStatusProvider;

    public ListOfOrdersPane(ReportViewer reportViewer, OrderHeaderList orderHeaderList, String string, boolean bl2, OrderStatusProvider orderStatusProvider) {
        this.mReportViewer = reportViewer;
        this.mExamId = string;
        this.mOrderStatusProvider = orderStatusProvider;
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), " List of Orders ");
        this.createTableColumnNames(orderHeaderList.getStudyDateLabel());
        this.setLayout(new BorderLayout());
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        this.setBorder(titledBorder);
        this.mTableModel = new OrderListTableModel(orderHeaderList.getOrderHeaderList(), this.mTableColumnNames, bl2);
        this.createTable();
        this.addColumnIdentifiers();
        this.mScroller = new JScrollPane(this.mTableView);
        this.mScroller.setPreferredSize(new Dimension(0, 100));
        this.add("Center", this.mScroller);
        this.viewSelectedOrder();
        this.setColumnView();
        this.mTableView.getColumnModel().addColumnModelListener(new TableColumnModelHandler());
    }

    private void createTable() {
        this.mTableView = new JTable(this.mTableModel);
        this.mTableView.setBackground(Color.LIGHT_GRAY);
        this.mTableView.addMouseListener(new MouseHandler());
        this.mTableView.addMouseMotionListener(new MouseMotionHandler());
        this.mTableView.addKeyListener(new KeyboardHandler());
        this.mTableView.setAutoCreateColumnsFromModel(false);
        this.sortAllRowsBy(0, false);
        this.mTableView.setSelectionMode(0);
        this.mTableView.setColumnSelectionAllowed(false);
        this.mTableView.setRowSelectionAllowed(true);
        this.updateSelection(this.mExamId);
    }

    private void viewSelectedOrder() {
        int n2 = this.mTableView.getSelectedRow();
        if (n2 >= 0) {
            Rectangle rectangle = this.mTableView.getCellRect(n2, 0, true);
            int n3 = Math.max(0, (int)rectangle.getY() - (int)rectangle.getHeight() * 2);
            this.mScroller.getViewport().setViewPosition(new Point(0, n3));
        }
    }

    private int getExamIdIndex(String string) {
        this.mExamId = string;
        return this.getExamIdIndex();
    }

    private int getExamIdIndex() {
        if (this.mExamId == null || this.mExamId.length() <= 0) {
            return -1;
        }
        for (int i2 = 0; i2 < this.mTableModel.getRowCount(); ++i2) {
            if (!this.mTableModel.getExamId(i2).equalsIgnoreCase(this.mExamId)) continue;
            return i2;
        }
        return -1;
    }

    public void updateSelection() {
        if (this.mTableView.getRowCount() > 0) {
            int n2 = this.getExamIdIndex();
            if (n2 > -1) {
                this.mTableView.setRowSelectionInterval(n2, n2);
            } else {
                this.mTableView.clearSelection();
            }
        }
    }

    public void updateSelection(String string) {
        if (this.mTableView.getRowCount() > 0) {
            int n2 = this.getExamIdIndex(string);
            if (n2 > -1) {
                this.mTableView.setRowSelectionInterval(n2, n2);
            } else {
                this.mTableView.clearSelection();
            }
        }
    }

    public void sortAllRowsBy(int n2, boolean bl2) {
        this.mTableModel.sort(n2, bl2);
        this.mTableModel.fireTableStructureChanged();
    }

    private void createTableColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringCheck.isStringEmpty(string)) {
            arrayList.add(string);
        } else {
            arrayList.add(STUDY_DATE);
        }
        arrayList.add(EXAM_ID);
        arrayList.add(MODALITY);
        arrayList.add(STATUS);
        arrayList.add(REPORTING_MD);
        arrayList.add(REFERRING_PHY);
        arrayList.add(DESCRIPTION);
        this.mTableColumnNames = arrayList.toArray(new String[0]);
    }

    private void addColumnIdentifiers() {
        this.mTableView.getColumnModel().getColumn(0).setIdentifier(STUDY_DATE_KEY);
        this.mTableView.getColumnModel().getColumn(1).setIdentifier(EXAM_ID_KEY);
        this.mTableView.getColumnModel().getColumn(2).setIdentifier(MODALITY_KEY);
        this.mTableView.getColumnModel().getColumn(3).setIdentifier(STATUS_KEY);
        this.mTableView.getColumnModel().getColumn(4).setIdentifier(REPORTING_MD_KEY);
        this.mTableView.getColumnModel().getColumn(5).setIdentifier(REFERRING_PHY_KEY);
        this.mTableView.getColumnModel().getColumn(6).setIdentifier(DESCRIPTION_KEY);
    }

    private List getColumnPreferenceMaps() {
        ArrayList arrayList = new ArrayList(this.mTableView.getColumnCount());
        for (int i2 = 0; i2 < this.mTableView.getColumnCount(); ++i2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = (String)this.mTableView.getColumnModel().getColumn(i2).getIdentifier();
            String string2 = Integer.toString(this.mTableView.getColumnModel().getColumn(i2).getWidth());
            hashMap.put(COLUMN_ID_KEY, string);
            hashMap.put(COLUMN_WIDTH_KEY, string2);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private int getViewIndexByKey(String string) throws IllegalArgumentException {
        return this.mTableView.getColumnModel().getColumnIndex(string);
    }

    private void setColumnView() {
        List list = null;
        try {
            list = this.mReportViewer.getUserPreferences().getListOfOrdersColumnPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            DebugManager.getDefault().printException("Error reading Report Viewer List Of Orders preferences", backingStoreException);
            return;
        }
        if (list.size() > this.mTableView.getColumnCount()) {
            DebugManager.getDefault().printError("Report Viewer -> Preference column number exceeds view column number");
            return;
        }
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            try {
                String string = (String)map.get(COLUMN_ID_KEY);
                this.mTableView.moveColumn(this.getViewIndexByKey(string), n2);
                int n3 = Integer.valueOf((String)map.get(COLUMN_WIDTH_KEY));
                this.mTableView.getColumnModel().getColumn(n2).setPreferredWidth(n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugManager.getDefault().printException("Report Viewer List of Orders Preference column", illegalArgumentException);
            }
            ++n2;
        }
    }

    private void saveColumnInformation() {
        try {
            this.mReportViewer.getUserPreferences().setListOfOrdersColumnPreferences(this.getColumnPreferenceMaps());
        }
        catch (BackingStoreException backingStoreException) {
            DebugManager.getDefault().printException("Error writing Report Viewer List Of Orders preferences", backingStoreException);
        }
    }

    class TableColumnModelHandler
    implements TableColumnModelListener {
        TableColumnModelHandler() {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            ListOfOrdersPane.this.saveColumnInformation();
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            ListOfOrdersPane.this.saveColumnInformation();
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }
    }

    class KeyboardHandler
    extends KeyAdapter {
        KeyboardHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n2;
            int n3 = ListOfOrdersPane.this.mTableView.getRowCount();
            if (keyEvent.getKeyCode() == 38) {
                int n4 = ListOfOrdersPane.this.mTableView.getSelectedRow();
                if (n4 > 0) {
                    ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(--n4);
                    ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
                }
            } else if (keyEvent.getKeyCode() == 40 && (n2 = ListOfOrdersPane.this.mTableView.getSelectedRow()) != n3 - 1) {
                ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(++n2);
                ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
            }
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n2 = ListOfOrdersPane.this.mTableView.rowAtPoint(mouseEvent.getPoint());
            if (n2 >= 0 && n2 < ListOfOrdersPane.this.mTableView.getRowCount()) {
                ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(n2);
                ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2 = ListOfOrdersPane.this.mTableView.rowAtPoint(mouseEvent.getPoint());
            ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(n2);
            ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n2 = ListOfOrdersPane.this.mTableView.rowAtPoint(mouseEvent.getPoint());
            ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(n2);
            ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
        }
    }

    private class OrderListTableModel
    extends DefaultTableModel {
        private List mOrderHeaderList;
        private String[] mColumnNames;
        private boolean mIheMode;

        public OrderListTableModel(List list, String[] stringArray, boolean bl2) {
            super(list.size(), stringArray.length);
            this.mOrderHeaderList = list;
            this.mColumnNames = stringArray;
            this.mIheMode = bl2;
        }

        private int compareOrderHeaders(OrderHeader orderHeader, OrderHeader orderHeader2, int n2) {
            switch (n2) {
                case 0: {
                    return ReportViewerUtil.compareOrderDateTimes(orderHeader, orderHeader2);
                }
                case 1: {
                    return this.compareStrings(orderHeader.getAccession(), orderHeader2.getAccession());
                }
                case 2: {
                    return this.compareStrings(orderHeader.getModality(), orderHeader2.getModality());
                }
                case 3: {
                    return this.compareStrings(ListOfOrdersPane.this.mOrderStatusProvider.getStatus(orderHeader), ListOfOrdersPane.this.mOrderStatusProvider.getStatus(orderHeader2));
                }
                case 4: {
                    return this.compareStrings(orderHeader.getReportingMd(), orderHeader2.getReportingMd());
                }
                case 5: {
                    return this.compareStrings(orderHeader.getReferringPhysician(), orderHeader2.getReferringPhysician());
                }
                case 6: {
                    return this.compareStrings(orderHeader.getDescription(), orderHeader2.getDescription());
                }
            }
            return 0;
        }

        private int compareStrings(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            return string.compareTo(string2);
        }

        public void sort(int n2, boolean bl2) {
            Comparator comparator = new Comparator(this, bl2, n2){
                int ascendingFactor;
                private final /* synthetic */ boolean val$ascending;
                private final /* synthetic */ int val$column;
                private final /* synthetic */ OrderListTableModel this$1;
                {
                    this.this$1 = orderListTableModel;
                    this.val$ascending = bl2;
                    this.val$column = n2;
                    this.ascendingFactor = this.val$ascending ? 1 : -1;
                }

                public int compare(Object object, Object object2) {
                    OrderHeader orderHeader = (OrderHeader)object;
                    OrderHeader orderHeader2 = (OrderHeader)object2;
                    int n2 = OrderListTableModel.access$100(this.this$1, orderHeader, orderHeader2, this.val$column);
                    if (n2 == 0) {
                        return this.ascendingFactor * -1;
                    }
                    return this.ascendingFactor * n2;
                }
            };
            TreeSet treeSet = new TreeSet(comparator);
            treeSet.addAll(this.mOrderHeaderList);
            this.mOrderHeaderList.clear();
            this.mOrderHeaderList.addAll(treeSet);
        }

        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public String getColumnName(int n2) {
            return this.mColumnNames[n2];
        }

        public OrderHeader getOrderHeader(int n2) {
            return (OrderHeader)this.mOrderHeaderList.get(n2);
        }

        public String getExamId(int n2) {
            OrderHeader orderHeader = this.getOrderHeader(n2);
            return this.mIheMode ? orderHeader.getPacsKey() : orderHeader.getAccession();
        }

        public Object getValueAt(int n2, int n3) {
            OrderHeader orderHeader = (OrderHeader)this.mOrderHeaderList.get(n2);
            switch (n3) {
                case 0: {
                    return ReportViewer.formatOrderHeaderStudyDateTime(orderHeader, null);
                }
                case 1: {
                    return this.mIheMode ? orderHeader.getPacsKey() : orderHeader.getAccession();
                }
                case 2: {
                    return orderHeader.getModality();
                }
                case 3: {
                    return ListOfOrdersPane.this.mOrderStatusProvider.getStatus(orderHeader);
                }
                case 4: {
                    return orderHeader.getReportingMd();
                }
                case 5: {
                    return orderHeader.getReferringPhysician();
                }
                case 6: {
                    return orderHeader.getDescription();
                }
            }
            return null;
        }

        static /* synthetic */ int access$100(OrderListTableModel orderListTableModel, OrderHeader orderHeader, OrderHeader orderHeader2, int n2) {
            return orderListTableModel.compareOrderHeaders(orderHeader, orderHeader2, n2);
        }
    }
}

